/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.borders;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import net.sourceforge.napkinlaf.borders.AbstractNapkinBorder;
import net.sourceforge.napkinlaf.borders.NapkinBoxBorder;
import net.sourceforge.napkinlaf.shapes.AbstractDrawnGenerator;
import net.sourceforge.napkinlaf.shapes.DrawnCubicLineGenerator;
import net.sourceforge.napkinlaf.shapes.DrawnLineHolder;

public class NapkinLineBorder
extends AbstractNapkinBorder {
    private final boolean vertical;
    private DrawnLineHolder line;

    public NapkinLineBorder(boolean vertical) {
        this.vertical = vertical;
    }

    protected Insets doGetBorderInsets(Component c, Insets insets) {
        if (this.vertical) {
            insets.set(0, 0, 0, NapkinBoxBorder.SMALL_DEFAULT_INSETS.right);
        } else {
            insets.set(0, 0, NapkinBoxBorder.SMALL_DEFAULT_INSETS.bottom, 0);
        }
        return insets;
    }

    public void doPaintBorder(Component c, Graphics g1, int x, int y, int width, int height) {
        Graphics2D g = (Graphics2D)g1;
        Rectangle passed = new Rectangle(x, y, width, height);
        if (this.line == null) {
            this.line = new DrawnLineHolder((AbstractDrawnGenerator)DrawnCubicLineGenerator.INSTANCE, this.vertical);
        }
        this.line.shapeUpToDate(passed, null);
        Insets insets = this.getBorderInsets(c);
        if (insets.bottom != 0) {
            y += c.getHeight() - insets.bottom;
        } else {
            x += c.getWidth() - insets.right;
        }
        g.translate(x, y);
        this.line.draw(g);
        g.translate(-x, -y);
    }
}

