/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.AliasInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.db.DataCache;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.util.IdentifierFactory;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IIdentifierFactory;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

class AliasWindowFactory
implements AliasInternalFrame.IMaintenanceType {
    private static final ILogger s_log = LoggerController.createLogger(AliasWindowFactory.class);
    private final IApplication _app;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AliasWindowFactory.class);
    private Map<IIdentifier, AliasInternalFrame> _modifySheets = new HashMap<IIdentifier, AliasInternalFrame>();

    public AliasWindowFactory(IApplication app) {
        if (app == null) {
            throw new IllegalArgumentException("IApplication == null");
        }
        this._app = app;
    }

    public synchronized AliasInternalFrame getModifySheet(ISQLAlias alias) {
        if (alias == null) {
            throw new IllegalArgumentException("ISQLALias == null");
        }
        AliasInternalFrame sheet = this.get(alias);
        if (sheet == null) {
            sheet = new AliasInternalFrame(this._app, alias, 2);
            this._modifySheets.put(alias.getIdentifier(), sheet);
            this._app.getMainFrame().addWidget(sheet);
            sheet.addWidgetListener(new WidgetAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void widgetClosed(WidgetEvent evt) {
                    AliasWindowFactory aliasWindowFactory = AliasWindowFactory.this;
                    synchronized (aliasWindowFactory) {
                        AliasInternalFrame frame = (AliasInternalFrame)evt.getWidget();
                        AliasWindowFactory.this._modifySheets.remove(frame.getSQLAlias().getIdentifier());
                    }
                }
            });
            DialogWidget.centerWithinDesktop(sheet);
        }
        return sheet;
    }

    public AliasInternalFrame getCreateSheet() {
        DataCache cache = this._app.getDataCache();
        IIdentifierFactory factory = IdentifierFactory.getInstance();
        SQLAlias alias = cache.createAlias(factory.createIdentifier());
        AliasInternalFrame sheet = new AliasInternalFrame(this._app, alias, 1);
        this._app.getMainFrame().addWidget(sheet);
        DialogWidget.centerWithinDesktop(sheet);
        return sheet;
    }

    public AliasInternalFrame getCopySheet(SQLAlias alias) {
        if (alias == null) {
            throw new IllegalArgumentException("ISQLALias == null");
        }
        DataCache cache = this._app.getDataCache();
        IIdentifierFactory factory = IdentifierFactory.getInstance();
        SQLAlias newAlias = cache.createAlias(factory.createIdentifier());
        try {
            newAlias.assignFrom(alias, false);
            if (2 == newAlias.getSchemaProperties().getGlobalState()) {
                this._app.getMessageHandler().showWarningMessage(s_stringMgr.getString("AliasWindowFactory.schemaPropsCopiedWarning"));
            }
            this._app.getPluginManager().aliasCopied(alias, newAlias);
        }
        catch (ValidationException ex) {
            s_log.error(s_stringMgr.getString("AliasWindowFactory.error.copyAlias"), ex);
        }
        AliasInternalFrame sheet = new AliasInternalFrame(this._app, newAlias, 3);
        this._app.getMainFrame().addWidget(sheet);
        DialogWidget.centerWithinDesktop(sheet);
        return sheet;
    }

    private AliasInternalFrame get(ISQLAlias alias) {
        return this._modifySheets.get(alias.getIdentifier());
    }
}

