/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.gui.mainframe.MainFrame;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class EditAliasFolderDlg
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(EditAliasFolderDlg.class);
    private JTextField _txtFolderName = new JTextField();
    private JButton _btnOK = new JButton(s_stringMgr.getString("EditAliasFolderDlg.OK"));
    private JButton _btnCancel = new JButton(s_stringMgr.getString("EditAliasFolderDlg.Cancel"));
    private String _folderName;

    public EditAliasFolderDlg(MainFrame mainFrame, String title, String text, String folderName) {
        super(mainFrame, title, true);
        this.createUI(text);
        this._txtFolderName.setText(folderName);
        this._btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditAliasFolderDlg.this.onOK();
            }
        });
        this.getRootPane().setDefaultButton(this._btnOK);
        this._btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditAliasFolderDlg.this.onCancel();
            }
        });
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditAliasFolderDlg.this.close();
            }
        };
        KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().getInputMap(1).put(escapeStroke, "CloseAction");
        this.getRootPane().getInputMap(2).put(escapeStroke, "CloseAction");
        this.getRootPane().getInputMap(0).put(escapeStroke, "CloseAction");
        this.getRootPane().getActionMap().put("CloseAction", closeAction);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditAliasFolderDlg.this._txtFolderName.requestFocus();
            }
        });
        this.setSize(400, 150);
    }

    private void onCancel() {
        this.close();
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void onOK() {
        if (null == this._txtFolderName.getText() || 0 == this._txtFolderName.getText().trim().length()) {
            JOptionPane.showConfirmDialog(this, s_stringMgr.getString("EditAliasFolderDlg.FolderNameEmpty"));
            return;
        }
        this._folderName = this._txtFolderName.getText();
        this.close();
    }

    private void createUI(String text) {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)new JLabel(text), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)this._txtFolderName, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)this.createButtonPanel(), gbc);
    }

    private JPanel createButtonPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)this._btnOK, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)this._btnCancel, gbc);
        return ret;
    }

    public String getFolderName() {
        return this._folderName;
    }
}

