/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JToggleButton;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.DockFrame;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.DockHandleEvent;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.DockHandleListener;

public class DockHandle {
    private String _title;
    private DockFrame _dockFrame;
    private JToggleButton _btn;
    private ArrayList<DockHandleListener> _dockHandleListeners = new ArrayList();
    private static final String PREFS_KEY_DOCK_DIVIDER_LOC = "squirrelSql_dock_divider_loc.";
    private IApplication _app;

    public DockHandle(IApplication app, Container comp, String title, JToggleButton btn) {
        this._app = app;
        this._dockFrame = new DockFrame(this._app, comp, title);
        this._title = title;
        this._btn = btn;
        this._dockFrame.getMinimizeButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockHandle.this.closeDock();
            }
        });
        this._btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockHandle.this.fireDockHandleEvent(e);
            }
        });
    }

    private void fireDockHandleEvent(ActionEvent e) {
        DockHandleListener[] clone = this._dockHandleListeners.toArray(new DockHandleListener[this._dockHandleListeners.size()]);
        for (int i = 0; i < clone.length; ++i) {
            if (this._btn.isSelected()) {
                clone[i].dockOpened(new DockHandleEvent(e));
                continue;
            }
            clone[i].dockClosing(new DockHandleEvent(e));
        }
    }

    public DockFrame getDockFrame() {
        return this._dockFrame;
    }

    public int getDividerLocation() {
        return Preferences.userRoot().getInt(PREFS_KEY_DOCK_DIVIDER_LOC + this._title, 150);
    }

    public void storeDividerLocation(int dividerLocation) {
        Preferences.userRoot().putInt(PREFS_KEY_DOCK_DIVIDER_LOC + this._title, dividerLocation);
    }

    public void addDockHandleListener(DockHandleListener dockHandleListener) {
        this._dockHandleListeners.add(dockHandleListener);
    }

    public void removeDockHandleListener(DockHandleListener dockHandleListener) {
        this._dockHandleListeners.remove(dockHandleListener);
    }

    public void openDock() {
        if (!this._btn.isSelected()) {
            this._btn.doClick();
        }
    }

    public void closeDock() {
        if (this._btn.isSelected()) {
            this._btn.doClick();
        }
    }

    public void wasClosedByOtherButton(ActionEvent otherButtonEvent) {
        this.fireDockHandleEvent(otherButtonEvent);
    }

    public boolean isClosed() {
        return !this._btn.isSelected();
    }

    public void mayAutoHide() {
        if (this._dockFrame.isAutoHide()) {
            this.closeDock();
        }
    }
}

