/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.GenericWikiTableConfigurationBean;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.IWikiTableConfiguration;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.IWikiTableConfigurationFactory;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.WikiTableConfigurationFactory;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import org.apache.commons.lang.StringUtils;

public class WikiTablePreferencesPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(WikiTablePreferencesPanel.class);
    private final Insets LABEL_INSETS = new Insets(2, 28, 6, 0);
    private final Insets FIELD_INSETS = new Insets(2, 8, 6, 28);
    private IWikiTableConfigurationFactory wikiTableConfigFactory = WikiTableConfigurationFactory.getInstance();
    private IApplication application;
    private JLabel nameLable = null;
    private JTextField name = null;
    private JLabel tableStartTagLabel = null;
    private JTextField tableStartTag = null;
    private JLabel headerStartTagLabel = null;
    private JTextField headerStartTag = null;
    private JLabel headerCellTagLabel = null;
    private JTextField headerCellTag = null;
    private JLabel headerEndTagLabel = null;
    private JTextField headerEndTag = null;
    private JLabel rowStartTagLabel = null;
    private JTextField rowStartTag = null;
    private JLabel cellTagLabel = null;
    private JTextField cellTag = null;
    private JLabel rowEndTagLabel = null;
    private JTextField rowEndTag = null;
    private JLabel tableEndTagLabel = null;
    private JTextField tableEndTag = null;
    private JLabel noWikiTagLabel = null;
    private JTextField noWikiTag = null;
    private DefaultListModel wikiConfigListModel = null;
    private JList wikiConfigList;
    private JButton newButton;
    private JButton copyButton;
    private JButton deleteButton;
    private JTable exampleTable;
    private JTextArea exampleText;
    private IWikiTableConfiguration currentConfigurationInView;
    private JCheckBox enabled;

    public WikiTablePreferencesPanel() {
        super(new GridBagLayout());
        this.createUserInterface();
    }

    private void createUserInterface() {
        JPanel jp = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        jp.add(this.createOverviewPanel(), gbc);
        gbc.gridy = 1;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        jp.add(this.createNotePanel(), gbc);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 2;
        gbc.gridy = 0;
        gbc.gridx = 1;
        gbc.fill = 1;
        jp.add((Component)this.createDetailPanel(), gbc);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 2;
        gbc.gridy = 0;
        gbc.gridx = 2;
        gbc.fill = 1;
        jp.add(this.createExamplePanel(), gbc);
        JScrollPane sp = new JScrollPane(jp);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)sp, gbc);
    }

    private Component createExamplePanel() {
        JPanel jp = new JPanel(new GridBagLayout());
        jp.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("WikiTablePreferencesPanel.titleExample")));
        GridBagConstraints gbc = new GridBagConstraints();
        Object[][] rowData = new String[][]{{s_stringMgr.getString("WikiTablePreferencesPanel.austria"), s_stringMgr.getString("WikiTablePreferencesPanel.vienna")}, {s_stringMgr.getString("WikiTablePreferencesPanel.italy"), s_stringMgr.getString("WikiTablePreferencesPanel.rome")}};
        Object[] columnNames = new String[]{s_stringMgr.getString("WikiTablePreferencesPanel.country"), s_stringMgr.getString("WikiTablePreferencesPanel.captial")};
        this.exampleTable = new JTable(rowData, columnNames);
        this.exampleTable.setMinimumSize(new Dimension(10, 10));
        JScrollPane sp = new JScrollPane(this.exampleTable);
        sp.setPreferredSize(new Dimension(100, 50));
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weighty = 0.1;
        jp.add((Component)sp, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        jp.add((Component)new JLabel(s_stringMgr.getString("WikiTablePreferencesPanel.titleResultExample")), gbc);
        this.exampleText = new JTextArea(15, 20);
        this.exampleText.setWrapStyleWord(true);
        this.exampleText.setEditable(false);
        this.exampleText.setLineWrap(false);
        gbc.gridy = 2;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        sp = new JScrollPane(this.exampleText);
        jp.add((Component)sp, gbc);
        return jp;
    }

    private Component createNotePanel() {
        JPanel jp = new JPanel();
        jp.setBorder(BorderFactory.createTitledBorder("Note"));
        String text = "<html><body>" + s_stringMgr.getString("WikiTablePreferencesPanel.hintValueVariable") + "<br />" + s_stringMgr.getString("WikiTablePreferencesPanel.hintNewLine") + "</body></html>";
        JLabel label = new JLabel(text);
        jp.add(label);
        return jp;
    }

    private Component createOverviewPanel() {
        JPanel jp = new JPanel(new BorderLayout());
        jp.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("WikiTablePreferencesPanel.titleOverview")));
        this.wikiConfigListModel = new DefaultListModel();
        this.wikiConfigList = new JList(this.wikiConfigListModel);
        this.wikiConfigList.setSelectionMode(0);
        this.wikiConfigList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IWikiTableConfiguration selectedValue = (IWikiTableConfiguration)WikiTablePreferencesPanel.this.wikiConfigList.getSelectedValue();
                        WikiTablePreferencesPanel.this.showDataFor(selectedValue);
                        if (selectedValue != null) {
                            WikiTablePreferencesPanel.this.copyButton.setEnabled(true);
                        } else {
                            WikiTablePreferencesPanel.this.copyButton.setEnabled(false);
                        }
                    }
                });
            }
        });
        JScrollPane sp = new JScrollPane(this.wikiConfigList);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.newButton = new JButton(s_stringMgr.getString("WikiTablePreferencesPanel.new"));
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericWikiTableConfigurationBean newConfig = new GenericWikiTableConfigurationBean();
                this.addNewConfigToList(newConfig);
            }

            private void addNewConfigToList(IWikiTableConfiguration newConfig) {
                WikiTablePreferencesPanel.this.wikiConfigListModel.addElement(newConfig);
                WikiTablePreferencesPanel.this.wikiConfigList.setSelectedValue(newConfig, true);
            }
        });
        buttonPanel.add(this.newButton);
        this.copyButton = new JButton(s_stringMgr.getString("WikiTablePreferencesPanel.copy"));
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IWikiTableConfiguration newConfig = ((IWikiTableConfiguration)WikiTablePreferencesPanel.this.wikiConfigList.getSelectedValue()).copyAsUserSpecific();
                int suffix = 0;
                String originalName = newConfig.getName();
                do {
                    newConfig.setName(originalName + "_" + ++suffix);
                } while (!WikiTablePreferencesPanel.this.isUniqueName(newConfig));
                WikiTablePreferencesPanel.this.addNewConfigToList(newConfig);
            }
        });
        buttonPanel.add(this.copyButton);
        this.deleteButton = new JButton(s_stringMgr.getString("WikiTablePreferencesPanel.delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedIndex = WikiTablePreferencesPanel.this.wikiConfigList.getSelectedIndex();
                WikiTablePreferencesPanel.this.wikiConfigList.setSelectedIndex(0);
                WikiTablePreferencesPanel.this.wikiConfigListModel.remove(selectedIndex);
            }
        });
        buttonPanel.add(this.deleteButton);
        jp.add((Component)sp, "Center");
        jp.add((Component)buttonPanel, "South");
        return jp;
    }

    private JPanel createDetailPanel() {
        JPanel jp = new JPanel(new GridBagLayout());
        jp.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("WikiTablePreferencesPanel.titleDetailPanel")));
        jp.setMinimumSize(new Dimension(400, 50));
        GridBagConstraints gbc = new GridBagConstraints();
        int row = 0;
        this.setLabelConstraints(gbc, row);
        this.nameLable = new JLabel(s_stringMgr.getString("WikiTablePreferencesPanel.name"), 4);
        jp.add((Component)this.nameLable, gbc);
        this.setFieldConstraints(gbc, row);
        this.name = new JTextField(30);
        jp.add((Component)this.name, gbc);
        this.setLabelConstraints(gbc, ++row);
        this.tableStartTagLabel = new JLabel(s_stringMgr.getString("WikiTablePreferencesPanel.tableStartTag"), 4);
        jp.add((Component)this.tableStartTagLabel, gbc);
        this.setFieldConstraints(gbc, row);
        this.tableStartTag = new JTextField(30);
        jp.add((Component)this.tableStartTag, gbc);
        this.setLabelConstraints(gbc, ++row);
        this.headerStartTagLabel = new JLabel(s_stringMgr.getString("WikiTablePreferencesPanel.headerStartTag"), 4);
        jp.add((Component)this.headerStartTagLabel, gbc);
        this.setFieldConstraints(gbc, row);
        this.headerStartTag = new JTextField(30);
        jp.add((Component)this.headerStartTag, gbc);
        this.setLabelConstraints(gbc, ++row);
        this.headerCellTagLabel = new JLabel(s_stringMgr.getString("WikiTablePreferencesPanel.headerCellTag"), 4);
        jp.add((Component)this.headerCellTagLabel, gbc);
        this.setFieldConstraints(gbc, row);
        this.headerCellTag = new JTextField(30);
        jp.add((Component)this.headerCellTag, gbc);
        this.setLabelConstraints(gbc, ++row);
        this.headerEndTagLabel = new JLabel(s_stringMgr.getString("WikiTablePreferencesPanel.headerEndTag"), 4);
        jp.add((Component)this.headerEndTagLabel, gbc);
        this.setFieldConstraints(gbc, row);
        this.headerEndTag = new JTextField(30);
        jp.add((Component)this.headerEndTag, gbc);
        this.setLabelConstraints(gbc, ++row);
        this.rowStartTagLabel = new JLabel(s_stringMgr.getString("WikiTablePreferencesPanel.rowStartTag"), 4);
        jp.add((Component)this.rowStartTagLabel, gbc);
        this.setFieldConstraints(gbc, row);
        this.rowStartTag = new JTextField(30);
        jp.add((Component)this.rowStartTag, gbc);
        this.setLabelConstraints(gbc, ++row);
        this.cellTagLabel = new JLabel(s_stringMgr.getString("WikiTablePreferencesPanel.cellTag"), 4);
        jp.add((Component)this.cellTagLabel, gbc);
        this.setFieldConstraints(gbc, row);
        this.cellTag = new JTextField(30);
        jp.add((Component)this.cellTag, gbc);
        this.setLabelConstraints(gbc, ++row);
        this.rowEndTagLabel = new JLabel(s_stringMgr.getString("WikiTablePreferencesPanel.rowEndTag"), 4);
        jp.add((Component)this.rowEndTagLabel, gbc);
        this.setFieldConstraints(gbc, row);
        this.rowEndTag = new JTextField(30);
        jp.add((Component)this.rowEndTag, gbc);
        this.setLabelConstraints(gbc, ++row);
        this.tableEndTagLabel = new JLabel(s_stringMgr.getString("WikiTablePreferencesPanel.tableEndTag"), 4);
        jp.add((Component)this.tableEndTagLabel, gbc);
        this.setFieldConstraints(gbc, row);
        this.tableEndTag = new JTextField(30);
        jp.add((Component)this.tableEndTag, gbc);
        this.setLabelConstraints(gbc, ++row);
        this.noWikiTagLabel = new JLabel(s_stringMgr.getString("WikiTablePreferencesPanel.noWikiTag"), 4);
        jp.add((Component)this.noWikiTagLabel, gbc);
        this.setFieldConstraints(gbc, row);
        this.noWikiTag = new JTextField(30);
        jp.add((Component)this.noWikiTag, gbc);
        this.setLabelConstraints(gbc, ++row);
        this.noWikiTagLabel = new JLabel(s_stringMgr.getString("WikiTablePreferencesPanel.enabled"), 4);
        jp.add((Component)this.noWikiTagLabel, gbc);
        this.setFieldConstraints(gbc, row);
        this.enabled = new JCheckBox();
        jp.add((Component)this.enabled, gbc);
        this.addFocusLostListeners();
        return jp;
    }

    private void addFocusLostListeners() {
        this.name.addFocusListener(new DetailConfigFocusLostListener(){

            @Override
            public void setValue(IWikiTableConfiguration config) throws IllegalArgumentException {
                String newName = WikiTablePreferencesPanel.this.name.getText();
                config.setName(newName);
                if (!WikiTablePreferencesPanel.this.isUniqueName(config)) {
                    throw new IllegalArgumentException(s_stringMgr.getString("WikiTablePreferencesPanel.errorConfigNotUnique"));
                }
            }
        });
        this.tableStartTag.addFocusListener(new DetailConfigFocusLostListener(){

            @Override
            public void setValue(IWikiTableConfiguration config) throws IllegalArgumentException {
                config.setTableStartTag(WikiTablePreferencesPanel.this.tableStartTag.getText());
            }
        });
        this.headerStartTag.addFocusListener(new DetailConfigFocusLostListener(){

            @Override
            public void setValue(IWikiTableConfiguration config) throws IllegalArgumentException {
                config.setHeaderStartTag(WikiTablePreferencesPanel.this.headerStartTag.getText());
            }
        });
        this.headerCellTag.addFocusListener(new DetailConfigFocusLostListener(){

            @Override
            public void setValue(IWikiTableConfiguration config) throws IllegalArgumentException {
                config.setHeaderCell(WikiTablePreferencesPanel.this.headerCellTag.getText());
            }
        });
        this.headerEndTag.addFocusListener(new DetailConfigFocusLostListener(){

            @Override
            public void setValue(IWikiTableConfiguration config) throws IllegalArgumentException {
                config.setHeaderEndTag(WikiTablePreferencesPanel.this.headerEndTag.getText());
            }
        });
        this.rowStartTag.addFocusListener(new DetailConfigFocusLostListener(){

            @Override
            public void setValue(IWikiTableConfiguration config) throws IllegalArgumentException {
                config.setRowStartTag(WikiTablePreferencesPanel.this.rowStartTag.getText());
            }
        });
        this.cellTag.addFocusListener(new DetailConfigFocusLostListener(){

            @Override
            public void setValue(IWikiTableConfiguration config) throws IllegalArgumentException {
                config.setDataCell(WikiTablePreferencesPanel.this.cellTag.getText());
            }
        });
        this.rowEndTag.addFocusListener(new DetailConfigFocusLostListener(){

            @Override
            public void setValue(IWikiTableConfiguration config) throws IllegalArgumentException {
                config.setRowEndTag(WikiTablePreferencesPanel.this.rowEndTag.getText());
            }
        });
        this.tableEndTag.addFocusListener(new DetailConfigFocusLostListener(){

            @Override
            public void setValue(IWikiTableConfiguration config) throws IllegalArgumentException {
                config.setTableEndTag(WikiTablePreferencesPanel.this.tableEndTag.getText());
            }
        });
        this.noWikiTag.addFocusListener(new DetailConfigFocusLostListener(){

            @Override
            public void setValue(IWikiTableConfiguration config) throws IllegalArgumentException {
                config.setNoWikiTag(WikiTablePreferencesPanel.this.noWikiTag.getText());
            }
        });
        this.enabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IWikiTableConfiguration config = WikiTablePreferencesPanel.this.currentConfigurationInView;
                config.setEnabled(WikiTablePreferencesPanel.this.enabled.isSelected());
            }
        });
    }

    private void setLabelConstraints(GridBagConstraints gbc, int gridy) {
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 0.0;
        gbc.insets = this.LABEL_INSETS;
        gbc.fill = 0;
        gbc.anchor = 13;
    }

    private void setFieldConstraints(GridBagConstraints gbc, int gridy) {
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.insets = this.FIELD_INSETS;
        gbc.fill = 2;
        gbc.anchor = 17;
    }

    public IApplication getApplication() {
        return this.application;
    }

    public void setApplication(IApplication app) {
        this.application = app;
    }

    public void loadData(SquirrelPreferences squirrelPreferences) {
        List<IWikiTableConfiguration> configurations = this.wikiTableConfigFactory.getConfigurations();
        for (IWikiTableConfiguration configuration : configurations) {
            this.wikiConfigListModel.addElement(configuration);
        }
        this.wikiConfigList.setSelectedIndex(0);
        IWikiTableConfiguration selectedValue = (IWikiTableConfiguration)this.wikiConfigList.getSelectedValue();
        this.showDataFor(selectedValue);
        if (selectedValue == null) {
            this.copyButton.setEnabled(false);
        }
    }

    private void showDataFor(IWikiTableConfiguration selectedValue) {
        if (selectedValue != null) {
            this.currentConfigurationInView = selectedValue;
            this.fillDetailPane(selectedValue);
            this.showExample(selectedValue);
        } else {
            this.currentConfigurationInView = null;
            this.enableInputFields(false);
        }
    }

    private void enableInputFields(boolean enabled) {
        this.name.setEnabled(enabled);
        this.tableStartTag.setEnabled(enabled);
        this.headerStartTag.setEnabled(enabled);
        this.headerCellTag.setEnabled(enabled);
        this.headerEndTag.setEnabled(enabled);
        this.rowStartTag.setEnabled(enabled);
        this.cellTag.setEnabled(enabled);
        this.rowEndTag.setEnabled(enabled);
        this.tableEndTag.setEnabled(enabled);
        this.noWikiTag.setEnabled(enabled);
        this.deleteButton.setEnabled(enabled);
        if (this.currentConfigurationInView != null) {
            this.enabled.setEnabled(true);
        } else {
            this.enabled.setEnabled(false);
        }
    }

    private void showExample(IWikiTableConfiguration selectedValue) {
        this.exampleTable.changeSelection(0, 0, false, false);
        this.exampleTable.changeSelection(this.exampleTable.getRowCount() - 1, this.exampleTable.getColumnCount() - 1, true, true);
        String example = selectedValue.createTransformer().transform(this.exampleTable);
        this.exampleText.setText(example);
    }

    private void fillDetailPane(IWikiTableConfiguration config) {
        this.name.setText(config.getName());
        this.tableStartTag.setText(config.getTableStartTag());
        this.headerStartTag.setText(config.getHeaderStartTag());
        this.headerCellTag.setText(config.getHeaderCell());
        this.headerEndTag.setText(config.getHeaderEndTag());
        this.rowStartTag.setText(config.getRowStartTag());
        this.cellTag.setText(config.getDataCell());
        this.rowEndTag.setText(config.getRowEndTag());
        this.tableEndTag.setText(config.getTableEndTag());
        this.noWikiTag.setText(config.getNoWikiTag());
        this.enabled.setSelected(config.isEnabled());
        this.enableInputFields(!config.isReadOnly());
    }

    private void addNewConfigToList(IWikiTableConfiguration newConfig) {
        this.wikiConfigListModel.addElement(newConfig);
        this.wikiConfigList.setSelectedValue(newConfig, true);
    }

    private boolean isUniqueName(IWikiTableConfiguration config) {
        Object[] configArray = this.wikiConfigListModel.toArray();
        boolean unique = true;
        for (Object conf : configArray) {
            if (config == conf || !StringUtils.equalsIgnoreCase((String)config.getName(), (String)((IWikiTableConfiguration)conf).getName())) continue;
            unique = false;
        }
        return unique;
    }

    public void applyChanges() {
        Object[] array = this.wikiConfigListModel.toArray();
        ArrayList<IWikiTableConfiguration> userSpecific = new ArrayList<IWikiTableConfiguration>();
        ArrayList<IWikiTableConfiguration> buildIn = new ArrayList<IWikiTableConfiguration>();
        for (Object object : array) {
            IWikiTableConfiguration config = (IWikiTableConfiguration)object;
            if (!config.isReadOnly()) {
                userSpecific.add(config);
                continue;
            }
            buildIn.add(config);
        }
        this.wikiTableConfigFactory.replaceUserSpecificConfigurations(userSpecific);
        this.wikiTableConfigFactory.replaceBuilInConfiguration(buildIn);
    }

    public IWikiTableConfigurationFactory getWikiTableConfigFactory() {
        return this.wikiTableConfigFactory;
    }

    public void setWikiTableConfigFactory(IWikiTableConfigurationFactory wikiTableConfigFactory) {
        this.wikiTableConfigFactory = wikiTableConfigFactory;
    }

    private abstract class DetailConfigFocusLostListener
    implements FocusListener {
        private DetailConfigFocusLostListener() {
        }

        @Override
        public void focusGained(FocusEvent envent) {
        }

        @Override
        public void focusLost(final FocusEvent event) {
            if (!event.isTemporary()) {
                IWikiTableConfiguration config = WikiTablePreferencesPanel.this.currentConfigurationInView;
                try {
                    this.setValue(config);
                }
                catch (IllegalArgumentException e) {
                    WikiTablePreferencesPanel.this.application.showErrorDialog(e.getMessage());
                    JTextField textField = (JTextField)event.getComponent();
                    String text = textField.getText();
                    System.out.println(text);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            event.getComponent().requestFocus();
                        }
                    });
                }
                WikiTablePreferencesPanel.this.showExample(config);
            }
        }

        public abstract void setValue(IWikiTableConfiguration var1) throws IllegalArgumentException;
    }
}

