/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.ISQLAliasExt;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAliasConnectionProperties;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.ISessionWidget;
import net.sourceforge.squirrel_sql.client.gui.mainframe.MainFrame;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SessionInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SessionPanel;
import net.sourceforge.squirrel_sql.client.mainframe.action.OpenConnectionCommand;
import net.sourceforge.squirrel_sql.client.mainframe.action.OpenConnectionCommandListener;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.JdbcConnectionData;
import net.sourceforge.squirrel_sql.client.session.SessionConnectionKeepAlive;
import net.sourceforge.squirrel_sql.client.session.SimpleSessionListenerManager;
import net.sourceforge.squirrel_sql.client.session.event.SimpleSessionListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IMainPanelTab;
import net.sourceforge.squirrel_sql.client.session.parser.IParserEventsProcessor;
import net.sourceforge.squirrel_sql.client.session.parser.ParserEventsProcessor;
import net.sourceforge.squirrel_sql.client.session.parser.ParserEventsProcessorDummy;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.client.session.schemainfo.SchemaInfo;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.sql.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.QueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnectionState;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.TokenizerSessPropsInteractions;
import net.sourceforge.squirrel_sql.fw.util.DefaultExceptionFormatter;
import net.sourceforge.squirrel_sql.fw.util.ExceptionFormatter;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.NullMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

class Session
implements ISession {
    private static final ILogger s_log = LoggerController.createLogger(Session.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(Session.class);
    private String _title = "";
    private SessionPanel _sessionSheet;
    private final IIdentifier _id;
    private IApplication _app;
    private SQLConnection _conn;
    private ISQLDriver _driver;
    private SQLAlias _alias;
    private final String _user;
    private final String _password;
    private SessionProperties _props;
    private final Map<String, Map<String, Object>> _pluginObjects = new HashMap<String, Map<String, Object>>();
    private IMessageHandler _msgHandler = NullMessageHandler.getInstance();
    private final SchemaInfo _schemaInfo;
    private boolean _closed;
    private List<JComponent> _statusBarToBeAdded = new ArrayList<JComponent>();
    private SQLConnectionListener _connLis = null;
    private ISessionWidget _activeActiveSessionWindow;
    private SessionInternalFrame _sessionInternalFrame;
    private Hashtable<IIdentifier, IParserEventsProcessor> _parserEventsProcessorsByEntryPanelIdentifier = new Hashtable();
    private boolean _finishedLoading = false;
    private boolean _pluginsFinishedLoading = false;
    private boolean customTokenizerInstalled = false;
    private IQueryTokenizer tokenizer = null;
    private DefaultExceptionFormatter formatter = new DefaultExceptionFormatter();
    private SessionConnectionKeepAlive _sessionConnectionKeepAlive = null;
    private SimpleSessionListenerManager _simpleSessionListenerManager;

    public Session(IApplication app, ISQLDriver driver, SQLAlias alias, SQLConnection conn, String user, String password, IIdentifier sessionId) {
        if (app == null) {
            throw new IllegalArgumentException("null IApplication passed");
        }
        if (driver == null) {
            throw new IllegalArgumentException("null ISQLDriver passed");
        }
        if (alias == null) {
            throw new IllegalArgumentException("null ISQLAlias passed");
        }
        if (conn == null) {
            throw new IllegalArgumentException("null SQLConnection passed");
        }
        if (sessionId == null) {
            throw new IllegalArgumentException("sessionId == null");
        }
        this._schemaInfo = new SchemaInfo(app);
        this._app = app;
        this._driver = driver;
        this._alias = new SQLAlias();
        try {
            this._alias.assignFrom(alias, true);
        }
        catch (ValidationException e) {
            throw new RuntimeException(e);
        }
        this._conn = conn;
        this._user = user;
        this._password = password;
        this._id = sessionId;
        this.setupTitle();
        this._props = (SessionProperties)this._app.getSquirrelPreferences().getSessionProperties().clone();
        this._connLis = new SQLConnectionListener();
        this._conn.addPropertyChangeListener(this._connLis);
        this.checkDriverVersion();
        this._app.getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                Session.this._schemaInfo.initialLoad(Session.this);
                Session.this._finishedLoading = true;
            }
        });
        this.startKeepAliveTaskIfNecessary();
        this._simpleSessionListenerManager = new SimpleSessionListenerManager(app, this);
    }

    private void startKeepAliveTaskIfNecessary() {
        SQLAliasConnectionProperties connProps = this._alias.getConnectionProperties();
        if (connProps.isEnableConnectionKeepAlive()) {
            String keepAliveSql = connProps.getKeepAliveSqlStatement();
            long sleepMillis = connProps.getKeepAliveSleepTimeSeconds() * 1000;
            if (StringUtilities.isEmpty(keepAliveSql, true)) {
                String msg = s_stringMgr.getString("alias.properties.no.keepAliveSql");
                this.getApplication().getMessageHandler().showErrorMessage(msg);
                s_log.error(msg);
                return;
            }
            this._sessionConnectionKeepAlive = new SessionConnectionKeepAlive(this._conn, sleepMillis, keepAliveSql, this._alias.getName());
            this._app.getThreadPool().addTask(this._sessionConnectionKeepAlive, "Session Connection Keep-Alive (" + this._alias.getName() + ")");
        }
    }

    private void stopKeepAliveTaskIfNecessary() {
        if (this._sessionConnectionKeepAlive != null) {
            this._sessionConnectionKeepAlive.setStopped(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (!this._closed) {
            if (s_log.isDebugEnabled()) {
                s_log.debug("Closing session: " + this._id);
            }
            this.stopKeepAliveTaskIfNecessary();
            if (null != this._conn) {
                this._conn.removePropertyChangeListener(this._connLis);
            }
            this._connLis = null;
            IParserEventsProcessor[] procs = this._parserEventsProcessorsByEntryPanelIdentifier.values().toArray(new IParserEventsProcessor[0]);
            for (int i = 0; i < procs.length; ++i) {
                try {
                    if (!(procs[i] instanceof ParserEventsProcessor)) continue;
                    ((ParserEventsProcessor)procs[i]).endProcessing();
                    continue;
                }
                catch (Exception e) {
                    if (!s_log.isInfoEnabled()) continue;
                    s_log.info("Error stopping parser event processor", e);
                }
            }
            this._schemaInfo.dispose();
            try {
                this.closeSQLConnection();
            }
            finally {
                this._closed = true;
                if (this._sessionSheet != null) {
                    this._sessionSheet.sessionHasClosed();
                    this._sessionSheet = null;
                }
                if (this._sessionInternalFrame != null) {
                    this._sessionInternalFrame.getSQLPanelAPI().closeAllSQLResultTabs();
                }
            }
            if (s_log.isDebugEnabled()) {
                s_log.debug("Successfully closed session: " + this._id);
            }
        }
    }

    @Override
    public synchronized void commit() {
        try {
            this.getSQLConnection().commit();
            String msg = s_stringMgr.getString("Session.commit");
            this._msgHandler.showMessage(msg);
        }
        catch (Throwable ex) {
            this._msgHandler.showErrorMessage(ex, this.formatter);
        }
    }

    @Override
    public synchronized void rollback() {
        try {
            this.getSQLConnection().rollback();
            String msg = s_stringMgr.getString("Session.rollback");
            this._msgHandler.showMessage(msg);
        }
        catch (Exception ex) {
            this._msgHandler.showErrorMessage(ex, this.formatter);
        }
    }

    @Override
    public IIdentifier getIdentifier() {
        return this._id;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public IApplication getApplication() {
        return this._app;
    }

    @Override
    public ISQLConnection getSQLConnection() {
        this.checkThread();
        return this._conn;
    }

    @Override
    public ISQLDriver getDriver() {
        return this._driver;
    }

    @Override
    public ISQLAliasExt getAlias() {
        return this._alias;
    }

    @Override
    public SessionProperties getProperties() {
        return this._props;
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return this._schemaInfo;
    }

    @Override
    public synchronized Object getPluginObject(IPlugin plugin, String key) {
        if (plugin == null) {
            throw new IllegalArgumentException("Null IPlugin passed");
        }
        if (key == null) {
            throw new IllegalArgumentException("Null key passed");
        }
        Map<String, Object> map = this._pluginObjects.get(plugin.getInternalName());
        if (map == null) {
            map = new HashMap<String, Object>();
            this._pluginObjects.put(plugin.getInternalName(), map);
        }
        return map.get(key);
    }

    @Override
    public void addToToolbar(Action action) {
        this._sessionSheet.addToToolbar(action);
    }

    @Override
    public void addSeparatorToToolbar() {
        this._sessionSheet.addSeparatorToToolbar();
    }

    @Override
    public synchronized Object putPluginObject(IPlugin plugin, String key, Object value) {
        if (plugin == null) {
            throw new IllegalArgumentException("Null IPlugin passed");
        }
        if (key == null) {
            throw new IllegalArgumentException("Null key passed");
        }
        Map<String, Object> map = this._pluginObjects.get(plugin.getInternalName());
        if (map == null) {
            map = new HashMap<String, Object>();
            this._pluginObjects.put(plugin.getInternalName(), map);
        }
        return map.put(key, value);
    }

    @Override
    public synchronized void removePluginObject(IPlugin plugin, String key) {
        if (plugin == null) {
            throw new IllegalArgumentException("Null IPlugin passed");
        }
        if (key == null) {
            throw new IllegalArgumentException("Null key passed");
        }
        Map<String, Object> map = this._pluginObjects.get(plugin.getInternalName());
        if (map != null) {
            map.remove(key);
        }
    }

    @Override
    public synchronized void closeSQLConnection() throws SQLException {
        if (this._conn != null) {
            this.stopKeepAliveTaskIfNecessary();
            try {
                this._conn.close();
            }
            finally {
                this._conn = null;
            }
        }
    }

    @Override
    public JdbcConnectionData getJdbcData() {
        IIdentifier driverID = this._alias.getDriverIdentifier();
        ISQLDriver sqlDriver = this._app.getDataCache().getDriver(driverID);
        return new JdbcConnectionData(sqlDriver.getDriverClassName(), this._alias.getUrl(), this._user, this._password);
    }

    @Override
    public void reconnect() {
        String msg;
        final SQLConnectionState connState = new SQLConnectionState();
        if (this._conn != null) {
            try {
                connState.saveState(this._conn, this.getProperties(), this._msgHandler, this._sessionSheet.getSelectedCatalogFromCatalogsComboBox());
            }
            catch (SQLException ex) {
                s_log.error("Unexpected SQLException", ex);
            }
        }
        final OpenConnectionCommand cmd = new OpenConnectionCommand(this._app, this._alias, this._user, this._password, connState.getConnectionProperties());
        try {
            this.closeSQLConnection();
            this._app.getSessionManager().fireConnectionClosedForReconnect(this);
        }
        catch (SQLException ex) {
            msg = s_stringMgr.getString("Session.error.connclose");
            s_log.error(msg, ex);
            this._msgHandler.showErrorMessage(msg);
            this._msgHandler.showErrorMessage(ex, this.getExceptionFormatter());
        }
        try {
            cmd.execute(new OpenConnectionCommandListener(){

                @Override
                public void openConnectionFinished(Throwable t) {
                    Session.this.reconnectDone(connState, cmd, t);
                }
            });
        }
        catch (Throwable t) {
            msg = s_stringMgr.getString("Session.reconnError", this._alias.getName());
            this._msgHandler.showErrorMessage(msg + "\n" + t.toString());
            s_log.error(msg, t);
            this._app.getSessionManager().fireReconnectFailed(this);
        }
    }

    private void reconnectDone(SQLConnectionState connState, OpenConnectionCommand cmd, Throwable t) {
        try {
            if (null != t) {
                throw t;
            }
            this._conn = cmd.getSQLConnection();
            if (connState != null) {
                connState.restoreState(this._conn, this._msgHandler);
                this.getProperties().setAutoCommit(connState.getAutoCommit());
            }
            String msg = s_stringMgr.getString("Session.reconn", this._alias.getName());
            this._msgHandler.showMessage(msg);
            this._app.getSessionManager().fireReconnected(this);
            this.startKeepAliveTaskIfNecessary();
        }
        catch (Throwable th) {
            String msg = s_stringMgr.getString("Session.reconnError", this._alias.getName());
            this._msgHandler.showErrorMessage(msg + "\n" + th.toString());
            s_log.error(msg, th);
            this._app.getSessionManager().fireReconnectFailed(this);
        }
    }

    @Override
    public void setMessageHandler(IMessageHandler handler) {
        this._msgHandler = handler != null ? handler : NullMessageHandler.getInstance();
    }

    public synchronized void setSessionSheet(SessionPanel child) {
        this._sessionSheet = child;
        if (this._sessionSheet != null) {
            ListIterator<JComponent> it = this._statusBarToBeAdded.listIterator();
            while (it.hasNext()) {
                this.addToStatusBar(it.next());
                it.remove();
            }
        }
    }

    @Override
    public synchronized void setSessionInternalFrame(SessionInternalFrame sif) {
        this._sessionInternalFrame = sif;
        this._activeActiveSessionWindow = sif;
        this._sessionSheet = sif.getSessionPanel();
        ListIterator<JComponent> it = this._statusBarToBeAdded.listIterator();
        while (it.hasNext()) {
            this.addToStatusBar(it.next());
            it.remove();
        }
    }

    @Override
    public synchronized SessionInternalFrame getSessionInternalFrame() {
        return this._sessionInternalFrame;
    }

    @Override
    public synchronized SessionPanel getSessionSheet() {
        return this._sessionSheet;
    }

    @Override
    public void selectMainTab(int tabIndex) {
        this._sessionSheet.selectMainTab(tabIndex);
    }

    @Override
    public int getSelectedMainTabIndex() {
        return this._sessionSheet.getSelectedMainTabIndex();
    }

    @Override
    public IMainPanelTab getSelectedMainTab() {
        return this._sessionSheet.getSelectedMainTab();
    }

    @Override
    public int addMainTab(IMainPanelTab tab) {
        return this._sessionSheet.addMainTab(tab);
    }

    @Override
    public synchronized void addToStatusBar(JComponent comp) {
        if (this._sessionSheet != null) {
            this._sessionSheet.addToStatusBar(comp);
        } else {
            this._statusBarToBeAdded.add(comp);
        }
    }

    @Override
    public synchronized void removeFromStatusBar(JComponent comp) {
        if (this._sessionSheet != null) {
            this._sessionSheet.removeFromStatusBar(comp);
        } else {
            this._statusBarToBeAdded.remove(comp);
        }
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    @Override
    public void setTitle(String newTitle) {
        this._title = newTitle;
    }

    public String toString() {
        return this.getTitle();
    }

    private void setupTitle() {
        String user;
        String catalog = null;
        try {
            catalog = this.getSQLConnection().getCatalog();
        }
        catch (SQLException ex) {
            s_log.error("Error occurred retrieving current catalog from Connection", ex);
        }
        catalog = catalog == null ? "" : "(" + catalog + ")";
        String title = null;
        String string = user = this._user != null ? this._user : "";
        if (this.getApplication().getSquirrelPreferences().getUseShortSessionTitle()) {
            title = this.getAlias().getName();
        } else if (user.length() > 0) {
            String[] args = new String[]{this.getAlias().getName(), catalog, user};
            title = s_stringMgr.getString("Session.title1", args);
        } else {
            String[] args = new String[]{this.getAlias().getName(), catalog};
            title = s_stringMgr.getString("Session.title0", args);
        }
        this._title = this._id + " - " + title;
    }

    @Override
    public IParserEventsProcessor getParserEventsProcessor(IIdentifier entryPanelIdentifier) {
        IParserEventsProcessor pep = this._parserEventsProcessorsByEntryPanelIdentifier.get(entryPanelIdentifier);
        if (null == pep) {
            ISQLPanelAPI panelAPI = this.getSqlPanelApi(entryPanelIdentifier);
            pep = null != panelAPI ? new ParserEventsProcessor(panelAPI, this) : new ParserEventsProcessorDummy();
            this._parserEventsProcessorsByEntryPanelIdentifier.put(entryPanelIdentifier, pep);
        }
        return pep;
    }

    private ISQLPanelAPI getSqlPanelApi(IIdentifier entryPanelIdentifier) {
        ISessionWidget[] frames = this.getApplication().getWindowManager().getAllFramesOfSession(this.getIdentifier());
        for (int i = 0; i < frames.length; ++i) {
            IObjectTreeAPI objectTreeApi;
            IIdentifier findEditorID;
            ISQLPanelAPI sqlPanelAPI;
            IIdentifier id;
            if (frames[i] instanceof SQLInternalFrame && (id = (sqlPanelAPI = ((SQLInternalFrame)frames[i]).getSQLPanelAPI()).getSQLEntryPanel().getIdentifier()).equals(entryPanelIdentifier)) {
                return sqlPanelAPI;
            }
            if (frames[i] instanceof SessionInternalFrame) {
                sqlPanelAPI = ((SessionInternalFrame)frames[i]).getSQLPanelAPI();
                IIdentifier sqlEditorID = sqlPanelAPI.getSQLEntryPanel().getIdentifier();
                if (sqlEditorID.equals(entryPanelIdentifier)) {
                    return sqlPanelAPI;
                }
                IObjectTreeAPI objectTreeApi2 = ((SessionInternalFrame)frames[i]).getObjectTreeAPI();
                IIdentifier findEditorID2 = objectTreeApi2.getFindController().getFindEntryPanel().getIdentifier();
                if (findEditorID2.equals(entryPanelIdentifier)) {
                    return null;
                }
            }
            if (!(frames[i] instanceof ObjectTreeInternalFrame) || !(findEditorID = (objectTreeApi = ((ObjectTreeInternalFrame)frames[i]).getObjectTreeAPI()).getFindController().getFindEntryPanel().getIdentifier()).equals(entryPanelIdentifier)) continue;
            return null;
        }
        throw new IllegalStateException("Session has no entry panel for ID=" + entryPanelIdentifier);
    }

    @Override
    public void setActiveSessionWindow(ISessionWidget activeActiveSessionWindow) {
        this._activeActiveSessionWindow = activeActiveSessionWindow;
    }

    @Override
    public ISessionWidget getActiveSessionWindow() {
        return this._activeActiveSessionWindow;
    }

    @Override
    public ISQLPanelAPI getSQLPanelAPIOfActiveSessionWindow() {
        ISQLPanelAPI sqlPanelAPI;
        if (this.isSessionWidgetActive()) {
            sqlPanelAPI = ((SessionInternalFrame)this._activeActiveSessionWindow).getSQLPanelAPI();
        } else if (this._activeActiveSessionWindow instanceof SQLInternalFrame) {
            sqlPanelAPI = ((SQLInternalFrame)this._activeActiveSessionWindow).getSQLPanelAPI();
        } else {
            throw new IllegalStateException("SQLPanelApi can only be provided for SessionInternalFrame or SQLInternalFrame");
        }
        return sqlPanelAPI;
    }

    @Override
    public boolean isSessionWidgetActive() {
        return this._activeActiveSessionWindow instanceof SessionInternalFrame;
    }

    @Override
    public IObjectTreeAPI getObjectTreeAPIOfActiveSessionWindow() {
        IObjectTreeAPI objectTreeAPI;
        if (this.isSessionWidgetActive()) {
            objectTreeAPI = ((SessionInternalFrame)this._activeActiveSessionWindow).getObjectTreeAPI();
        } else if (this._activeActiveSessionWindow instanceof ObjectTreeInternalFrame) {
            objectTreeAPI = ((ObjectTreeInternalFrame)this._activeActiveSessionWindow).getObjectTreeAPI();
        } else {
            throw new IllegalStateException("ObjectTreeApi can only be provided for SessionInternalFrame or ObjectTreeInternalFrame");
        }
        return objectTreeAPI;
    }

    private void checkDriverVersion() {
        if (!this._app.getSquirrelPreferences().getWarnJreJdbcMismatch()) {
            return;
        }
        String javaVersion = System.getProperty("java.vm.version");
        boolean javaVersionIsAtLeast14 = true;
        if (javaVersion != null && (javaVersion.startsWith("1.1") || javaVersion.startsWith("1.2") || javaVersion.startsWith("1.3"))) {
            javaVersionIsAtLeast14 = false;
        }
        if (!javaVersionIsAtLeast14) {
            return;
        }
        boolean driverIs21Compliant = true;
        SQLDatabaseMetaData md = this._conn.getSQLMetaData();
        try {
            md.supportsResultSetType(1003);
        }
        catch (Throwable e) {
            driverIs21Compliant = false;
        }
        if (!driverIs21Compliant) {
            String msg = s_stringMgr.getString("Session.driverCompliance", this._alias.getName());
            String title = s_stringMgr.getString("Session.driverComplianceTitle");
            this.showMessageDialog(msg, title, 2);
            s_log.info(msg);
            return;
        }
        boolean driverIs30Compliant = true;
        try {
            md.supportsSavepoints();
        }
        catch (Throwable e) {
            if (s_log.isDebugEnabled()) {
                s_log.debug(e);
            }
            driverIs30Compliant = false;
        }
        if (!driverIs30Compliant) {
            String msg = s_stringMgr.getString("Session.driverCompliance3.0", this._alias.getName());
            String title = s_stringMgr.getString("Session.driverComplianceTitle");
            this.showMessageDialog(msg, title, 2);
            if (s_log.isInfoEnabled()) {
                s_log.info(msg);
            }
        }
    }

    private void showMessageDialog(final String message, final String title, final int messageType) {
        final MainFrame f = this._app.getMainFrame();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(f, message, title, messageType);
            }
        });
    }

    private void checkThread() {
    }

    protected void finalize() throws Throwable {
        this._app.getSessionManager().fireSessionFinalized(this._id);
    }

    @Override
    public void setPluginsfinishedLoading(boolean pluginsFinishedLoading) {
        this._pluginsFinishedLoading = pluginsFinishedLoading;
    }

    @Override
    public boolean isfinishedLoading() {
        return this._finishedLoading && this._pluginsFinishedLoading;
    }

    @Override
    public boolean confirmClose() {
        if (this.getActiveSessionWindow() instanceof SQLInternalFrame || this.getActiveSessionWindow() instanceof SessionInternalFrame) {
            return this.getSQLPanelAPIOfActiveSessionWindow().confirmClose();
        }
        return true;
    }

    @Override
    public IQueryTokenizer getQueryTokenizer() {
        if (this.tokenizer == null || !this.customTokenizerInstalled) {
            this.tokenizer = new QueryTokenizer(this._props.getSQLStatementSeparator(), this._props.getStartOfLineComment(), this._props.getRemoveMultiLineComment());
        }
        return this.tokenizer;
    }

    @Override
    public void setQueryTokenizer(IQueryTokenizer aTokenizer) {
        if (aTokenizer == null) {
            throw new IllegalArgumentException("aTokenizer arg cannot be null");
        }
        if (this.customTokenizerInstalled) {
            String currentTokenizer = this.tokenizer.getClass().getName();
            String newTokenizer = this.tokenizer.getClass().getName();
            throw new IllegalStateException("Only one custom query tokenizer can be installed.  Current tokenizer is " + currentTokenizer + ". New tokenizer is " + newTokenizer);
        }
        this.customTokenizerInstalled = true;
        this.tokenizer = aTokenizer;
        TokenizerSessPropsInteractions tep = this.tokenizer.getTokenizerSessPropsInteractions();
        if (tep.isTokenizerDefinesStatementSeparator()) {
            this._props.setSQLStatementSeparator(aTokenizer.getSQLStatementSeparator());
        }
        if (tep.isTokenizerDefinesStatementSeparator()) {
            this._props.setStartOfLineComment(aTokenizer.getLineCommentBegin());
        }
        if (tep.isTokenizerDefinesStatementSeparator()) {
            this._props.setRemoveMultiLineComment(aTokenizer.isRemoveMultiLineComment());
        }
    }

    @Override
    public ISQLDatabaseMetaData getMetaData() {
        if (this._conn != null) {
            return this._conn.getSQLMetaData();
        }
        return null;
    }

    @Override
    public void setExceptionFormatter(ExceptionFormatter formatter) {
        this.formatter.setCustomExceptionFormatter(formatter);
    }

    @Override
    public ExceptionFormatter getExceptionFormatter() {
        return this.formatter;
    }

    @Override
    public String formatException(Throwable th) {
        return this.formatter.format(th);
    }

    @Override
    public void showErrorMessage(String msg) {
        this._msgHandler.showErrorMessage(msg);
    }

    @Override
    public void showErrorMessage(Throwable th) {
        this._msgHandler.showErrorMessage(th, this.formatter);
    }

    @Override
    public void showMessage(String msg) {
        this._msgHandler.showMessage(msg);
    }

    @Override
    public void showMessage(Throwable th) {
        this._msgHandler.showMessage(th, this.formatter);
    }

    @Override
    public void showWarningMessage(String msg) {
        this._msgHandler.showWarningMessage(msg);
    }

    @Override
    public SQLConnection createUnmanagedConnection() {
        SQLConnectionState connState = new SQLConnectionState();
        OpenConnectionCommand cmd = new OpenConnectionCommand(this._app, this._alias, this._user, this._password, connState.getConnectionProperties());
        try {
            cmd.executeAndWait();
        }
        catch (Exception e) {
            this.showErrorMessage(e);
            return null;
        }
        return cmd.getSQLConnection();
    }

    @Override
    public void addSimpleSessionListener(SimpleSessionListener simpleSessionListener) {
        this._simpleSessionListenerManager.addListener(simpleSessionListener);
    }

    @Override
    public void removeSimpleSessionListener(SimpleSessionListener simpleSessionListener) {
        this._simpleSessionListenerManager.removeListener(simpleSessionListener);
    }

    private class SQLConnectionListener
    implements PropertyChangeListener {
        private SQLConnectionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName == null || propName == "catalog") {
                Session.this.setupTitle();
            }
        }
    }
}

