/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableTriggerExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.TriggerParentInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class TriggerParentExpander
implements INodeExpander {
    private static final ILogger s_log = LoggerController.createLogger(TriggerParentExpander.class);
    private ITableTriggerExtractor triggerExtractor = null;

    public void setTableTriggerExtractor(ITableTriggerExtractor extractor) {
        this.triggerExtractor = extractor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ObjectTreeNode> createChildren(ISession session, ObjectTreeNode parentNode) throws SQLException {
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        IDatabaseObjectInfo parentDbinfo = parentNode.getDatabaseObjectInfo();
        ISQLConnection conn = session.getSQLConnection();
        SQLDatabaseMetaData md = session.getSQLConnection().getSQLMetaData();
        String schemaName = parentDbinfo.getSchemaName();
        String catalogName = parentDbinfo.getCatalogName();
        IDatabaseObjectInfo tableInfo = ((TriggerParentInfo)parentDbinfo).getTableInfo();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String tableName = tableInfo.getSimpleName();
            String query = this.triggerExtractor.getTableTriggerQuery();
            if (s_log.isDebugEnabled()) {
                s_log.debug("Getting triggers for table " + tableName + " in schema " + schemaName + " and catalog " + catalogName + " - Running query: " + query);
            }
            pstmt = conn.prepareStatement(query);
            this.triggerExtractor.bindParamters(pstmt, tableInfo);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                DatabaseObjectInfo doi = new DatabaseObjectInfo(catalogName, schemaName, rs.getString(1), DatabaseObjectType.TRIGGER, md);
                childNodes.add(new ObjectTreeNode(session, doi));
            }
            SQLUtilities.closeResultSet(rs, true);
        }
        catch (SQLException e) {
            session.showErrorMessage(e);
            s_log.error("Unexpected exception while extracting triggers for parent dbinfo: " + parentDbinfo, e);
        }
        finally {
            SQLUtilities.closeResultSet(rs, true);
        }
        return childNodes;
    }
}

