/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs;

import java.awt.Component;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JScrollPane;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseObjectTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseSourcePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.LineNumber;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public abstract class BaseSourceTab
extends BaseObjectTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(BaseSourceTab.class);
    private static final ILogger s_log = LoggerController.createLogger(BaseSourceTab.class);
    private final String _hint;
    private String _title;
    private BaseSourcePanel _comp;
    private JScrollPane _scroller;

    public BaseSourceTab(String hint) {
        this(null, hint);
    }

    public BaseSourceTab(String title, String hint) {
        this._title = title != null ? title : s_stringMgr.getString("BaseSourceTab.title");
        this._hint = hint != null ? hint : this._title;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    @Override
    public String getHint() {
        return this._hint;
    }

    @Override
    public void clear() {
    }

    @Override
    public Component getComponent() {
        if (this._scroller == null) {
            if (this._comp == null) {
                this._comp = this.createSourcePanel();
            }
            this._scroller = new JScrollPane(this._comp);
            LineNumber lineNumber = new LineNumber(this._comp);
            this._scroller.setRowHeaderView(lineNumber);
            this._scroller.getVerticalScrollBar().setUnitIncrement(10);
        }
        return this._scroller;
    }

    public void setSourcePanel(BaseSourcePanel panel) {
        this._comp = panel;
    }

    @Override
    protected void refreshComponent() {
        ISession session = this.getSession();
        if (session == null) {
            throw new IllegalStateException("Null ISession");
        }
        if (this._comp == null) {
            this._comp = this.createSourcePanel();
        }
        try {
            PreparedStatement pstmt = this.createStatement();
            try {
                this._comp.load(this.getSession(), pstmt);
            }
            finally {
                SQLUtilities.closeStatement(pstmt);
            }
        }
        catch (SQLException ex) {
            s_log.error(ex);
            session.showErrorMessage(ex);
        }
    }

    protected BaseSourcePanel createSourcePanel() {
        return new DefaultSourcePanel(this.getSession());
    }

    protected abstract PreparedStatement createStatement() throws SQLException;

    private final class DefaultSourcePanel
    extends BaseSourcePanel {
        private static final long serialVersionUID = 1L;

        DefaultSourcePanel(ISession session) {
            super(session);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void load(ISession session, PreparedStatement stmt) {
            this.getTextArea().setText("");
            ResultSet rs = null;
            try {
                rs = stmt.executeQuery();
                StringBuffer buf = new StringBuffer(4096);
                while (rs.next()) {
                    buf.append(rs.getString(1));
                }
                this.getTextArea().setText(buf.toString());
                this.getTextArea().setCaretPosition(0);
            }
            catch (SQLException ex) {
                session.showErrorMessage(ex);
            }
            finally {
                SQLUtilities.closeResultSet(rs);
            }
        }
    }
}

