/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.parser;

import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.SQLSchema;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;

public class SQLSchemaImpl
implements SQLSchema {
    private ISession _session;
    private Hashtable<String, SQLSchema.Table> _tableCache = new Hashtable();
    private SQLDatabaseMetaData _dmd;

    SQLSchemaImpl(ISession session) {
        this._session = session;
        if (this._session != null) {
            this._session.getApplication().getThreadPool().addTask(new Runnable(){

                @Override
                public void run() {
                    ISQLConnection con = SQLSchemaImpl.this._session.getSQLConnection();
                    if (con != null) {
                        SQLSchemaImpl.this._dmd = con.getSQLMetaData();
                    }
                }
            });
        }
    }

    @Override
    public SQLSchema.Table getTable(String catalog, String schema, String name) {
        if (this._session.getSchemaInfo().isTable(name)) {
            String key = this.getKey(catalog, schema, name);
            SQLSchema.Table ret = this._tableCache.get(key);
            if (null == ret) {
                ret = new SQLSchema.Table(catalog, schema, name, this._dmd);
                this._tableCache.put(key, ret);
            }
            return ret;
        }
        return null;
    }

    private String getKey(String catalog, String schema, String name) {
        if (null == catalog) {
            catalog = "null";
        }
        if (null == schema) {
            schema = "null";
        }
        StringBuffer ret = new StringBuffer();
        ret.append(catalog).append(",").append(schema).append(",").append(name);
        return ret.toString();
    }

    @Override
    public List<SQLSchema.Table> getTables(String catalog, String schema, String name) {
        Vector<SQLSchema.Table> ret = new Vector<SQLSchema.Table>();
        String[] tableNames = this._session.getSchemaInfo().getTables();
        for (int i = 0; i < tableNames.length; ++i) {
            String key = this.getKey(catalog, schema, name);
            SQLSchema.Table buf = this._tableCache.get(key);
            if (null == buf) {
                buf = new SQLSchema.Table(catalog, schema, tableNames[i], this._dmd);
                this._tableCache.put(key, buf);
            }
            ret.add(buf);
        }
        return ret;
    }

    @Override
    public SQLSchema.Table getTableForAlias(String alias) {
        return null;
    }
}

