/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.datasetviewer.BlockMode;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultMetaDataTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetWrapper;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.sql.ResultSetReader;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ResultSetDataSet
implements IDataSet {
    private static final ILogger s_log = LoggerController.createLogger(ResultSetDataSet.class);
    private int _iCurrent = -1;
    private Object[] _currentRow;
    private int _columnCount;
    private DataSetDefinition _dataSetDefinition;
    private List<Object[]> _alData;
    private volatile boolean _cancel = false;
    private ResultSetReader _rdr = null;
    private DialectType _dialectType = null;
    private final TableColumnInfo[] tableColumnInfos;
    private boolean _limitDataRead = false;

    public ResultSetDataSet(TableColumnInfo[] tableColumnInfos) {
        this.tableColumnInfos = tableColumnInfos;
    }

    public ResultSetDataSet() {
        this.tableColumnInfos = new TableColumnInfo[0];
    }

    public int setResultSet(ResultSet rs, DialectType dialectType) throws DataSetException {
        return this._setResultSet(new ResultSetWrapper(rs), null, null, false, false, dialectType);
    }

    public void setLimitDataRead(boolean limitDataRead) {
        this._limitDataRead = limitDataRead;
    }

    public int setContentsTabResultSet(ResultSet rs, String fullTableName, DialectType dialectType) throws DataSetException {
        return this._setResultSet(new ResultSetWrapper(rs), fullTableName, null, false, true, dialectType);
    }

    public int setSqlExecutionTabResultSet(ResultSetWrapper rs, String fullTableName, DialectType dialectType) throws DataSetException {
        return this._setResultSet(rs, fullTableName, null, false, true, dialectType);
    }

    public int setResultSet(ResultSet rs, int[] columnIndices, boolean computeWidths, DialectType dialectType) throws DataSetException {
        return this._setResultSet(new ResultSetWrapper(rs), null, columnIndices, computeWidths, false, dialectType);
    }

    private int _setResultSet(ResultSetWrapper rs, String fullTableName, int[] columnIndices, boolean computeWidths, boolean useColumnDefs, DialectType dialectType) throws DataSetException {
        this.reset();
        this._dialectType = dialectType;
        if (columnIndices != null && columnIndices.length == 0) {
            columnIndices = null;
        }
        this._iCurrent = -1;
        this._alData = new ArrayList<Object[]>();
        if (rs == null) {
            return 0;
        }
        try {
            ResultSetMetaData md = rs.getResultSet().getMetaData();
            this._columnCount = columnIndices != null ? columnIndices.length : md.getColumnCount();
            ColumnDisplayDefinition[] colDefs = this.createColumnDefinitions(md, fullTableName, columnIndices, computeWidths);
            this._dataSetDefinition = new DataSetDefinition(colDefs, columnIndices);
            this._rdr = new ResultSetReader(rs, dialectType);
            while (true) {
                if (this._cancel) {
                    return this._alData.size();
                }
                Object[] row = this.createRow(columnIndices, useColumnDefs, colDefs, BlockMode.FIRST_BLOCK);
                if (null == row) break;
                this._alData.add(row);
            }
            return this._alData.size();
        }
        catch (SQLException ex) {
            throw new DataSetException(ex);
        }
    }

    private Object[] createRow(int[] columnIndices, boolean useColumnDefs, ColumnDisplayDefinition[] colDefs, BlockMode blockMode) throws SQLException {
        Object[] row = useColumnDefs ? this._rdr.readRow(colDefs, blockMode, this._limitDataRead) : this._rdr.readRow(blockMode);
        if (row == null) {
            return null;
        }
        if (columnIndices != null) {
            Object[] newRow = new Object[this._columnCount];
            for (int i = 0; i < this._columnCount; ++i) {
                newRow[i] = columnIndices[i] - 1 < row.length ? row[columnIndices[i] - 1] : "Unknown";
            }
            row = newRow;
        }
        return row;
    }

    @Override
    public final int getColumnCount() {
        return this._columnCount;
    }

    @Override
    public DataSetDefinition getDataSetDefinition() {
        return this._dataSetDefinition;
    }

    @Override
    public synchronized boolean next(IMessageHandler msgHandler) throws DataSetException {
        if (++this._iCurrent < this._alData.size()) {
            this._currentRow = this._alData.get(this._iCurrent);
            return true;
        }
        return false;
    }

    @Override
    public Object get(int columnIndex) {
        if (this._currentRow != null) {
            return this._currentRow[columnIndex];
        }
        return null;
    }

    public void cancelProcessing() {
        this._rdr.setStopExecution(true);
        this._cancel = true;
    }

    private ColumnDisplayDefinition[] createColumnDefinitions(ResultSetMetaData md, String fullTableName, int[] columnIndices, boolean computeWidths) throws SQLException {
        int[] colWidths = null;
        if (computeWidths) {
            colWidths = new int[this._columnCount];
            for (int i = 0; i < this._alData.size(); ++i) {
                Object[] row = this._alData.get(i);
                int col = 0;
                while (i < this._columnCount) {
                    int colWidth;
                    if (row[col] != null && (colWidth = row[col].toString().length()) > colWidths[col]) {
                        colWidths[col] = colWidth + 2;
                    }
                    ++i;
                }
            }
        }
        ColumnDisplayDefinition[] columnDefs = new ColumnDisplayDefinition[this._columnCount];
        for (int i = 0; i < this._columnCount; ++i) {
            TableColumnInfo info;
            int precis;
            int idx = columnIndices != null ? columnIndices[i] : i + 1;
            boolean isNullable = true;
            if (md.isNullable(idx) == 0) {
                isNullable = false;
            }
            try {
                precis = md.getPrecision(idx);
            }
            catch (NumberFormatException ignore) {
                precis = Integer.MAX_VALUE;
            }
            boolean isSigned = true;
            try {
                isSigned = md.isSigned(idx);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            boolean isCurrency = false;
            try {
                isCurrency = md.isCurrency(idx);
            }
            catch (SQLException e) {
                s_log.error("Failed to call ResultSetMetaData.isCurrency()", e);
            }
            boolean isAutoIncrement = false;
            try {
                isAutoIncrement = md.isAutoIncrement(idx);
            }
            catch (SQLException e) {
                s_log.error("Failed to call ResultSetMetaData.isAutoIncrement()", e);
            }
            if (i < this.tableColumnInfos.length && (info = this.tableColumnInfos[i]).isNullAllowed() == 0) {
                isNullable = false;
            }
            String columnName = this.getColumnName(i, md, idx);
            String columnTypeName = this.getColumnTypeName(i, md, idx);
            int baseColumnType = this.getColumnType(i, md, idx);
            int columnType = this.fixColumnType(columnName, baseColumnType, columnTypeName);
            columnDefs[i] = new ColumnDisplayDefinition(computeWidths ? colWidths[i] : md.getColumnDisplaySize(idx), fullTableName + ":" + md.getColumnLabel(idx), columnName, md.getColumnLabel(idx), columnType, columnTypeName, isNullable, md.getColumnDisplaySize(idx), precis, md.getScale(idx), isSigned, isCurrency, isAutoIncrement, this._dialectType, this.createResultSetMetaDataTable(md, idx));
        }
        return columnDefs;
    }

    private ResultMetaDataTable createResultSetMetaDataTable(ResultSetMetaData md, int idx) throws SQLException {
        try {
            if (StringUtilities.isEmpty(md.getTableName(idx))) {
                return null;
            }
            return new ResultMetaDataTable(StringUtilities.emptyToNull(md.getCatalogName(idx)), StringUtilities.emptyToNull(md.getSchemaName(idx)), md.getTableName(idx));
        }
        catch (Exception e) {
            s_log.error("Failed to get table info from ResultSetMetaData.", e);
            return null;
        }
    }

    private String getColumnName(int i, ResultSetMetaData md, int idx) throws SQLException {
        if (i < this.tableColumnInfos.length) {
            return this.tableColumnInfos[i].getColumnName();
        }
        return md.getColumnName(idx);
    }

    private String getColumnTypeName(int i, ResultSetMetaData md, int idx) throws SQLException {
        if (i < this.tableColumnInfos.length) {
            return this.tableColumnInfos[i].getTypeName();
        }
        return md.getColumnTypeName(idx);
    }

    private int getColumnType(int i, ResultSetMetaData md, int idx) throws SQLException {
        if (i < this.tableColumnInfos.length) {
            return this.tableColumnInfos[i].getDataType();
        }
        return md.getColumnType(idx);
    }

    private int fixColumnType(String columnName, int columnType, String columnTypeName) {
        int result = columnType;
        if (columnType == 0 && (result = JDBCTypeMapper.getJdbcType(columnTypeName)) == 0) {
            result = 12;
        }
        if (result != columnType && s_log.isDebugEnabled()) {
            s_log.debug("Converting type code for column " + columnName + ". Original column type code and name were Types.NULL and " + columnTypeName + "; New type code is " + JDBCTypeMapper.getJdbcTypeName(result));
        }
        return result;
    }

    private void reset() {
        this._iCurrent = -1;
        this._currentRow = null;
        this._columnCount = 0;
        this._dataSetDefinition = null;
        this._alData = null;
    }

    public void resetCursor() {
        this._iCurrent = -1;
        this._currentRow = null;
    }

    public Object removeRow(int index) {
        if (this._alData.size() > index) {
            return this._alData.remove(index);
        }
        return null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this._dataSetDefinition != null) {
            for (ColumnDisplayDefinition colDef : this._dataSetDefinition.getColumnDefinitions()) {
                String columnName = "Column";
                if (colDef != null) {
                    columnName = colDef.getColumnName();
                }
                result.append(columnName);
                result.append("\t");
            }
            result.append("\n");
        }
        Iterator<Object[]> iterator = this._alData.iterator();
        while (iterator.hasNext()) {
            Object[] row;
            for (Object rowItem : row = (Object[])iterator.next()) {
                if (rowItem == null) {
                    result.append("<null>");
                } else {
                    result.append(rowItem.toString());
                }
                result.append("\t");
            }
            result.append("\n");
        }
        return result.toString();
    }

    public List<Object[]> getAllDataForReadOnly() {
        return this._alData;
    }

    public void readMoreResults() {
        try {
            Object[] row;
            while (null != (row = this.createRow(this._dataSetDefinition.getColumnIndices(), true, this._dataSetDefinition.getColumnDefinitions(), BlockMode.FOLLOW_UP_BLOCK))) {
                this._alData.add(row);
            }
            this.resetCursor();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public int currentRowCount() {
        return this._alData.size();
    }

    public boolean isAllResultsRead() {
        return this._rdr.isAllResultsRead();
    }

    public boolean areAllPossibleResultsOfSQLRead() {
        return this._rdr.areAllPossibleResultsOfSQLRead();
    }

    public void closeStatementAndResultSet() {
        this._rdr.closeStatementAndResultSet();
    }
}

