/*
 * Decompiled with CFR 0.152.
 */
package com.unityjdbc.sourcebuilder;

import com.unityjdbc.sourcebuilder.ExtractStatus;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;

public class ExtractProgressDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static int FrameWidth = 600;
    private static int FrameHeight = 400;
    private JTextArea txtMessages;
    private JButton btnOK;
    private JLabel lblCount;
    private JLabel lblTotal;
    private ExtractStatus status;
    private Timer timer;

    public ExtractProgressDialog(JFrame jFrame, ExtractStatus extractStatus) {
        super(jFrame);
        this.status = extractStatus;
        this.setSize(FrameWidth, FrameHeight);
        this.setTitle("Extraction Progress");
        this.setModal(true);
        this.setLocationRelativeTo(this.getRootPane());
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(4, 1));
        jPanel.add(new JLabel("Extraction Progress", 0));
        JPanel jPanel2 = new JPanel();
        this.lblCount = new JLabel("Count: " + extractStatus.getProcessedTables());
        this.lblTotal = new JLabel("Total: " + extractStatus.getTotalTables());
        jPanel2.add(this.lblCount);
        jPanel2.add(this.lblTotal);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.txtMessages = new JTextArea(5, 40);
        this.txtMessages.setText("");
        JScrollPane jScrollPane = new JScrollPane(this.txtMessages);
        jScrollPane.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        jPanel3.add((Component)jScrollPane, "Center");
        jPanel.add(jPanel3);
        jPanel2 = new JPanel();
        this.btnOK = new JButton("OK");
        this.btnOK.addActionListener(new ButtonListener());
        jPanel2.add(this.btnOK);
        jPanel.add(jPanel2);
        container.add((Component)jPanel, "Center");
        this.setDefaultCloseOperation(1);
        this.setBackground(Color.blue);
        RefreshAction refreshAction = new RefreshAction();
        this.timer = new Timer(100, refreshAction);
        this.timer.start();
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ExtractProgressDialog.this.btnOK) {
                System.exit(1);
            }
        }
    }

    private class RefreshAction
    implements ActionListener {
        private RefreshAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExtractProgressDialog.this.lblCount.setText("Count: " + ExtractProgressDialog.this.status.getProcessedTables());
            ExtractProgressDialog.this.lblTotal.setText("Total: " + ExtractProgressDialog.this.status.getTotalTables());
            ExtractProgressDialog.this.txtMessages.setText("");
            ArrayList<String> arrayList = ExtractProgressDialog.this.status.getMessages();
            for (int i = 0; i < arrayList.size(); ++i) {
                ExtractProgressDialog.this.txtMessages.append(arrayList.get(i) + "\n");
            }
            if (ExtractProgressDialog.this.status.isComplete()) {
                ExtractProgressDialog.this.timer.stop();
                return;
            }
        }
    }
}

