/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.sql.SQLException;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Expression;
import unity.functions.Function;

public class F_Atan2
extends Function {
    private static final long serialVersionUID = 1L;
    private Expression expr1;
    private Expression expr2;

    public F_Atan2(Expression expression, Expression expression2) {
        this.expr1 = expression;
        this.expr2 = expression2;
        this.returnType = this.getReturnType();
    }

    @Override
    public Object evaluate(Tuple tuple) throws SQLException {
        Object object = this.expr1.evaluate(tuple);
        if (object == null) {
            return null;
        }
        Object object2 = this.expr2.evaluate(tuple);
        if (object2 == null) {
            return null;
        }
        if (object instanceof Number && object2 instanceof Number) {
            double d = ((Number)object).doubleValue();
            double d2 = ((Number)object2).doubleValue();
            return new Double(Math.atan2(d, d2));
        }
        return null;
    }

    @Override
    public int getReturnType() {
        return 8;
    }

    public static int[] getParamListTypes() {
        return new int[]{99999, 99999};
    }

    public static String getFunctionName() {
        return "ATAN2";
    }

    @Override
    public String toString(Relation relation) {
        return "ATAN2(" + this.expr1.toString(relation) + ", " + this.expr2.toString(relation) + ")";
    }
}

