/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.sql.SQLException;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.jdbc.UnityDriver;
import unity.operators.Operator;
import unity.predicates.JoinPredicate;

public class MergeJoin
extends Operator {
    private static final long serialVersionUID = 1L;
    private int MERGE_BUFFER_SIZE = 10000;
    private Tuple[] tup;
    private Tuple[] buffer;
    private boolean inBuffer;
    private int numInBuffer;
    private int curBufferPosition;
    private boolean endLeft;
    private JoinPredicate pred;

    public MergeJoin(Operator[] operatorArray, JoinPredicate joinPredicate) {
        super(operatorArray, 0L);
        this.pred = joinPredicate;
        Relation relation = new Relation(this.input[0].getOutputRelation());
        relation.mergeRelation(this.input[1].getOutputRelation());
        this.setOutputRelation(relation);
    }

    @Override
    public void init() throws SQLException {
        int n;
        this.tup = new Tuple[this.numInputs];
        for (n = 0; n < this.numInputs; ++n) {
            this.input[n].init();
            this.tup[n] = new Tuple(this.input[n].getOutputRelation());
        }
        for (n = 0; n < this.numInputs; ++n) {
            this.input[n].next(this.tup[n]);
        }
        this.buffer = new Tuple[this.MERGE_BUFFER_SIZE];
        this.inBuffer = false;
        this.endLeft = false;
    }

    @Override
    public boolean next(Tuple tuple) throws SQLException {
        block0: while (!this.endLeft || this.inBuffer) {
            if (!this.inBuffer) {
                while (true) {
                    if (this.pred.isLessThan(this.tup[0], this.tup[1])) {
                        if (this.input[0].next(this.tup[0])) continue;
                        break block0;
                    }
                    while (this.pred.isLessThan(this.tup[1], this.tup[0])) {
                        if (this.input[1].next(this.tup[1])) continue;
                        break block0;
                    }
                    if (this.pred.isEqual(this.tup[0], this.tup[1])) break;
                }
                this.numInBuffer = 0;
                do {
                    this.buffer[this.numInBuffer] = this.tup[0];
                    ++this.numInBuffer;
                    this.tup[0] = new Tuple();
                    if (this.input[0].next(this.tup[0])) continue;
                    this.endLeft = true;
                    break;
                } while (this.pred.isEqual(this.tup[0], this.tup[1]));
                this.inBuffer = true;
                this.curBufferPosition = 0;
                continue;
            }
            do {
                if (this.curBufferPosition < this.numInBuffer) {
                    return this.outputJoinTuple(this.buffer[this.curBufferPosition++], this.tup[1], tuple);
                }
                this.curBufferPosition = 0;
                if (this.input[1].next(this.tup[1])) continue;
                this.inBuffer = false;
                break block0;
            } while (this.pred.isEqual(this.buffer[0], this.tup[1]));
            this.inBuffer = false;
        }
        return false;
    }

    private boolean outputJoinTuple(Tuple tuple, Tuple tuple2, Tuple tuple3) throws SQLException {
        this.incrementRowsOut();
        tuple3.mergeTuple(tuple, tuple2, this.getOutputRelation(), true);
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(250);
        stringBuilder.append("MERGE JOIN: ");
        stringBuilder.append(this.pred.toString(this.input[0].getOutputRelation(), this.input[1].getOutputRelation()));
        return stringBuilder.toString();
    }

    @Override
    public String getName() {
        return "MERGE JOIN";
    }

    @Override
    public String getDescription() {
        return UnityDriver.i18n.getString("MergeJoin.Description");
    }
}

