/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintData;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintIconHandlerListener;
import net.sourceforge.squirrel_sql.plugins.graph.GraphDesktopController;
import net.sourceforge.squirrel_sql.plugins.graph.GraphLine;
import net.sourceforge.squirrel_sql.plugins.graph.TableFrameController;

public class ConstraintIconHandler {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ConstraintIconHandler.class);
    private ConstraintIconHandlerListener _constraintIconHandlerListener;

    public ConstraintIconHandler(ConstraintIconHandlerListener constraintIconHandlerListener) {
        this._constraintIconHandlerListener = constraintIconHandlerListener;
    }

    void paintJoinIcon(Graphics g, GraphLine line, TableFrameController fkFrameOriginatingFrom, TableFrameController pkFramePointingTo, GraphDesktopController desktopController, ConstraintData constraintData) {
        if (!desktopController.getModeManager().getMode().isQueryBuilder()) {
            return;
        }
        ImageIcon icon = this.getIcon(fkFrameOriginatingFrom, pkFramePointingTo, desktopController, constraintData);
        int imageX = this.getImageX(line, icon);
        int imageY = this.getImageY(line, icon);
        g.drawImage(icon.getImage(), imageX, imageY, null);
    }

    private ImageIcon getIcon(TableFrameController fkFrameOriginatingFrom, TableFrameController pkFramePointingTo, GraphDesktopController desktopController, ConstraintData constraintData) {
        TableFrameController right;
        TableFrameController left;
        if (pkFramePointingTo.getFrame().getLocation().x < fkFrameOriginatingFrom.getFrame().getLocation().x) {
            left = pkFramePointingTo;
            right = fkFrameOriginatingFrom;
        } else {
            left = fkFrameOriginatingFrom;
            right = pkFramePointingTo;
        }
        if (constraintData.getConstraintQueryData().isInnerJoin()) {
            return desktopController.getResource().getIcon("Equal");
        }
        if (constraintData.getConstraintQueryData().isOuterJoinFor(left.getTableInfo().getSimpleName())) {
            return desktopController.getResource().getIcon("EqualLeft");
        }
        if (constraintData.getConstraintQueryData().isOuterJoinFor(right.getTableInfo().getSimpleName())) {
            return desktopController.getResource().getIcon("EqualRight");
        }
        if (constraintData.getConstraintQueryData().isNoJoin()) {
            return desktopController.getResource().getIcon("EqualCrossed");
        }
        throw new IllegalStateException("Could not find Join-Icon");
    }

    private int getImageY(GraphLine line, ImageIcon icon) {
        int yMid = line.getBegin().y + (int)((double)(line.getEnd().y - line.getBegin().y) / 2.0 + 0.5);
        int iHeight = icon.getImage().getHeight(null);
        return yMid - (int)((double)iHeight / 2.0 + 0.5);
    }

    private int getImageX(GraphLine line, ImageIcon icon) {
        int xMid = line.getBegin().x + (int)((double)(line.getEnd().x - line.getBegin().x) / 2.0 + 0.5);
        int iWidth = icon.getImage().getWidth(null);
        return xMid - (int)((double)iWidth / 2.0 + 0.5);
    }

    public boolean hitMe(MouseEvent e, GraphLine line, TableFrameController fkFrameOriginatingFrom, TableFrameController pkFramePointingTo, GraphDesktopController desktopController, ConstraintData constraintData) {
        if (!desktopController.getModeManager().getMode().isQueryBuilder()) {
            return false;
        }
        ImageIcon icon = this.getIcon(fkFrameOriginatingFrom, pkFramePointingTo, desktopController, constraintData);
        int imageX = this.getImageX(line, icon);
        int imageY = this.getImageY(line, icon);
        int hitX = e.getPoint().x;
        int hitY = e.getPoint().y;
        if (imageX < hitX && hitX < imageX + icon.getImage().getWidth(null) && imageY < hitY && hitY < imageY + icon.getImage().getHeight(null)) {
            if (0 != (e.getModifiersEx() & 0x400)) {
                this.showPopup(e, imageX, imageY, pkFramePointingTo, fkFrameOriginatingFrom, desktopController, constraintData);
            }
            return true;
        }
        return false;
    }

    private void showPopup(MouseEvent e, int imageX, int imageY, TableFrameController pkFramePointingTo, TableFrameController fkFrameOriginatingFrom, GraphDesktopController desktopController, final ConstraintData constraintData) {
        TableFrameController right;
        TableFrameController left;
        JPopupMenu popupMenu = new JPopupMenu();
        if (pkFramePointingTo.getFrame().getLocation().x < fkFrameOriginatingFrom.getFrame().getLocation().x) {
            left = pkFramePointingTo;
            right = fkFrameOriginatingFrom;
        } else {
            left = fkFrameOriginatingFrom;
            right = pkFramePointingTo;
        }
        ImageIcon icon = desktopController.getResource().getIcon("Equal");
        String txt = s_stringMgr.getString("ConstraintIconHandler.innerJoin");
        final JRadioButtonMenuItem innerMenuItem = new JRadioButtonMenuItem(txt, icon);
        innerMenuItem.setSelected(constraintData.getConstraintQueryData().isInnerJoin());
        innerMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConstraintIconHandler.this.onInnerMenuItem(innerMenuItem, constraintData);
            }
        });
        icon = desktopController.getResource().getIcon("EqualLeft");
        txt = s_stringMgr.getString("ConstraintIconHandler.outerJoin", new Object[]{left.getTableInfo().getSimpleName()});
        final JRadioButtonMenuItem leftMenuItem = new JRadioButtonMenuItem(txt, icon);
        leftMenuItem.setSelected(constraintData.getConstraintQueryData().isOuterJoinFor(left.getTableInfo().getSimpleName()));
        leftMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConstraintIconHandler.this.onOuterMenuItem(leftMenuItem, constraintData, left.getTableInfo().getSimpleName());
            }
        });
        icon = desktopController.getResource().getIcon("EqualRight");
        txt = s_stringMgr.getString("ConstraintIconHandler.outerJoin", new Object[]{right.getTableInfo().getSimpleName()});
        final JRadioButtonMenuItem rightMenuItem = new JRadioButtonMenuItem(txt, icon);
        rightMenuItem.setSelected(constraintData.getConstraintQueryData().isOuterJoinFor(right.getTableInfo().getSimpleName()));
        rightMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConstraintIconHandler.this.onOuterMenuItem(rightMenuItem, constraintData, right.getTableInfo().getSimpleName());
            }
        });
        icon = desktopController.getResource().getIcon("EqualCrossed");
        txt = s_stringMgr.getString("ConstraintIconHandler.noJoin");
        final JRadioButtonMenuItem noneMenuItem = new JRadioButtonMenuItem(txt, icon);
        noneMenuItem.setSelected(constraintData.getConstraintQueryData().isNoJoin());
        noneMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConstraintIconHandler.this.onNoneMenuItem(noneMenuItem, constraintData);
            }
        });
        ButtonGroup bg = new ButtonGroup();
        bg.add(innerMenuItem);
        bg.add(leftMenuItem);
        bg.add(rightMenuItem);
        bg.add(noneMenuItem);
        popupMenu.add(innerMenuItem);
        popupMenu.add(leftMenuItem);
        popupMenu.add(rightMenuItem);
        popupMenu.add(noneMenuItem);
        popupMenu.show(e.getComponent(), imageX, imageY);
    }

    private void onNoneMenuItem(JRadioButtonMenuItem noneMenuItem, ConstraintData constraintData) {
        if (noneMenuItem.isSelected()) {
            constraintData.getConstraintQueryData().setNoJoin();
            this._constraintIconHandlerListener.constraintTypeChanged();
        }
    }

    private void onOuterMenuItem(JRadioButtonMenuItem leftmenuItem, ConstraintData constraintData, String outerTableName) {
        if (leftmenuItem.isSelected()) {
            constraintData.getConstraintQueryData().setOuterJoin(outerTableName);
            this._constraintIconHandlerListener.constraintTypeChanged();
        }
    }

    private void onInnerMenuItem(JRadioButtonMenuItem innerMenuItem, ConstraintData constraintData) {
        if (innerMenuItem.isSelected()) {
            constraintData.getConstraintQueryData().setInnerJoin();
            this._constraintIconHandlerListener.constraintTypeChanged();
        }
    }
}

