/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.informix.exception;

import java.lang.reflect.Method;
import java.sql.Connection;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.event.ISessionListener;
import net.sourceforge.squirrel_sql.client.session.event.SessionAdapter;
import net.sourceforge.squirrel_sql.client.session.event.SessionEvent;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.util.DefaultExceptionFormatter;
import net.sourceforge.squirrel_sql.fw.util.ExceptionFormatter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class InformixExceptionFormatter
extends SessionAdapter
implements ISessionListener,
ExceptionFormatter {
    private ISQLEntryPanel sqlEntryPanel = null;
    private ISession _session = null;
    private static final DefaultExceptionFormatter defaultFormatter = new DefaultExceptionFormatter();
    private static final ILogger s_log = LoggerController.createLogger(InformixExceptionFormatter.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(InformixExceptionFormatter.class);

    public InformixExceptionFormatter(ISession session) {
        this.sqlEntryPanel = session.getSQLPanelAPIOfActiveSessionWindow().getSQLEntryPanel();
        this._session = session;
        session.getApplication().getSessionManager().addSessionListener((ISessionListener)this);
    }

    public String format(Throwable t) throws Exception {
        StringBuilder msg = new StringBuilder();
        msg.append(defaultFormatter.format(t));
        ISQLConnection sqlcon = this._session.getSQLConnection();
        if (sqlcon != null && sqlcon.getConnection() != null) {
            int offsetNum;
            String offset = this.getSqlErrorOffset();
            msg.append("\n");
            msg.append(i18n.positionLabel);
            msg.append(offset);
            if (!i18n.NOT_AVAILABLE_MSG.equals(offset) && (offsetNum = this.getNumber(offset, -1)) != -1) {
                int[] bounds = this.sqlEntryPanel.getBoundsOfSQLToBeExecuted();
                int start = bounds[0];
                int newPosition = start + offsetNum - 1;
                this.sqlEntryPanel.setCaretPosition(newPosition);
            }
        } else {
            msg.append(i18n.NOT_AVAILABLE_MSG);
        }
        return msg.toString();
    }

    public boolean formatsException(Throwable t) {
        Utilities.checkNull((String)"formatsException", (Object[])new Object[]{"t", t});
        return true;
    }

    private String getSqlErrorOffset() {
        String result = i18n.NOT_AVAILABLE_MSG;
        try {
            ISQLConnection sqlcon = this._session.getSQLConnection();
            Class<?> conClass = sqlcon.getConnection().getClass();
            Connection ifmxcon = sqlcon.getConnection();
            Method getSQLStatementOffsetMethod = conClass.getMethod("getSQLStatementOffset", null);
            Object offset = getSQLStatementOffsetMethod.invoke((Object)ifmxcon, (Object[])null);
            result = offset.toString();
        }
        catch (Exception e) {
            s_log.error((Object)("getSqlErrorOffset: Unexpected exception - " + e.getMessage()), (Throwable)e);
        }
        return result;
    }

    private int getNumber(String numberStr, int defaultNum) {
        int result = defaultNum;
        try {
            result = Integer.parseInt(numberStr);
        }
        catch (NumberFormatException e) {
            s_log.error((Object)("getNumber: Unexpected exception - " + e.getMessage()), (Throwable)e);
        }
        return result;
    }

    public void allSessionsClosed() {
        this._session.getApplication().getSessionManager().removeSessionListener((ISessionListener)this);
        this._session = null;
    }

    public void sessionClosed(SessionEvent evt) {
        if (evt.getSession() == this._session) {
            this._session.getApplication().getSessionManager().removeSessionListener((ISessionListener)this);
            this._session = null;
        }
    }

    public void sessionClosing(SessionEvent evt) {
        if (evt.getSession() == this._session) {
            this._session.getApplication().getSessionManager().removeSessionListener((ISessionListener)this);
            this._session = null;
        }
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String NOT_AVAILABLE_MSG = InformixExceptionFormatter.access$000().getString("InformixExceptionFormatter.notAvailableMsg");
        public static final String positionLabel = InformixExceptionFormatter.access$000().getString("InformixExceptionFormatter.positionLabel");
    }
}

