/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax;

import java.util.HashMap;
import javax.swing.Action;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SessionInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.ToolsPopupAccessor;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.plugins.syntax.CommentAction;
import net.sourceforge.squirrel_sql.plugins.syntax.ConfigureAutoCorrectAction;
import net.sourceforge.squirrel_sql.plugins.syntax.DuplicateLineAction;
import net.sourceforge.squirrel_sql.plugins.syntax.FindAction;
import net.sourceforge.squirrel_sql.plugins.syntax.FindSelectedAction;
import net.sourceforge.squirrel_sql.plugins.syntax.GoToLineAction;
import net.sourceforge.squirrel_sql.plugins.syntax.MarkSelectedAction;
import net.sourceforge.squirrel_sql.plugins.syntax.RepeatLastFindAction;
import net.sourceforge.squirrel_sql.plugins.syntax.ReplaceAction;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPlugin;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPluginResources;
import net.sourceforge.squirrel_sql.plugins.syntax.UncommentAction;
import net.sourceforge.squirrel_sql.plugins.syntax.UnmarkAction;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.SquirreLRSyntaxTextAreaUI;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.SquirrelRSyntaxTextArea;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.action.SquirrelCopyAsRtfAction;

public class ToolsPopupHandler {
    private SyntaxPlugin _syntaxPugin;

    ToolsPopupHandler(SyntaxPlugin syntaxPugin) {
        this._syntaxPugin = syntaxPugin;
    }

    void initToolsPopup(HashMap<String, Object> props, ISQLEntryPanel isqlEntryPanel) {
        ToolsPopupAccessor tpa = (ToolsPopupAccessor)props.get(ToolsPopupAccessor.class.getName());
        if (null == tpa) {
            return;
        }
        SyntaxPluginResources rsrc = this._syntaxPugin.getResources();
        IApplication app = this._syntaxPugin.getApplication();
        tpa.addToToolsPopup(SyntaxPlugin.i18n.FIND, (Action)((Object)new FindAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(SyntaxPlugin.i18n.FIND_SELECTED, (Action)((Object)new FindSelectedAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(SyntaxPlugin.i18n.REPEAT_LAST_FIND, (Action)((Object)new RepeatLastFindAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(SyntaxPlugin.i18n.MARK_SELECTED, (Action)((Object)new MarkSelectedAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(SyntaxPlugin.i18n.REPLACE, (Action)((Object)new ReplaceAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(SyntaxPlugin.i18n.UNMARK, (Action)((Object)new UnmarkAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(SyntaxPlugin.i18n.GO_TO_LINE, (Action)((Object)new GoToLineAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(SyntaxPlugin.i18n.AUTO_CORR, (Action)((Object)new ConfigureAutoCorrectAction(app, rsrc, this._syntaxPugin)));
        tpa.addToToolsPopup(SyntaxPlugin.i18n.DUP_LINE, (Action)((Object)new DuplicateLineAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(SyntaxPlugin.i18n.COMMENT, (Action)((Object)new CommentAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(SyntaxPlugin.i18n.UNCOMMENT, (Action)((Object)new UncommentAction(app, rsrc, isqlEntryPanel)));
        if (isqlEntryPanel.getTextComponent() instanceof SquirrelRSyntaxTextArea) {
            SquirrelRSyntaxTextArea rsEdit = (SquirrelRSyntaxTextArea)((Object)isqlEntryPanel.getTextComponent());
            Action toUpperAction = SquirreLRSyntaxTextAreaUI.getActionForName(rsEdit, "RTA.UpperCaseAction");
            toUpperAction.putValue("SQuirreLAcceleratorString", "ctrl shift u");
            tpa.addToToolsPopup(SyntaxPlugin.i18n.TO_UPPER_CASE, toUpperAction);
            Action toLowerAction = SquirreLRSyntaxTextAreaUI.getActionForName(rsEdit, "RTA.LowerCaseAction");
            toLowerAction.putValue("SQuirreLAcceleratorString", "ctrl shift l");
            tpa.addToToolsPopup(SyntaxPlugin.i18n.TO_LOWER_CASE, toLowerAction);
            tpa.addToToolsPopup(SyntaxPlugin.i18n.COPY_AS_RTF, this._syntaxPugin.getApplication().getActionCollection().get(SquirrelCopyAsRtfAction.class));
        }
    }

    void initToolsPopup(SessionInternalFrame sif, ActionCollection coll) {
        ISQLEntryPanel sep = sif.getSQLPanelAPI().getSQLEntryPanel();
        JTextArea septc = sep.getTextComponent();
        sif.addToToolsPopUp(SyntaxPlugin.i18n.FIND, coll.get(FindAction.class));
        sif.addToToolsPopUp(SyntaxPlugin.i18n.FIND_SELECTED, coll.get(FindSelectedAction.class));
        sif.addToToolsPopUp(SyntaxPlugin.i18n.REPEAT_LAST_FIND, coll.get(RepeatLastFindAction.class));
        sif.addToToolsPopUp(SyntaxPlugin.i18n.MARK_SELECTED, coll.get(MarkSelectedAction.class));
        sif.addToToolsPopUp(SyntaxPlugin.i18n.REPLACE, coll.get(ReplaceAction.class));
        sif.addToToolsPopUp(SyntaxPlugin.i18n.UNMARK, coll.get(UnmarkAction.class));
        sif.addToToolsPopUp(SyntaxPlugin.i18n.GO_TO_LINE, coll.get(GoToLineAction.class));
        sif.addToToolsPopUp(SyntaxPlugin.i18n.AUTO_CORR, coll.get(ConfigureAutoCorrectAction.class));
        sif.addToToolsPopUp(SyntaxPlugin.i18n.DUP_LINE, coll.get(DuplicateLineAction.class));
        sif.addToToolsPopUp(SyntaxPlugin.i18n.COMMENT, coll.get(CommentAction.class));
        sif.addToToolsPopUp(SyntaxPlugin.i18n.UNCOMMENT, coll.get(UncommentAction.class));
        if (sep.getTextComponent() instanceof SquirrelRSyntaxTextArea) {
            SquirrelRSyntaxTextArea rsEdit = (SquirrelRSyntaxTextArea)((Object)sep.getTextComponent());
            Action toUpperAction = SquirreLRSyntaxTextAreaUI.getActionForName(rsEdit, "RTA.UpperCaseAction");
            toUpperAction.putValue("SQuirreLAcceleratorString", "ctrl shift u");
            sif.addToToolsPopUp(SyntaxPlugin.i18n.TO_UPPER_CASE, toUpperAction);
            Action toLowerAction = SquirreLRSyntaxTextAreaUI.getActionForName(rsEdit, "RTA.LowerCaseAction");
            toLowerAction.putValue("SQuirreLAcceleratorString", "ctrl shift l");
            sif.addToToolsPopUp(SyntaxPlugin.i18n.TO_LOWER_CASE, toLowerAction);
            sif.addToToolsPopUp(SyntaxPlugin.i18n.COPY_AS_RTF, this._syntaxPugin.getApplication().getActionCollection().get(SquirrelCopyAsRtfAction.class));
        }
    }

    void initToolsPopup(SQLInternalFrame sqlInternalFrame, ActionCollection coll) {
        sqlInternalFrame.addToToolsPopUp(SyntaxPlugin.i18n.FIND, coll.get(FindAction.class));
        sqlInternalFrame.addToToolsPopUp(SyntaxPlugin.i18n.FIND_SELECTED, coll.get(FindSelectedAction.class));
        sqlInternalFrame.addToToolsPopUp(SyntaxPlugin.i18n.REPEAT_LAST_FIND, coll.get(RepeatLastFindAction.class));
        sqlInternalFrame.addToToolsPopUp(SyntaxPlugin.i18n.MARK_SELECTED, coll.get(MarkSelectedAction.class));
        sqlInternalFrame.addToToolsPopUp(SyntaxPlugin.i18n.REPLACE, coll.get(ReplaceAction.class));
        sqlInternalFrame.addToToolsPopUp(SyntaxPlugin.i18n.UNMARK, coll.get(UnmarkAction.class));
        sqlInternalFrame.addToToolsPopUp(SyntaxPlugin.i18n.GO_TO_LINE, coll.get(GoToLineAction.class));
        sqlInternalFrame.addToToolsPopUp(SyntaxPlugin.i18n.AUTO_CORR, coll.get(ConfigureAutoCorrectAction.class));
        sqlInternalFrame.addToToolsPopUp(SyntaxPlugin.i18n.DUP_LINE, coll.get(DuplicateLineAction.class));
        sqlInternalFrame.addToToolsPopUp(SyntaxPlugin.i18n.COMMENT, coll.get(CommentAction.class));
        sqlInternalFrame.addToToolsPopUp(SyntaxPlugin.i18n.UNCOMMENT, coll.get(UncommentAction.class));
        ISQLPanelAPI sqlPanelAPI = sqlInternalFrame.getSQLPanelAPI();
        if (sqlPanelAPI.getSQLEntryPanel().getTextComponent() instanceof SquirrelRSyntaxTextArea) {
            SquirrelRSyntaxTextArea rsEdit = (SquirrelRSyntaxTextArea)((Object)sqlPanelAPI.getSQLEntryPanel().getTextComponent());
            Action toUpperAction = SquirreLRSyntaxTextAreaUI.getActionForName(rsEdit, "RTA.UpperCaseAction");
            toUpperAction.putValue("SQuirreLAcceleratorString", "ctrl shift u");
            sqlInternalFrame.addToToolsPopUp(SyntaxPlugin.i18n.TO_UPPER_CASE, toUpperAction);
            Action toLowerAction = SquirreLRSyntaxTextAreaUI.getActionForName(rsEdit, "RTA.LowerCaseAction");
            toLowerAction.putValue("SQuirreLAcceleratorString", "ctrl shift l");
            sqlInternalFrame.addToToolsPopUp(SyntaxPlugin.i18n.TO_LOWER_CASE, toLowerAction);
            sqlInternalFrame.addToToolsPopUp(SyntaxPlugin.i18n.COPY_AS_RTF, this._syntaxPugin.getApplication().getActionCollection().get(SquirrelCopyAsRtfAction.class));
        }
    }
}

