/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mysql.action;

import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.plugins.mysql.MysqlPlugin;

abstract class AbstractTableListCommand
implements ICommand {
    private ISession _session;
    private final MysqlPlugin _plugin;

    public AbstractTableListCommand(ISession session, MysqlPlugin plugin) {
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        if (plugin == null) {
            throw new IllegalArgumentException("MysqlPlugin == null");
        }
        this._session = session;
        this._plugin = plugin;
    }

    public void execute() {
        IObjectTreeAPI api = this._session.getSessionInternalFrame().getObjectTreeAPI();
        IDatabaseObjectInfo[] dbObjs = api.getSelectedDatabaseObjects();
        StringBuffer tableList = new StringBuffer(512);
        for (int i = 0; i < dbObjs.length; ++i) {
            tableList.append(dbObjs[i].getQualifiedName()).append(",");
        }
        if (tableList.length() > 0) {
            tableList.setLength(tableList.length() - 1);
        }
        StringBuffer cmd = new StringBuffer(512);
        cmd.append(this.getMySQLCommand()).append(' ').append(tableList);
        String cmdStr = this.checkSQL(cmd.toString());
        if (cmdStr != null && cmdStr.length() > 0) {
            this._session.getSessionInternalFrame().getSQLPanelAPI().appendSQLScript(cmdStr, true);
            this._session.getSessionInternalFrame().getSQLPanelAPI().executeCurrentSQL();
            this._session.selectMainTab(1);
        }
    }

    protected String checkSQL(String sql) {
        return sql;
    }

    protected abstract String getMySQLCommand();
}

