/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ZoneStringFormat;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;

public class TimeZoneFormat {
    public ZoneStringFormat zsf;

    public static TimeZoneFormat createInstance(ULocale loc) {
        TimeZoneFormat tzf = new TimeZoneFormat();
        tzf.zsf = ZoneStringFormat.getInstance(loc);
        return tzf;
    }

    public String format(TimeZone tz, long date, int style) {
        String result = null;
        switch (style) {
            case 0: 
            case 6: {
                result = this.zsf.getSpecificShortString(tz, date, style == 6);
                break;
            }
            case 1: {
                result = this.zsf.getSpecificLongString(tz, date);
                break;
            }
            case 2: {
                result = this.zsf.getGenericShortString(tz, date, true);
                break;
            }
            case 3: {
                result = this.zsf.getGenericLongString(tz, date);
                break;
            }
            case 4: {
                result = this.zsf.getShortGMTString(tz, date);
                break;
            }
            case 5: {
                result = this.zsf.getLongGMTString(tz, date);
                break;
            }
            case 7: {
                result = this.zsf.getGenericLocationString(tz, date);
            }
        }
        return result;
    }

    public String format(TimeZone tz, int style, boolean daylight) {
        return this.format(tz, System.currentTimeMillis(), style, daylight);
    }

    public String format(TimeZone tz, long date, int style, boolean daylight) {
        String result = null;
        switch (style) {
            case 1: {
                if (daylight) {
                    result = this.zsf.getLongDaylight(tz.getID(), date);
                    break;
                }
                result = this.zsf.getLongStandard(tz.getID(), date);
                break;
            }
            case 0: 
            case 6: {
                if (daylight) {
                    result = this.zsf.getShortDaylight(tz.getID(), date, style == 6);
                    break;
                }
                result = this.zsf.getShortStandard(tz.getID(), date, style == 6);
                break;
            }
            case 4: {
                result = this.zsf.getShortGMTString(tz, date, daylight);
                break;
            }
            case 5: {
                result = this.zsf.getLongGMTString(tz, date, daylight);
                break;
            }
            default: {
                result = this.format(tz, date, style);
            }
        }
        return result;
    }
}

