/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mssql.action;

import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.plugins.mssql.MssqlPlugin;

public class TruncateLogCommand
implements ICommand {
    private ISession _session;
    private final MssqlPlugin _plugin;
    private final IDatabaseObjectInfo[] _dbs;

    public TruncateLogCommand(ISession session, MssqlPlugin plugin, IDatabaseObjectInfo[] dbs) {
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        if (dbs == null) {
            throw new IllegalArgumentException("Databases array is null");
        }
        this._session = session;
        this._plugin = plugin;
        this._dbs = dbs;
    }

    public void execute() {
        if (this._dbs.length > 0) {
            String sqlSep = this._session.getQueryTokenizer().getSQLStatementSeparator();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this._dbs.length; ++i) {
                IDatabaseObjectInfo ti = this._dbs[i];
                buf.append("BACKUP LOG " + ti.getSimpleName() + " WITH TRUNCATE_ONLY\n");
                buf.append(sqlSep);
                buf.append("\n");
            }
            this._session.getSessionInternalFrame().getSQLPanelAPI().appendSQLScript(buf.toString(), true);
            this._session.getSessionInternalFrame().getSQLPanelAPI().executeCurrentSQL();
            this._session.selectMainTab(1);
        }
    }
}

