/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tinylaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.plaf.ColorUIResource;
import net.sf.tinylaf.Theme;
import net.sf.tinylaf.TinyCheckBoxIcon;
import net.sf.tinylaf.TinyLookAndFeel;
import net.sf.tinylaf.util.ColorRoutines;
import net.sf.tinylaf.util.DrawRoutines;

class TinyRadioButtonIcon
extends TinyCheckBoxIcon {
    private static final HashMap cache = new HashMap();
    private static final int[][] ALPHA = new int[][]{{255, 255, 255, 242, 228, 209, 187, 165, 142, 255, 255}, {255, 255, 242, 228, 209, 187, 165, 142, 120, 104, 255}, {255, 242, 228, 209, 187, 165, 142, 120, 104, 86, 72}, {242, 228, 209, 187, 165, 142, 120, 104, 86, 72, 56}, {228, 209, 187, 165, 142, 120, 104, 86, 72, 56, 42}, {209, 187, 165, 142, 120, 104, 86, 72, 56, 42, 28}, {187, 165, 142, 120, 104, 86, 72, 56, 42, 28, 17}, {165, 142, 120, 104, 86, 72, 56, 42, 28, 17, 9}, {142, 120, 104, 86, 72, 56, 42, 28, 17, 9, 0}, {255, 104, 86, 72, 56, 42, 28, 17, 9, 0, 255}, {255, 255, 72, 56, 42, 28, 17, 9, 0, 255, 255}};

    TinyRadioButtonIcon() {
    }

    public static void clearCache() {
        cache.clear();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        AbstractButton button = (AbstractButton)c;
        ColorUIResource col = null;
        col = !button.isEnabled() ? Theme.buttonDisabledColor.getColor() : (button.getModel().isPressed() ? (button.getModel().isRollover() || button.getModel().isArmed() ? Theme.buttonPressedColor.getColor() : Theme.buttonNormalColor.getColor()) : (button.getModel().isRollover() ? Theme.buttonRolloverBgColor.getColor() : Theme.buttonNormalColor.getColor()));
        g.setColor(col);
        if (TinyLookAndFeel.controlPanelInstantiated) {
            this.drawXpRadioNoCache(g, button, col, x, y, this.getIconWidth(), this.getIconHeight());
        } else {
            this.drawXpRadio(g, button, col, x, y, this.getIconWidth(), this.getIconHeight());
        }
        if (!button.isSelected()) {
            return;
        }
        col = !button.isEnabled() ? Theme.buttonCheckDisabledColor.getColor() : Theme.buttonCheckColor.getColor();
        g.setColor(col);
        this.drawXpCheckMark(g, col, x, y);
    }

    private void drawXpRadio(Graphics g, AbstractButton b, Color c, int x, int y, int w, int h) {
        RadioKey key;
        Object value;
        boolean pressed = b.getModel().isPressed();
        boolean armed = b.getModel().isArmed();
        boolean enabled = b.isEnabled();
        boolean rollover = b.getModel().isRollover();
        boolean focused = Theme.buttonFocusBorder.getValue() && !rollover && b.isFocusOwner();
        Color bg = b.getBackground();
        if (!b.isOpaque()) {
            Container parent;
            bg = parent.getBackground();
            for (parent = b.getParent(); parent != null && !parent.isOpaque(); parent = parent.getParent()) {
                bg = parent.getBackground();
            }
        }
        if ((value = cache.get(key = new RadioKey(c, bg, pressed, enabled, rollover || armed, focused))) != null) {
            g.drawImage((Image)value, x, y, b);
            return;
        }
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics imgGraphics = ((Image)img).getGraphics();
        imgGraphics.setColor(bg);
        imgGraphics.fillRect(0, 0, w, h);
        int spread1 = Theme.buttonSpreadLight.getValue();
        int spread2 = Theme.buttonSpreadDark.getValue();
        if (!enabled) {
            spread1 = Theme.buttonSpreadLightDisabled.getValue();
            spread2 = Theme.buttonSpreadDarkDisabled.getValue();
        }
        int spreadStep1 = spread1 * 5;
        int spreadStep2 = spread2 * 4;
        if (pressed && (rollover || armed)) {
            spreadStep2 *= 2;
        }
        c = ColorRoutines.lighten(c, spreadStep1);
        imgGraphics.setColor(ColorRoutines.darken(c, spreadStep2));
        imgGraphics.fillRect(2, 2, w - 4, h - 4);
        imgGraphics.fillRect(1, 5, 1, 3);
        imgGraphics.fillRect(11, 5, 1, 3);
        imgGraphics.fillRect(5, 1, 3, 1);
        imgGraphics.fillRect(5, 11, 3, 1);
        for (int row = 0; row < 11; ++row) {
            for (int col = 0; col < 11; ++col) {
                Color color = new Color(c.getRed(), c.getGreen(), c.getBlue(), 255 - ALPHA[col][row]);
                imgGraphics.setColor(color);
                imgGraphics.drawLine(col + 1, row + 1, col + 1, row + 1);
            }
        }
        if (!enabled) {
            DrawRoutines.drawXpRadioBorder(imgGraphics, Theme.buttonBorderDisabledColor.getColor(), 0, 0, w, h);
        } else {
            if (rollover && Theme.buttonRolloverBorder.getValue() && !pressed) {
                DrawRoutines.drawXpRadioRolloverBorder(imgGraphics, Theme.buttonRolloverColor.getColor(), 0, 0, w, h);
            } else if (focused && !pressed) {
                DrawRoutines.drawXpRadioRolloverBorder(imgGraphics, Theme.buttonDefaultColor.getColor(), 0, 0, w, h);
            }
            DrawRoutines.drawXpRadioBorder(imgGraphics, Theme.buttonBorderColor.getColor(), 0, 0, w, h);
        }
        imgGraphics.dispose();
        g.drawImage(img, x, y, b);
        cache.put(key, img);
    }

    private void drawXpRadioNoCache(Graphics g, AbstractButton b, Color c, int x, int y, int w, int h) {
        boolean pressed = b.getModel().isPressed();
        boolean armed = b.getModel().isArmed();
        boolean enabled = b.isEnabled();
        boolean rollover = b.getModel().isRollover();
        boolean focused = Theme.buttonFocusBorder.getValue() && !rollover && b.isFocusOwner();
        boolean useCachedImage = !pressed && !armed && !rollover && !focused;
        BufferedImage img = null;
        Object key = null;
        if (useCachedImage) {
            key = enabled ? new EnabledRadioKey(c, Theme.buttonBorderColor.getColor()) : new DisabledRadioKey(c, Theme.buttonBorderDisabledColor.getColor());
            Object value = cache.get(key);
            if (value != null) {
                g.drawImage((Image)value, x, y, b);
                return;
            }
            img = new BufferedImage(w, h, 2);
        }
        int spread1 = Theme.buttonSpreadLight.getValue();
        int spread2 = Theme.buttonSpreadDark.getValue();
        if (!enabled) {
            spread1 = Theme.buttonSpreadLightDisabled.getValue();
            spread2 = Theme.buttonSpreadDarkDisabled.getValue();
        }
        int spreadStep1 = spread1 * 5;
        int spreadStep2 = spread2 * 4;
        if (pressed && (rollover || armed)) {
            spreadStep2 *= 2;
        }
        c = ColorRoutines.lighten(c, spreadStep1);
        Graphics graphics = null;
        int bx = x;
        int by = y;
        if (img != null) {
            graphics = ((Image)img).getGraphics();
            Color bg = b.getBackground();
            if (!b.isOpaque()) {
                Container parent;
                bg = parent.getBackground();
                for (parent = b.getParent(); parent != null && !parent.isOpaque(); parent = parent.getParent()) {
                    bg = parent.getBackground();
                }
            }
            graphics.setColor(bg);
            graphics.fillRect(0, 0, w - 1, h - 1);
            bx = 0;
            by = 0;
        } else {
            graphics = g;
            graphics.translate(x, y);
        }
        graphics.setColor(ColorRoutines.darken(c, spreadStep2));
        graphics.fillRect(2, 2, w - 4, h - 4);
        graphics.fillRect(1, 5, 1, 3);
        graphics.fillRect(11, 5, 1, 3);
        graphics.fillRect(6, 1, 1, 1);
        graphics.fillRect(6, 11, 1, 1);
        for (int row = 0; row < 11; ++row) {
            for (int col = 0; col < 11; ++col) {
                Color color = new Color(c.getRed(), c.getGreen(), c.getBlue(), 255 - ALPHA[col][row]);
                graphics.setColor(color);
                graphics.drawLine(col + 1, row + 1, col + 1, row + 1);
            }
        }
        if (img == null) {
            graphics.translate(-x, -y);
        }
        if (!enabled) {
            DrawRoutines.drawXpRadioBorder(graphics, Theme.buttonBorderDisabledColor.getColor(), bx, by, w, h);
        } else {
            if (rollover && Theme.buttonRolloverBorder.getValue() && !pressed) {
                DrawRoutines.drawXpRadioRolloverBorder(graphics, Theme.buttonRolloverColor.getColor(), bx, by, w, h);
            } else if (focused && !pressed) {
                DrawRoutines.drawXpRadioRolloverBorder(graphics, Theme.buttonDefaultColor.getColor(), bx, by, w, h);
            }
            DrawRoutines.drawXpRadioBorder(graphics, Theme.buttonBorderColor.getColor(), bx, by, w, h);
        }
        if (img != null) {
            graphics.dispose();
            g.drawImage(img, x, y, b);
            cache.put(key, img);
        }
    }

    private void drawXpCheckMark(Graphics g, Color c, int x, int y) {
        g.translate(x, y);
        g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 224));
        g.fillRect(5, 5, 3, 3);
        g.setColor(c);
        g.drawLine(6, 6, 6, 6);
        g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 192));
        g.drawLine(6, 4, 6, 4);
        g.drawLine(4, 6, 4, 6);
        g.drawLine(8, 6, 8, 6);
        g.drawLine(6, 8, 6, 8);
        g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 128));
        g.drawLine(5, 4, 5, 4);
        g.drawLine(7, 4, 7, 4);
        g.drawLine(4, 5, 4, 5);
        g.drawLine(8, 5, 8, 5);
        g.drawLine(4, 7, 4, 7);
        g.drawLine(8, 7, 8, 7);
        g.drawLine(5, 8, 5, 8);
        g.drawLine(7, 8, 7, 8);
        g.translate(-x, -y);
    }

    private static class RadioKey {
        private Color c;
        private Color background;
        private boolean pressed;
        private boolean enabled;
        private boolean rollover;
        private boolean focused;

        RadioKey(Color c, Color background, boolean pressed, boolean enabled, boolean rollover, boolean focused) {
            this.c = c;
            this.background = background;
            this.pressed = pressed;
            this.enabled = enabled;
            this.rollover = rollover;
            this.focused = focused;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof RadioKey)) {
                return false;
            }
            RadioKey other = (RadioKey)o;
            return this.pressed == other.pressed && this.enabled == other.enabled && this.rollover == other.rollover && this.focused == other.focused && this.c.equals(other.c) && this.background.equals(other.background);
        }

        public int hashCode() {
            return this.c.hashCode() * this.background.hashCode() * (this.pressed ? 1 : 2) * (this.enabled ? 4 : 8) * (this.rollover ? 16 : 32);
        }
    }

    private static class DisabledRadioKey {
        int spread1 = Theme.buttonSpreadLightDisabled.getValue();
        int spread2 = Theme.buttonSpreadDarkDisabled.getValue();
        Color c;
        Color back;

        DisabledRadioKey(Color c, Color back) {
            this.c = c;
            this.back = back;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof DisabledRadioKey)) {
                return false;
            }
            DisabledRadioKey other = (DisabledRadioKey)o;
            return this.c.equals(other.c) && this.back.equals(other.back) && this.spread1 == other.spread1 && this.spread2 == other.spread2;
        }

        public int hashCode() {
            return this.c.hashCode() * this.back.hashCode() * this.spread1 * this.spread2;
        }
    }

    private static class EnabledRadioKey {
        int spread1 = Theme.buttonSpreadLight.getValue();
        int spread2 = Theme.buttonSpreadDark.getValue();
        Color c;
        Color back;

        EnabledRadioKey(Color c, Color back) {
            this.c = c;
            this.back = back;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof EnabledRadioKey)) {
                return false;
            }
            EnabledRadioKey other = (EnabledRadioKey)o;
            return this.c.equals(other.c) && this.back.equals(other.back) && this.spread1 == other.spread1 && this.spread2 == other.spread2;
        }

        public int hashCode() {
            return this.c.hashCode() * this.back.hashCode() * this.spread1 * this.spread2;
        }
    }
}

