/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.userscript.kernel;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.userscript.UserScriptPlugin;
import net.sourceforge.squirrel_sql.plugins.userscript.kernel.Script;
import net.sourceforge.squirrel_sql.plugins.userscript.kernel.ScriptPropertiesDialog;
import net.sourceforge.squirrel_sql.plugins.userscript.kernel.ScriptPropsListener;

public class ScriptPropertiesController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ScriptPropertiesController.class);
    private ScriptPropsListener m_scriptPropsListener;
    private Script m_script;
    private boolean m_isNewScript;
    private ScriptPropertiesDialog m_dlg;
    private Frame m_owner;
    private UserScriptPlugin m_plugin;

    public ScriptPropertiesController(Frame owner, UserScriptPlugin plugin) {
        this(owner, null, plugin);
    }

    public ScriptPropertiesController(Frame owner, Script script, UserScriptPlugin plugin) {
        this.m_owner = owner;
        this.m_plugin = plugin;
        this.m_dlg = new ScriptPropertiesDialog(owner);
        GUIUtils.centerWithinParent((Window)this.m_dlg);
        this.m_dlg.setVisible(true);
        if (null == script) {
            this.m_script = new Script();
            this.m_isNewScript = true;
        } else {
            this.m_script = script;
            this.m_dlg.txtName.setText(this.m_script.getName());
            this.m_dlg.txtScriptClass.setText(this.m_script.getScriptClass());
            this.m_dlg.chkShowInStandard.setSelected(this.m_script.isShowInStandard());
            this.m_isNewScript = false;
        }
        this.m_dlg.btnCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptPropertiesController.this.onCheck();
            }
        });
        this.m_dlg.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptPropertiesController.this.onOK();
            }
        });
        this.m_dlg.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptPropertiesController.this.close();
            }
        });
    }

    private void onCheck() {
        String msg;
        URL classUrl = this.findClass(this.m_dlg.txtScriptClass.getText());
        if (null == classUrl) {
            msg = s_stringMgr.getString("userscript.classNotFound", new Object[]{this.m_dlg.txtScriptClass.getText()});
        } else {
            String[] params = new String[]{this.m_dlg.txtScriptClass.getText(), classUrl.getFile()};
            msg = s_stringMgr.getString("userscript.classNotFoundIn", params);
        }
        JOptionPane.showMessageDialog(this.m_owner, msg);
    }

    public URL findClass(String className) {
        return this.m_plugin.getUserScriptClassLoader().getResource(ScriptPropertiesController.asResourceName(className));
    }

    protected static String asResourceName(String resource) {
        resource = resource.replace('.', '/');
        resource = resource + ".class";
        return resource;
    }

    private void onOK() {
        if (null == this.m_dlg.txtName.getText() || "".equals(this.m_dlg.txtName.getText().trim())) {
            JOptionPane.showMessageDialog(this.m_owner, s_stringMgr.getString("userscript.enterScriptName"));
            return;
        }
        if (null == this.m_dlg.txtScriptClass.getText() || "".equals(this.m_dlg.txtScriptClass.getText().trim())) {
            JOptionPane.showMessageDialog(this.m_owner, s_stringMgr.getString("userscript.enterScriptClass"));
            return;
        }
        this.m_script.setName(this.m_dlg.txtName.getText());
        this.m_script.setScriptClass(this.m_dlg.txtScriptClass.getText());
        this.m_script.setShowInStandard(this.m_dlg.chkShowInStandard.isSelected());
        this.close();
        if (this.m_isNewScript) {
            this.m_scriptPropsListener.newScript(this.m_script);
        } else {
            this.m_scriptPropsListener.scriptEdited(this.m_script);
        }
    }

    private void close() {
        this.m_dlg.setVisible(false);
        this.m_dlg.dispose();
    }

    public void setScriptPropsListener(ScriptPropsListener scriptPropsListener) {
        this.m_scriptPropsListener = scriptPropsListener;
    }
}

