/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.server;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernatePropertyInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateServerConnection;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateServerExceptionUtil;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateSqlConnectionData;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HqlQueryResult;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.JDBCTemporalEscapeParse;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.MappedClassInfoData;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ObjectSubstituteFactory;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.RCParam;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ReflectionCaller;

public class HibernateServerConnectionImpl
implements HibernateServerConnection {
    private Object _sessionFactoryImpl;
    private ClassLoader _cl;
    private boolean _server;
    private HashMap<String, MappedClassInfoData> _infoDataByClassName;
    private ReflectionCaller _rcHibernateSession;
    private String _driverClassName;
    private String _url;
    private String _user;
    private String _password;

    HibernateServerConnectionImpl(Object sessionFactoryImpl, ClassLoader cl, boolean isServer) throws RemoteException {
        this._sessionFactoryImpl = sessionFactoryImpl;
        this._cl = cl;
        this._server = isServer;
    }

    @Override
    public ArrayList<String> generateSQL(String hqlQuery) {
        try {
            JDBCTemporalEscapeParse jdbcTemporalEscapeParse = new JDBCTemporalEscapeParse(hqlQuery);
            if (jdbcTemporalEscapeParse.hasEscapes()) {
                hqlQuery = jdbcTemporalEscapeParse.getHql();
            }
            Class sessionFactoryImplementorClass = (Class)new ReflectionCaller().getClass("org.hibernate.engine.SessionFactoryImplementor", this._cl).getCallee();
            List<ReflectionCaller> translators = new ReflectionCaller(this._cl).getClass("org.hibernate.engine.query.HQLQueryPlan", this._cl).callConstructor(new Class[]{String.class, Boolean.TYPE, Map.class, sessionFactoryImplementorClass}, new Object[]{hqlQuery, false, Collections.EMPTY_MAP, this._sessionFactoryImpl}).callArrayMethod("getTranslators");
            ArrayList<String> ret = new ArrayList<String>();
            for (ReflectionCaller translator : translators) {
                List sqls = (List)translator.callMethod("collectSqlStrings").getCallee();
                for (Object sql : sqls) {
                    ret.add(sql.toString());
                }
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void closeConnection() {
        Throwable reThrow = null;
        try {
            new ReflectionCaller(this._sessionFactoryImpl).callMethod("close");
        }
        catch (Throwable t) {
            reThrow = t;
        }
        finally {
            this._sessionFactoryImpl = null;
            this._cl = null;
            this._infoDataByClassName = null;
            System.gc();
            if (null != reThrow) {
                throw new RuntimeException(reThrow);
            }
        }
    }

    @Override
    public ArrayList<MappedClassInfoData> getMappedClassInfoData() {
        this.initMappedClassInfos();
        return new ArrayList<MappedClassInfoData>(this._infoDataByClassName.values());
    }

    private void initMappedClassInfos() {
        if (null != this._infoDataByClassName) {
            return;
        }
        this._infoDataByClassName = new HashMap();
        ReflectionCaller sessionFactoryImplcaller = new ReflectionCaller(this._sessionFactoryImpl);
        Collection<ReflectionCaller> persisters = sessionFactoryImplcaller.callMethod("getAllClassMetadata").callCollectionMethod("values");
        for (ReflectionCaller persister : persisters) {
            Object entityMode_POJO = persister.getClass("org.hibernate.EntityMode", this._cl).getField("POJO").getCallee();
            Class mappedClass = (Class)persister.callMethod("getMappedClass", entityMode_POJO).getCallee();
            String identifierPropertyName = (String)persister.callMethod("getIdentifierPropertyName").getCallee();
            Class identifierPropertyClass = persister.callMethod("getIdentifierType").callMethod("getReturnedClass").getCalleeClass();
            String identifierPropertyClassName = identifierPropertyClass.getName();
            String tableName = (String)persister.callMethod("getTableName").getCallee();
            String[] identifierColumnNames = (String[])persister.callMethod("getIdentifierColumnNames").getCallee();
            HibernatePropertyInfo identifierPropInfo = new HibernatePropertyInfo(identifierPropertyName, identifierPropertyClassName, tableName, identifierColumnNames);
            identifierPropInfo.setIdentifier(true);
            String[] propertyNames = (String[])persister.callMethod("getPropertyNames").getCallee();
            HibernatePropertyInfo[] infos = new HibernatePropertyInfo[propertyNames.length];
            for (int i = 0; i < propertyNames.length; ++i) {
                ReflectionCaller propertyTypeCaller = persister.callMethod("getPropertyType", propertyNames[i]);
                String mayBeCollectionTypeName = propertyTypeCaller.callMethod("getReturnedClass").getCalleeClass().getName();
                String propTableName = (String)persister.callMethod("getPropertyTableName", propertyNames[i]).getCallee();
                String[] propertyColumnNames = (String[])persister.callMethod("getPropertyColumnNames", propertyNames[i]).getCallee();
                try {
                    String role = (String)propertyTypeCaller.callMethod("getRole").getCallee();
                    ReflectionCaller collectionMetaDataCaller = sessionFactoryImplcaller.callMethod("getCollectionMetadata", role);
                    String typeName = collectionMetaDataCaller.callMethod("getElementType").callMethod("getReturnedClass").getCalleeClass().getName();
                    infos[i] = new HibernatePropertyInfo(propertyNames[i], typeName, propTableName, propertyColumnNames);
                    infos[i].setCollectionClassName(mayBeCollectionTypeName);
                    continue;
                }
                catch (RuntimeException e) {
                    if (HibernateServerExceptionUtil.getDeepestThrowable(e) instanceof NoSuchMethodException) {
                        infos[i] = new HibernatePropertyInfo(propertyNames[i], mayBeCollectionTypeName, propTableName, propertyColumnNames);
                        continue;
                    }
                    throw (RuntimeException)this.prepareTransport(e);
                }
            }
            this._infoDataByClassName.put(mappedClass.getName(), new MappedClassInfoData(mappedClass.getName(), tableName, identifierPropInfo, infos));
        }
    }

    @Override
    public HibernateSqlConnectionData getHibernateSqlConnectionData() {
        try {
            Connection con = (Connection)this.getRcHibernateSession().callMethod("getJDBCContext").callMethod("getConnectionManager").callMethod("getConnection").getCallee();
            DatabaseMetaData md = con.getMetaData();
            return new HibernateSqlConnectionData(md.getURL(), md.getUserName(), md.getDriverName(), md.getDriverVersion());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public HqlQueryResult createQueryList(String hqlQuery, int sqlNbrRowsToShow) {
        if (null != this._driverClassName) {
            this._driverClassName = null;
            this._url = null;
            this._user = null;
            this._password = null;
            this._rcHibernateSession = null;
        }
        return this._createResultList(hqlQuery, sqlNbrRowsToShow);
    }

    @Override
    public HqlQueryResult createQueryList(String hqlQuery, int sqlNbrRowsToShow, String driverClassName, String url, String user, String password) throws RemoteException {
        if (null == this._driverClassName) {
            this._driverClassName = driverClassName;
            this._url = url;
            this._user = user;
            this._password = password;
            this._rcHibernateSession = null;
        }
        return this._createResultList(hqlQuery, sqlNbrRowsToShow);
    }

    private HqlQueryResult _createResultList(String hqlQuery, int sqlNbrRowsToShow) {
        HqlQueryResult ret = new HqlQueryResult();
        List queryResList = null;
        try {
            this.getRcHibernateSession().callMethod("getTransaction").callMethod("begin");
        }
        catch (Throwable t) {
            ret.putSessionAdminException("Exception occurced during call of Session.getTransaction().begin()", this.prepareTransport(t));
        }
        try {
            ReflectionCaller rc;
            JDBCTemporalEscapeParse jdbcTemporalEscapeParse = new JDBCTemporalEscapeParse(hqlQuery);
            if (jdbcTemporalEscapeParse.hasEscapes()) {
                rc = this.getRcHibernateSession().callMethod("createQuery", jdbcTemporalEscapeParse.getHql());
                TreeMap<String, Date> datesByParamName = jdbcTemporalEscapeParse.getDatesByParamName();
                for (String paramName : datesByParamName.keySet()) {
                    RCParam param = new RCParam();
                    param.add(paramName, String.class);
                    param.add(datesByParamName.get(paramName), Object.class);
                    rc.callMethod("setParameter", param);
                }
                ret.setMessagePanelInfoText("Temporal values were parameterized:\n" + jdbcTemporalEscapeParse.getMessagePanelInfoText());
            } else {
                rc = this.getRcHibernateSession().callMethod("createQuery", hqlQuery);
            }
            if (this.isDataUpdate(hqlQuery)) {
                int updateCount = (Integer)rc.callMethod("executeUpdate").getCallee();
                ret.setUpdateCount(updateCount);
                this.getRcHibernateSession().callMethod("getTransaction").callMethod("commit");
            } else {
                if (0 <= sqlNbrRowsToShow) {
                    rc = rc.callMethod("setMaxResults", new RCParam().add(sqlNbrRowsToShow, Integer.TYPE));
                }
                queryResList = (List)rc.callMethod("list").getCallee();
                this.tryRollbackTx(ret);
            }
        }
        catch (Throwable t) {
            ret.setExceptionOccuredWhenExecutingQuery(this.prepareTransport(t));
            this.tryRollbackTx(ret);
        }
        try {
            this.getRcHibernateSession().callMethod("clear");
        }
        catch (Throwable t) {
            ret.putSessionAdminException("Exception occurced during call of Session.clear()", this.prepareTransport(t));
        }
        if (null != queryResList) {
            ret.setQueryResultList(new ObjectSubstituteFactory(this._cl).replaceObjectsWithSubstitutes(queryResList, this._infoDataByClassName));
        }
        return ret;
    }

    private void tryRollbackTx(HqlQueryResult ret) {
        try {
            this.getRcHibernateSession().callMethod("getTransaction").callMethod("rollback");
        }
        catch (Throwable t) {
            ret.putSessionAdminException("Exception occurced during call of Session.getTransaction().rollback()", this.prepareTransport(t));
        }
    }

    private boolean isDataUpdate(String hqlQuery) {
        return null != hqlQuery && (hqlQuery.trim().toLowerCase().startsWith("insert") || hqlQuery.trim().toLowerCase().startsWith("update") || hqlQuery.trim().toLowerCase().startsWith("delete"));
    }

    private Throwable prepareTransport(Throwable t) {
        if (!this._server) {
            return t;
        }
        return HibernateServerExceptionUtil.prepareTransport(t);
    }

    private ReflectionCaller getRcHibernateSession() {
        try {
            if (null == this._rcHibernateSession) {
                if (null == this._driverClassName) {
                    this._rcHibernateSession = new ReflectionCaller(this._sessionFactoryImpl).callMethod("openSession");
                } else {
                    ReflectionCaller driver = new ReflectionCaller().getClass(this._driverClassName, this._cl).newInstance();
                    Properties props = new Properties();
                    props.put("user", this._user);
                    props.put("password", this._password);
                    ReflectionCaller con = driver.callMethod("connect", this._url, props);
                    RCParam rcParam = new RCParam();
                    rcParam.add(con.getCallee(), Connection.class);
                    this._rcHibernateSession = new ReflectionCaller(this._sessionFactoryImpl).callMethod("openSession", rcParam);
                }
            }
            return this._rcHibernateSession;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

