/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.config.MBeanServerBeanDefinitionParser;
import org.springframework.core.JdkVersion;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class MBeanExportBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String MBEAN_EXPORTER_BEAN_NAME = "mbeanExporter";
    private static final String DEFAULT_DOMAIN_ATTRIBUTE = "default-domain";
    private static final String SERVER_ATTRIBUTE = "server";

    MBeanExportBeanDefinitionParser() {
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        return MBEAN_EXPORTER_BEAN_NAME;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        String serverBeanName;
        String beanClassName = JdkVersion.isAtLeastJava15() ? "org.springframework.jmx.export.annotation.AnnotationMBeanExporter" : "org.springframework.jmx.export.MBeanExporter";
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)beanClassName);
        builder.setRole(2);
        String defaultDomain = element.getAttribute(DEFAULT_DOMAIN_ATTRIBUTE);
        if (StringUtils.hasText((String)defaultDomain)) {
            builder.addPropertyValue("defaultDomain", (Object)defaultDomain);
        }
        if (StringUtils.hasText((String)(serverBeanName = element.getAttribute(SERVER_ATTRIBUTE)))) {
            builder.addPropertyReference(SERVER_ATTRIBUTE, serverBeanName);
        } else {
            AbstractBeanDefinition specialServer = MBeanServerBeanDefinitionParser.findServerForSpecialEnvironment();
            if (specialServer != null) {
                builder.addPropertyValue(SERVER_ATTRIBUTE, (Object)specialServer);
            }
        }
        return builder.getBeanDefinition();
    }
}

