/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlval.action;

import java.awt.event.ActionEvent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.ISessionAction;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.IResources;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.sqlval.LogonDialog;
import net.sourceforge.squirrel_sql.plugins.sqlval.SQLValidatorPlugin;
import net.sourceforge.squirrel_sql.plugins.sqlval.WebServicePreferences;
import net.sourceforge.squirrel_sql.plugins.sqlval.WebServiceSessionProperties;
import net.sourceforge.squirrel_sql.plugins.sqlval.cmd.ValidateSQLCommand;

public class ValidateSQLAction
extends SquirrelAction
implements ISessionAction {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ValidateSQLAction.class);
    private static final ILogger s_log = LoggerController.createLogger(ValidateSQLAction.class);
    private final WebServicePreferences _prefs;
    private final SQLValidatorPlugin _plugin;
    private ISession _session;

    public ValidateSQLAction(IApplication app, IResources resources, WebServicePreferences prefs, SQLValidatorPlugin plugin) {
        super(app, resources);
        if (prefs == null) {
            throw new IllegalArgumentException("WebServicePreferences == null");
        }
        this._prefs = prefs;
        this._plugin = plugin;
    }

    public void actionPerformed(ActionEvent evt) {
        if (this._session != null) {
            WebServiceSessionProperties sessionProps = this._plugin.getWebServiceSessionProperties(this._session);
            if (!sessionProps.getWebServiceSession().isOpen()) {
                LogonDialog dlog = new LogonDialog(this._session, this._prefs, sessionProps);
                dlog.setVisible(true);
            }
            if (sessionProps.getWebServiceSession().isOpen()) {
                this.validateSQL();
            }
        }
    }

    public void setSession(ISession session) {
        this._session = session;
    }

    private void validateSQL() {
        ISQLPanelAPI api = this._session.getSessionInternalFrame().getSQLPanelAPI();
        String sql = api.getSQLScriptToBeExecuted();
        if (sql != null && sql.trim().length() > 0) {
            WebServiceSessionProperties wssProps = this._plugin.getWebServiceSessionProperties(this._session);
            String stmtSep = this._session.getQueryTokenizer().getSQLStatementSeparator();
            String solComment = this._session.getQueryTokenizer().getLineCommentBegin();
            ValidationProps valProps = new ValidationProps(this._prefs, wssProps, sql, stmtSep, solComment, this._session);
            new Executor(this._session.getApplication(), valProps, this._session.getProperties()).execute();
        } else {
            this._session.showErrorMessage(s_stringMgr.getString("sqlval.noSql"));
        }
    }

    static class Executor
    implements ICommand {
        private final IApplication _app;
        private final ValidationProps _valProps;
        private SessionProperties _sessionProperties;

        Executor(IApplication app, ValidationProps valProps, SessionProperties sessionProperties) {
            this._app = app;
            this._valProps = valProps;
            this._sessionProperties = sessionProperties;
        }

        public void execute() {
            ValidateSQLCommand cmd = new ValidateSQLCommand(this._valProps._prefs, this._valProps._sessionProps, this._valProps._sql, this._valProps._stmtSep, this._valProps._solComment, this._sessionProperties, this._valProps._session);
            try {
                cmd.execute();
                this._valProps._session.showMessage(cmd.getResults());
            }
            catch (Throwable th) {
                String msg = "Error occurred when talking to the web service";
                s_log.error((Object)"Error occurred when talking to the web service", th);
                this._app.showErrorDialog("Error occurred when talking to the web service", th);
            }
        }
    }

    static final class ValidationProps {
        final WebServicePreferences _prefs;
        final WebServiceSessionProperties _sessionProps;
        final String _sql;
        final String _stmtSep;
        final String _solComment;
        final ISession _session;

        ValidationProps(WebServicePreferences prefs, WebServiceSessionProperties sessionProps, String sql, String stmtSep, String solComment, ISession session) {
            this._prefs = prefs;
            this._sessionProps = sessionProps;
            this._sql = sql;
            this._stmtSep = stmtSep;
            this._solComment = solComment;
            this._session = session;
        }
    }
}

