/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.component.tab;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.component.tab.Tablature;
import org.herac.tuxguitar.document.TGDocumentManager;
import org.herac.tuxguitar.editor.TGEditorManager;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.ui.event.UIMenuHideListener;
import org.herac.tuxguitar.ui.event.UIMenuShowListener;
import org.herac.tuxguitar.ui.menu.UIPopupMenu;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TablatureEditor
implements TGEventListener {
    private TGContext context;
    private Tablature tablature;

    public TablatureEditor(TGContext context) {
        this.context = context;
        this.initialize();
    }

    public void initialize() {
        this.tablature = new Tablature(this.context, TGDocumentManager.getInstance((TGContext)this.context));
        this.tablature.reloadViewLayout();
        this.tablature.updateTablature();
        this.tablature.resetCaret();
        this.initListener();
        this.initMenu();
    }

    private void initListener() {
        TGEditorManager.getInstance((TGContext)this.context).addUpdateListener((TGEventListener)this);
    }

    private void initMenu() {
        UIPopupMenu uiPopupMenu = TuxGuitar.getInstance().getItemManager().getPopupMenu();
        uiPopupMenu.addMenuShowListener((UIMenuShowListener)this.getTablature().getEditorKit().getMouseKit());
        uiPopupMenu.addMenuHideListener((UIMenuHideListener)this.getTablature().getEditorKit().getMouseKit());
    }

    public void reloadConfig() {
        this.getTablature().reloadStyles();
    }

    public Tablature getTablature() {
        return this.tablature;
    }

    public void processUpdateEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("updateMode");
        if (type == 2) {
            this.getTablature().updateMeasure((Integer)event.getAttribute("measureNumber"));
        } else if (type == 3) {
            this.getTablature().updateTablature();
        } else if (type == 4) {
            this.getTablature().updateTablature();
        }
    }

    public void processEvent(TGEvent event) {
        if ("ui-update".equals(event.getEventType())) {
            this.processUpdateEvent(event);
        }
    }

    public static TablatureEditor getInstance(TGContext context) {
        return (TablatureEditor)TGSingletonUtil.getInstance((TGContext)context, (String)TablatureEditor.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TablatureEditor>(){

            public TablatureEditor createInstance(TGContext context) {
                return new TablatureEditor(context);
            }
        });
    }
}

