"use strict";
/**
 * Copyright 2018 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.BrowseCarousel = exports.BrowseCarouselItem = void 0;
class BrowseCarouselItem {
    /**
     * @param options BrowseCarouselItem options
     * @public
     */
    constructor(options) {
        this.title = options.title;
        if (options.url) {
            this.openUrlAction = {
                url: options.url,
            };
        }
        if (options.openUrlAction) {
            this.openUrlAction = options.openUrlAction;
        }
        this.description = options.description;
        this.footer = options.footer;
        this.image = options.image;
    }
}
exports.BrowseCarouselItem = BrowseCarouselItem;
const isOptions = (options) => {
    const test = options;
    return Array.isArray(test.items);
};
class BrowseCarousel {
    constructor(options, ...items) {
        if (!options) {
            this.items = [];
            return;
        }
        if (Array.isArray(options)) {
            this.items = options;
            return;
        }
        if (isOptions(options)) {
            this.imageDisplayOptions = options.display;
            this.items = options.items;
            return;
        }
        this.items = [options].concat(items);
    }
}
exports.BrowseCarousel = BrowseCarousel;
//# sourceMappingURL=browse.js.map