"use strict";
/**
 * Copyright 2018 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Button = void 0;
class Button {
    /**
     * @param options Button options
     * @public
     */
    constructor(options) {
        this.title = options.title;
        if (options.url) {
            this.openUrlAction = { url: options.url };
        }
        if (options.action) {
            this.openUrlAction = options.action;
        }
    }
}
exports.Button = Button;
//# sourceMappingURL=button.js.map