import QueryLogItem, { IQueryLogItem } from './QueryLogItem';

// This file was autogenerated. Please do not change.
// All changes will be overwrited on commit.
export interface IQueryLog {
    data?: IQueryLogItem[];
    oldest?: string;
}

export default class QueryLog {
    readonly _data: QueryLogItem[] | undefined;

    get data(): QueryLogItem[] | undefined {
        return this._data;
    }

    readonly _oldest: string | undefined;

    /**
     * Description: undefined
     * Example: 2018-11-26T00:02:41+03:00
     */
    get oldest(): string | undefined {
        return this._oldest;
    }

    constructor(props: IQueryLog) {
        if (props.data) {
            this._data = props.data.map((p) => new QueryLogItem(p));
        }
        if (typeof props.oldest === 'string') {
            this._oldest = props.oldest.trim();
        }
    }

    serialize(): IQueryLog {
        const data: IQueryLog = {
        };
        if (typeof this._data !== 'undefined') {
            data.data = this._data.map((p) => p.serialize());
        }
        if (typeof this._oldest !== 'undefined') {
            data.oldest = this._oldest;
        }
        return data;
    }

    validate(): string[] {
        const validate = {
            oldest: !this._oldest ? true : typeof this._oldest === 'string' && !this._oldest ? true : this._oldest,
            data: !this._data ? true : this._data.reduce((result, p) => result && p.validate().length === 0, true),
        };
        const isError: string[] = [];
        Object.keys(validate).forEach((key) => {
            if (!(validate as any)[key]) {
                isError.push(key);
            }
        });
        return isError;
    }

    update(props: Partial<IQueryLog>): QueryLog {
        return new QueryLog({ ...this.serialize(), ...props });
    }
}
