import ResultRule, { IResultRule } from './ResultRule';

// This file was autogenerated. Please do not change.
// All changes will be overwrited on commit.
export interface IFilterCheckHostResponse {
    cname?: string;
    filter_id?: number;
    ip_addrs?: string[];
    reason?: string;
    rule?: string;
    rules?: IResultRule[];
    service_name?: string;
}

export default class FilterCheckHostResponse {
    readonly _cname: string | undefined;

    /** */
    get cname(): string | undefined {
        return this._cname;
    }

    readonly _filter_id: number | undefined;

    /** */
    get filterId(): number | undefined {
        return this._filter_id;
    }

    readonly _ip_addrs: string[] | undefined;

    /** */
    get ipAddrs(): string[] | undefined {
        return this._ip_addrs;
    }

    readonly _reason: string | undefined;

    /** */
    get reason(): string | undefined {
        return this._reason;
    }

    readonly _rule: string | undefined;

    /**
     * Description: Filtering rule applied to the request (if any).
     * Deprecated: use `rules[*].text` instead.
     *
     * Example: ||example.org^
     */
    get rule(): string | undefined {
        return this._rule;
    }

    readonly _rules: ResultRule[] | undefined;

    /** */
    get rules(): ResultRule[] | undefined {
        return this._rules;
    }

    readonly _service_name: string | undefined;

    /** */
    get serviceName(): string | undefined {
        return this._service_name;
    }

    constructor(props: IFilterCheckHostResponse) {
        if (typeof props.cname === 'string') {
            this._cname = props.cname.trim();
        }
        if (typeof props.filter_id === 'number') {
            this._filter_id = props.filter_id;
        }
        if (props.ip_addrs) {
            this._ip_addrs = props.ip_addrs;
        }
        if (typeof props.reason === 'string') {
            this._reason = props.reason.trim();
        }
        if (typeof props.rule === 'string') {
            this._rule = props.rule.trim();
        }
        if (props.rules) {
            this._rules = props.rules.map((p) => new ResultRule(p));
        }
        if (typeof props.service_name === 'string') {
            this._service_name = props.service_name.trim();
        }
    }

    serialize(): IFilterCheckHostResponse {
        const data: IFilterCheckHostResponse = {
        };
        if (typeof this._cname !== 'undefined') {
            data.cname = this._cname;
        }
        if (typeof this._filter_id !== 'undefined') {
            data.filter_id = this._filter_id;
        }
        if (typeof this._ip_addrs !== 'undefined') {
            data.ip_addrs = this._ip_addrs;
        }
        if (typeof this._reason !== 'undefined') {
            data.reason = this._reason;
        }
        if (typeof this._rule !== 'undefined') {
            data.rule = this._rule;
        }
        if (typeof this._rules !== 'undefined') {
            data.rules = this._rules.map((p) => p.serialize());
        }
        if (typeof this._service_name !== 'undefined') {
            data.service_name = this._service_name;
        }
        return data;
    }

    validate(): string[] {
        const validate = {
            reason: !this._reason ? true : typeof this._reason === 'string' && !this._reason ? true : this._reason,
            filter_id: !this._filter_id ? true : typeof this._filter_id === 'number',
            rule: !this._rule ? true : typeof this._rule === 'string' && !this._rule ? true : this._rule,
            rules: !this._rules ? true : this._rules.reduce((result, p) => result && p.validate().length === 0, true),
            service_name: !this._service_name ? true : typeof this._service_name === 'string' && !this._service_name ? true : this._service_name,
            cname: !this._cname ? true : typeof this._cname === 'string' && !this._cname ? true : this._cname,
            ip_addrs: !this._ip_addrs ? true : this._ip_addrs.reduce((result, p) => result && typeof p === 'string', true),
        };
        const isError: string[] = [];
        Object.keys(validate).forEach((key) => {
            if (!(validate as any)[key]) {
                isError.push(key);
            }
        });
        return isError;
    }

    update(props: Partial<IFilterCheckHostResponse>): FilterCheckHostResponse {
        return new FilterCheckHostResponse({ ...this.serialize(), ...props });
    }
}
