"use strict";
/*
 * Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardSkillFactory = void 0;
const ask_sdk_core_1 = require("ask-sdk-core");
const ask_sdk_dynamodb_persistence_adapter_1 = require("ask-sdk-dynamodb-persistence-adapter");
/**
 * Provider for {@link StandardSkillBuilder}.
 */
class StandardSkillFactory {
    static init() {
        let thisTableName;
        let thisAutoCreateTable;
        let thisPartitionKeyGenerator;
        let thisDynamoDbClient;
        const baseSkillBuilder = ask_sdk_core_1.BaseSkillFactory.init();
        return Object.assign(Object.assign({}, baseSkillBuilder), { getSkillConfiguration() {
                const skillConfiguration = baseSkillBuilder.getSkillConfiguration();
                return Object.assign(Object.assign({}, skillConfiguration), { persistenceAdapter: thisTableName
                        ? new ask_sdk_dynamodb_persistence_adapter_1.DynamoDbPersistenceAdapter({
                            tableName: thisTableName,
                            createTable: thisAutoCreateTable,
                            partitionKeyGenerator: thisPartitionKeyGenerator,
                            dynamoDBClient: thisDynamoDbClient,
                        })
                        : undefined, apiClient: new ask_sdk_core_1.DefaultApiClient() });
            },
            withTableName(tableName) {
                thisTableName = tableName;
                return this;
            },
            withAutoCreateTable(autoCreateTable) {
                thisAutoCreateTable = autoCreateTable;
                return this;
            },
            withPartitionKeyGenerator(partitionKeyGenerator) {
                thisPartitionKeyGenerator = partitionKeyGenerator;
                return this;
            },
            withDynamoDbClient(dynamoDbClient) {
                thisDynamoDbClient = dynamoDbClient;
                return this;
            } });
    }
}
exports.StandardSkillFactory = StandardSkillFactory;
//# sourceMappingURL=StandardSkillFactory.js.map