#ifndef CHAN_DONGLE_GSM7_LUTS_H_INCLUDED
#define CHAN_DONGLE_GSM7_LUTS_H_INCLUDED

/* GSM 03.38 7bit alphabet */
static const uint16_t LUT_GSM7_LS16[14][128] = {
        {
                0x40, 0xa3, 0x24, 0xa5, 0xe8, 0xe9, 0xf9, 0xec, 0xf2, 0xc7, 0xa, 0xd8, 0xf8, 0xd, 0xc5, 0xe5, 
                0x394, 0x5f, 0x3a6, 0x393, 0x39b, 0x3a9, 0x3a0, 0x3a8, 0x3a3, 0x398, 0x39e, 0x1b, 0xc6, 0xe6, 0xdf, 0xc9, 
                0x20, 0x21, 0x22, 0x23, 0xa4, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 
                0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 
                0xa1, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 
                0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0xc4, 0xd6, 0xd1, 0xdc, 0xa7, 
                0xbf, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 
                0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0xe4, 0xf6, 0xf1, 0xfc, 0xe0
        },
        {
                0x40, 0xa3, 0x24, 0xa5, 0x20ac, 0xe9, 0xf9, 0x131, 0xf2, 0xc7, 0xa, 0x11e, 0x11f, 0xd, 0xc5, 0xe5, 
                0x394, 0x5f, 0x3a6, 0x393, 0x39b, 0x3a9, 0x3a0, 0x3a8, 0x3a3, 0x398, 0x39e, 0x1b, 0x15e, 0x15f, 0xdf, 0xc9, 
                0x20, 0x21, 0x22, 0x23, 0xa4, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 
                0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 
                0x130, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 
                0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0xc4, 0xd6, 0xd1, 0xdc, 0xa7, 
                0xe7, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 
                0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0xe4, 0xf6, 0xf1, 0xfc, 0xe0
        },
        {
                0x40, 0xa3, 0x24, 0xa5, 0xe8, 0xe9, 0xf9, 0xec, 0xf2, 0xc7, 0xa, 0xd8, 0xf8, 0xd, 0xc5, 0xe5, 
                0x394, 0x5f, 0x3a6, 0x393, 0x39b, 0x3a9, 0x3a0, 0x3a8, 0x3a3, 0x398, 0x39e, 0x1b, 0xc6, 0xe6, 0xdf, 0xc9, 
                0x20, 0x21, 0x22, 0x23, 0xa4, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 
                0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 
                0xa1, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 
                0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0xc4, 0xd6, 0xd1, 0xdc, 0xa7, 
                0xbf, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 
                0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0xe4, 0xf6, 0xf1, 0xfc, 0xe0
        },
        {
                0x40, 0xa3, 0x24, 0xa5, 0xea, 0xe9, 0xfa, 0xed, 0xf3, 0xe7, 0xa, 0xd4, 0xf4, 0xd, 0xc1, 0xe1, 
                0x394, 0x5f, 0xaa, 0xc7, 0xc0, 0x221e, 0x5e, 0x5c, 0x20ac, 0xd3, 0x7c, 0x1b, 0xc2, 0xe2, 0xca, 0xc9, 
                0x20, 0x21, 0x22, 0x23, 0xba, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 
                0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 
                0xcd, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 
                0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0xc3, 0xd5, 0xda, 0xdc, 0xa7, 
                0x7e, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 
                0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0xe3, 0xf5, 0x60, 0xfc, 0xe0
        },
        {
                0x981, 0x982, 0x983, 0x985, 0x986, 0x987, 0x988, 0x989, 0x98a, 0x98b, 0xa, 0x98c, 0x900, 0xd, 0x0, 0x98f, 
                0x990, 0x900, 0x900, 0x993, 0x994, 0x995, 0x996, 0x997, 0x998, 0x999, 0x99a, 0x1b, 0x99b, 0x99c, 0x99d, 0x99e, 
                0x20, 0x21, 0x99f, 0x9a0, 0x9a1, 0x9a2, 0x9a3, 0x9a4, 0x29, 0x28, 0x9a5, 0x9a6, 0x2c, 0x9a7, 0x2e, 0x9a8, 
                0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x0, 0x9aa, 0x9ab, 0x3f, 
                0x9ac, 0x9ad, 0x9ae, 0x9af, 0x9b0, 0x900, 0x9b2, 0x900, 0x900, 0x900, 0x9b6, 0x9b7, 0x9b8, 0x9b9, 0x9bc, 0x9bd, 
                0x9be, 0x9bf, 0x9c0, 0x9c1, 0x9c2, 0x9c3, 0x9c4, 0x900, 0x900, 0x9c7, 0x9c8, 0x900, 0x900, 0x9cb, 0x9cc, 0x9cd, 
                0x9ce, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 
                0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x9d7, 0x9dc, 0x9dd, 0x9f0, 0x9f1
        },
        {
                0xa81, 0xa82, 0xa83, 0xa85, 0xa86, 0xa87, 0xa88, 0xa89, 0xa8a, 0xa8b, 0xa, 0xa8c, 0xa8d, 0xd, 0x0, 0xa8f, 
                0xa90, 0xa91, 0xa00, 0xa93, 0xa94, 0xa95, 0xa96, 0xa97, 0xa98, 0xa99, 0xa9a, 0x1b, 0xa9b, 0xa9c, 0xa9d, 0xa9e, 
                0x20, 0x21, 0xa9f, 0xaa0, 0xaa1, 0xaa2, 0xaa3, 0xaa4, 0x29, 0x28, 0xaa5, 0xaa6, 0x2c, 0xaa7, 0x2e, 0xaa8, 
                0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x0, 0xaaa, 0xaab, 0x3f, 
                0xaac, 0xaad, 0xaae, 0xaaf, 0xab0, 0xa00, 0xab2, 0xab3, 0xa00, 0xab5, 0xab6, 0xab7, 0xab8, 0xab9, 0xabc, 0xabd, 
                0xabe, 0xabf, 0xac0, 0xac1, 0xac2, 0xac3, 0xac4, 0xac5, 0xa00, 0xac7, 0xac8, 0xac9, 0xa00, 0xacb, 0xacc, 0xacd, 
                0xad0, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 
                0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0xae0, 0xae1, 0xae2, 0xae3, 0xaf1
        },
        {
                0x901, 0x902, 0x903, 0x905, 0x906, 0x907, 0x908, 0x909, 0x90a, 0x90b, 0xa, 0x90c, 0x90d, 0xd, 0x90e, 0x90f, 
                0x910, 0x911, 0x912, 0x913, 0x914, 0x915, 0x916, 0x917, 0x918, 0x919, 0x91a, 0x1b, 0x91b, 0x91c, 0x91d, 0x91e, 
                0x20, 0x21, 0x91f, 0x920, 0x921, 0x922, 0x923, 0x924, 0x29, 0x28, 0x925, 0x926, 0x2c, 0x927, 0x2e, 0x928, 
                0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x929, 0x92a, 0x92b, 0x3f, 
                0x92c, 0x92d, 0x92e, 0x92f, 0x930, 0x931, 0x932, 0x933, 0x934, 0x935, 0x936, 0x937, 0x938, 0x939, 0x93c, 0x93d, 
                0x93e, 0x93f, 0x940, 0x941, 0x942, 0x943, 0x944, 0x945, 0x946, 0x947, 0x948, 0x949, 0x94a, 0x94b, 0x94c, 0x94d, 
                0x950, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 
                0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x972, 0x97b, 0x97c, 0x97e, 0x97f
        },
        {
                0x900, 0xc82, 0xc83, 0xc85, 0xc86, 0xc87, 0xc88, 0xc89, 0xc8a, 0xc8b, 0xa, 0xc8c, 0xc00, 0xd, 0xc8e, 0xc8f, 
                0xc90, 0xc00, 0xc92, 0xc93, 0xc94, 0xc95, 0xc96, 0xc97, 0xc98, 0xc99, 0xc9a, 0x1b, 0xc9b, 0xc9c, 0xc9d, 0xc9e, 
                0x20, 0x21, 0xc9f, 0xca0, 0xca1, 0xca2, 0xca3, 0xca4, 0x29, 0x28, 0xca5, 0xca6, 0x2c, 0xca7, 0x2e, 0xca8, 
                0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x0, 0xcaa, 0xcab, 0x3f, 
                0xcac, 0xcad, 0xcae, 0xcaf, 0xcb0, 0xcb1, 0xcb2, 0xcb3, 0xc00, 0xcb5, 0xcb6, 0xcb7, 0xcb8, 0xcb9, 0xcbc, 0xcbd, 
                0xcbe, 0xcbf, 0xcc0, 0xcc1, 0xcc2, 0xcc3, 0xcc4, 0xc00, 0xcc6, 0xcc7, 0xcc8, 0xc00, 0xcca, 0xccb, 0xccc, 0xccd, 
                0xcd5, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 
                0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0xcd6, 0xce0, 0xce1, 0xce2, 0xce3
        },
        {
                0xc00, 0xd02, 0xd03, 0xd05, 0xd06, 0xd07, 0xd08, 0xd09, 0xd0a, 0xd0b, 0xa, 0xd0c, 0xd00, 0xd, 0xd0e, 0xd0f, 
                0xd10, 0xd00, 0xd12, 0xd13, 0xd14, 0xd15, 0xd16, 0xd17, 0xd18, 0xd19, 0xd1a, 0x1b, 0xd1b, 0xd1c, 0xd1d, 0xd1e, 
                0x20, 0x21, 0xd1f, 0xd20, 0xd21, 0xd22, 0xd23, 0xd24, 0x29, 0x28, 0xd25, 0xd26, 0x2c, 0xd27, 0x2e, 0xd28, 
                0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x0, 0xd2a, 0xd2b, 0x3f, 
                0xd2c, 0xd2d, 0xd2e, 0xd2f, 0xd30, 0xd31, 0xd32, 0xd33, 0xd34, 0xd35, 0xd36, 0xd37, 0xd38, 0xd39, 0xd00, 0xd3d, 
                0xd3e, 0xd3f, 0xd40, 0xd41, 0xd42, 0xd43, 0xd44, 0xd00, 0xd46, 0xd47, 0xd48, 0xd00, 0xd4a, 0xd4b, 0xd4c, 0xd4d, 
                0xd57, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 
                0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0xd60, 0xd61, 0xd62, 0xd63, 0xd79
        },
        {
                0xb01, 0xb02, 0xb03, 0xb05, 0xb06, 0xb07, 0xb08, 0xb09, 0xb0a, 0xb0b, 0xa, 0xb0c, 0xb00, 0xd, 0x0, 0xb0f, 
                0xb10, 0xb00, 0xb00, 0xb13, 0xb14, 0xb15, 0xb16, 0xb17, 0xb18, 0xb19, 0xb1a, 0x1b, 0xb1b, 0xb1c, 0xb1d, 0xb1e, 
                0x20, 0x21, 0xb1f, 0xb20, 0xb21, 0xb22, 0xb23, 0xb24, 0x29, 0x28, 0xb25, 0xb26, 0x2c, 0xb27, 0x2e, 0xb28, 
                0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x0, 0xb2a, 0xb2b, 0x3f, 
                0xb2c, 0xb2d, 0xb2e, 0xb2f, 0xb30, 0xb00, 0xb32, 0xb33, 0xb00, 0xb35, 0xb36, 0xb37, 0xb38, 0xb39, 0xb3c, 0xb3d, 
                0xb3e, 0xb3f, 0xb40, 0xb41, 0xb42, 0xb43, 0xb44, 0xb00, 0xb00, 0xb47, 0xb48, 0xb00, 0xb00, 0xb4b, 0xb4c, 0xb4d, 
                0xb56, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 
                0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0xb57, 0xb60, 0xb61, 0xb62, 0xb63
        },
        {
                0xa01, 0xa02, 0xa03, 0xa05, 0xa06, 0xa07, 0xa08, 0xa09, 0xa0a, 0xa00, 0xa, 0x0, 0x0, 0xd, 0x0, 0xa0f, 
                0xa10, 0xa00, 0xa00, 0xa13, 0xa14, 0xa15, 0xa16, 0xa17, 0xa18, 0xa19, 0xa1a, 0x1b, 0xa1b, 0xa1c, 0xa1d, 0xa1e, 
                0x20, 0x21, 0xa1f, 0xa20, 0xa21, 0xa22, 0xa23, 0xa24, 0x29, 0x28, 0xa25, 0xa26, 0x2c, 0xa27, 0x2e, 0xa28, 
                0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x0, 0xa2a, 0xa2b, 0x3f, 
                0xa2c, 0xa2d, 0xa2e, 0xa2f, 0xa30, 0xa00, 0xa32, 0xa33, 0xa00, 0xa35, 0xa36, 0xa00, 0xa38, 0xa39, 0xa3c, 0xa00, 
                0xa3e, 0xa3f, 0xa40, 0xa41, 0xa42, 0xa00, 0xa00, 0xa00, 0xa00, 0xa47, 0xa48, 0xa00, 0xa00, 0xa4b, 0xa4c, 0xa4d, 
                0xa51, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 
                0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0xa70, 0xa71, 0xa72, 0xa73, 0xa74
        },
        {
                0xa00, 0xb82, 0xb83, 0xb85, 0xb86, 0xb87, 0xb88, 0xb89, 0xb8a, 0xb00, 0xa, 0x0, 0x0, 0xd, 0xb8e, 0xb8f, 
                0xb90, 0xb00, 0xb92, 0xb93, 0xb94, 0xb95, 0xb00, 0xb00, 0xb00, 0xb99, 0xb9a, 0x1b, 0x0, 0xb9c, 0xb00, 0xb9e, 
                0x20, 0x21, 0xb9f, 0xb00, 0xb00, 0xb00, 0xba3, 0xba4, 0x29, 0x28, 0x0, 0x0, 0x2c, 0x0, 0x2e, 0xba8, 
                0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0xba9, 0xbaa, 0xb00, 0x3f, 
                0x0, 0x0, 0xbae, 0xbaf, 0xbb0, 0xbb1, 0xbb2, 0xbb3, 0xbb4, 0xbb5, 0xbb6, 0xbb7, 0xbb8, 0xbb9, 0xb00, 0xb00, 
                0xbbe, 0xbbf, 0xbc0, 0xbc1, 0xbc2, 0xb00, 0xb00, 0xb00, 0xbc6, 0xbc7, 0xbc8, 0xb00, 0xbca, 0xbcb, 0xbcc, 0xbcd, 
                0xbd0, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 
                0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0xbd7, 0xbf0, 0xbf1, 0xbf2, 0xbf9
        },
        {
                0xc01, 0xc02, 0xc03, 0xc05, 0xc06, 0xc07, 0xc08, 0xc09, 0xc0a, 0xc0b, 0xa, 0xc0c, 0xc00, 0xd, 0xc0e, 0xc0f, 
                0xc10, 0xc00, 0xc12, 0xc13, 0xc14, 0xc15, 0xc16, 0xc17, 0xc18, 0xc19, 0xc1a, 0x1b, 0xc1b, 0xc1c, 0xc1d, 0xc1e, 
                0x20, 0x21, 0xc1f, 0xc20, 0xc21, 0xc22, 0xc23, 0xc24, 0x29, 0x28, 0xc25, 0xc26, 0x2c, 0xc27, 0x2e, 0xc28, 
                0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x0, 0xc2a, 0xc2b, 0x3f, 
                0xc2c, 0xc2d, 0xc2e, 0xc2f, 0xc30, 0xc31, 0xc32, 0xc33, 0xc00, 0xc35, 0xc36, 0xc37, 0xc38, 0xc39, 0xc00, 0xc3d, 
                0xc3e, 0xc3f, 0xc40, 0xc41, 0xc42, 0xc43, 0xc44, 0xc00, 0xc46, 0xc47, 0xc48, 0xc00, 0xc4a, 0xc4b, 0xc4c, 0xc4d, 
                0xc55, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 
                0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0xc56, 0xc60, 0xc61, 0xc62, 0xc63
        },
        {
                0x627, 0x622, 0x628, 0x67b, 0x680, 0x67e, 0x6a6, 0x62a, 0x6c2, 0x67f, 0xa, 0x679, 0x67d, 0xd, 0x67a, 0x67c, 
                0x62b, 0x62c, 0x681, 0x684, 0x683, 0x685, 0x686, 0x687, 0x62d, 0x62e, 0x62f, 0x1b, 0x68c, 0x688, 0x689, 0x68a, 
                0x20, 0x21, 0x68f, 0x68d, 0x630, 0x631, 0x691, 0x693, 0x29, 0x28, 0x699, 0x632, 0x2c, 0x696, 0x2e, 0x698, 
                0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x69a, 0x633, 0x634, 0x3f, 
                0x635, 0x636, 0x637, 0x638, 0x639, 0x641, 0x642, 0x6a9, 0x6aa, 0x6ab, 0x6af, 0x6b3, 0x6b1, 0x644, 0x645, 0x646, 
                0x6ba, 0x6bb, 0x6bc, 0x648, 0x6c4, 0x6d5, 0x6c1, 0x6be, 0x621, 0x6cc, 0x6d0, 0x6d2, 0x64d, 0x650, 0x64f, 0x657, 
                0x654, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 
                0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x655, 0x651, 0x653, 0x656, 0x670
        }
};

static const uint16_t LUT_GSM7_SS16[14][128] = {
        {
                0x600, 0x600, 0x600, 0x600, 0x600, 0x600, 0x600, 0x600, 0x600, 0x600, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 
                0x0, 0x0, 0x0, 0x0, 0x5e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7b, 0x7d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5c, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5b, 0x7e, 0x5d, 0x0, 
                0x7c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0x20ac, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
                0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000
        },
        {
                0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 
                0x0, 0x0, 0x0, 0x0, 0x5e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7b, 0x7d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5c, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5b, 0x7e, 0x5d, 0x0, 
                0x7c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x11e, 0x100, 0x130, 0x100, 0x100, 0x100, 0x100, 0x100, 0x100, 
                0x100, 0x100, 0x100, 0x15e, 0x100, 0x100, 0x100, 0x100, 0x100, 0x100, 0x100, 0x100, 0x100, 0x100, 0x100, 0x100, 
                0x100, 0x100, 0x100, 0xe7, 0x0, 0x20ac, 0x2000, 0x11f, 0x100, 0x131, 0x100, 0x100, 0x100, 0x100, 0x100, 0x100, 
                0x100, 0x100, 0x100, 0x15f, 0x100, 0x100, 0x100, 0x100, 0x100, 0x100, 0x100, 0x100, 0x100, 0x100, 0x100, 0x100
        },
        {
                0x100, 0x100, 0x100, 0x100, 0x100, 0x100, 0x100, 0x100, 0x100, 0xe7, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 
                0x0, 0x0, 0x0, 0x0, 0x5e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7b, 0x7d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5c, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5b, 0x7e, 0x5d, 0x0, 
                0x7c, 0xc1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcd, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd3, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0xda, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
                0x0, 0xe1, 0x0, 0x0, 0x0, 0x20ac, 0x2000, 0x2000, 0x2000, 0xed, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf3, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
        },
        {
                0x0, 0x0, 0x0, 0x0, 0x0, 0xea, 0x0, 0x0, 0x0, 0xe7, 0xc, 0xd4, 0xf4, 0x0, 0xc1, 0xe1, 
                0x0, 0x0, 0x3a6, 0x393, 0x5e, 0x3a9, 0x3a0, 0x3a8, 0x3a3, 0x398, 0x300, 0x300, 0x300, 0x300, 0x300, 0xca, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7b, 0x7d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5c, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5b, 0x7e, 0x5d, 0x0, 
                0x7c, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcd, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd3, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0xda, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc3, 0xd5, 0x0, 0x0, 0x0, 
                0x0, 0xc2, 0x0, 0x0, 0x0, 0x20ac, 0x2000, 0x2000, 0x2000, 0xed, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf3, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe3, 0xf5, 0x0, 0x0, 0xe2
        },
        {
                0x40, 0xa3, 0x24, 0xa5, 0xbf, 0x22, 0xa4, 0x25, 0x26, 0x27, 0xc, 0x2a, 0x2b, 0x0, 0x2d, 0x2f, 
                0x3c, 0x3d, 0x3e, 0xa1, 0x5e, 0xa1, 0x5f, 0x23, 0x2a, 0x9e6, 0x9e7, 0x900, 0x9e8, 0x9e9, 0x9ea, 0x9eb, 
                0x9ec, 0x9ed, 0x9ee, 0x9ef, 0x9df, 0x9e0, 0x9e1, 0x9e2, 0x7b, 0x7d, 0x9e3, 0x9f2, 0x9f3, 0x9f4, 0x9f5, 0x5c, 
                0x9f6, 0x9f7, 0x9f8, 0x9f9, 0x9fa, 0x900, 0x900, 0x900, 0x900, 0x900, 0x900, 0x900, 0x5b, 0x7e, 0x5d, 0x0, 
                0x7c, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 
                0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x0, 0x0, 0x0, 0x0, 0x0, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0x20ac, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
                0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000
        },
        {
                0x40, 0xa3, 0x24, 0xa5, 0xbf, 0x22, 0xa4, 0x25, 0x26, 0x27, 0xc, 0x2a, 0x2b, 0x0, 0x2d, 0x2f, 
                0x3c, 0x3d, 0x3e, 0xa1, 0x5e, 0xa1, 0x5f, 0x23, 0x2a, 0x964, 0x965, 0x900, 0xae6, 0xae7, 0xae8, 0xae9, 
                0xaea, 0xaeb, 0xaec, 0xaed, 0xaee, 0xaef, 0xa00, 0xa00, 0x7b, 0x7d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5c, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5b, 0x7e, 0x5d, 0x0, 
                0x7c, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 
                0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x0, 0x0, 0x0, 0x0, 0x0, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0x20ac, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
                0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000
        },
        {
                0x40, 0xa3, 0x24, 0xa5, 0xbf, 0x22, 0xa4, 0x25, 0x26, 0x27, 0xc, 0x2a, 0x2b, 0x0, 0x2d, 0x2f, 
                0x3c, 0x3d, 0x3e, 0xa1, 0x5e, 0xa1, 0x5f, 0x23, 0x2a, 0x964, 0x965, 0x900, 0x966, 0x967, 0x968, 0x969, 
                0x96a, 0x96b, 0x96c, 0x96d, 0x96e, 0x96f, 0x951, 0x952, 0x7b, 0x7d, 0x953, 0x954, 0x958, 0x959, 0x95a, 0x5c, 
                0x95b, 0x95c, 0x95d, 0x95e, 0x95f, 0x960, 0x961, 0x962, 0x963, 0x970, 0x971, 0x900, 0x5b, 0x7e, 0x5d, 0x0, 
                0x7c, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 
                0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x0, 0x0, 0x0, 0x0, 0x0, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0x20ac, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
                0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000
        },
        {
                0x40, 0xa3, 0x24, 0xa5, 0xbf, 0x22, 0xa4, 0x25, 0x26, 0x27, 0xc, 0x2a, 0x2b, 0x0, 0x2d, 0x2f, 
                0x3c, 0x3d, 0x3e, 0xa1, 0x5e, 0xa1, 0x5f, 0x23, 0x2a, 0x964, 0x965, 0x900, 0xce6, 0xce7, 0xce8, 0xce9, 
                0xcea, 0xceb, 0xcec, 0xced, 0xcee, 0xcef, 0xcde, 0xcf1, 0x7b, 0x7d, 0xcf2, 0xc00, 0xc00, 0xc00, 0xc00, 0x5c, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5b, 0x7e, 0x5d, 0x0, 
                0x7c, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 
                0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x0, 0x0, 0x0, 0x0, 0x0, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0x20ac, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
                0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000
        },
        {
                0x40, 0xa3, 0x24, 0xa5, 0xbf, 0x22, 0xa4, 0x25, 0x26, 0x27, 0xc, 0x2a, 0x2b, 0x0, 0x2d, 0x2f, 
                0x3c, 0x3d, 0x3e, 0xa1, 0x5e, 0xa1, 0x5f, 0x23, 0x2a, 0x964, 0x965, 0x900, 0xd66, 0xd67, 0xd68, 0xd69, 
                0xd6a, 0xd6b, 0xd6c, 0xd6d, 0xd6e, 0xd6f, 0xd70, 0xd71, 0x7b, 0x7d, 0xd72, 0xd73, 0xd74, 0xd75, 0xd7a, 0x5c, 
                0xd7b, 0xd7c, 0xd7d, 0xd7e, 0xd7f, 0xd00, 0xd00, 0xd00, 0xd00, 0xd00, 0xd00, 0xd00, 0x5b, 0x7e, 0x5d, 0x0, 
                0x7c, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 
                0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x0, 0x0, 0x0, 0x0, 0x0, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0x20ac, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
                0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000
        },
        {
                0x40, 0xa3, 0x24, 0xa5, 0xbf, 0x22, 0xa4, 0x25, 0x26, 0x27, 0xc, 0x2a, 0x2b, 0x0, 0x2d, 0x2f, 
                0x3c, 0x3d, 0x3e, 0xa1, 0x5e, 0xa1, 0x5f, 0x23, 0x2a, 0x964, 0x965, 0x900, 0xb66, 0xb67, 0xb68, 0xb69, 
                0xb6a, 0xb6b, 0xb6c, 0xb6d, 0xb6e, 0xb6f, 0xb5c, 0xb5d, 0x7b, 0x7d, 0xb5f, 0xb70, 0xb71, 0xb00, 0xb00, 0x5c, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5b, 0x7e, 0x5d, 0x0, 
                0x7c, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 
                0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x0, 0x0, 0x0, 0x0, 0x0, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0x20ac, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
                0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000
        },
        {
                0x40, 0xa3, 0x24, 0xa5, 0xbf, 0x22, 0xa4, 0x25, 0x26, 0x27, 0xc, 0x2a, 0x2b, 0x0, 0x2d, 0x2f, 
                0x3c, 0x3d, 0x3e, 0xa1, 0x5e, 0xa1, 0x5f, 0x23, 0x2a, 0x964, 0x965, 0x900, 0xa66, 0xa67, 0xa68, 0xa69, 
                0xa6a, 0xa6b, 0xa6c, 0xa6d, 0xa6e, 0xa6f, 0xa59, 0xa5a, 0x7b, 0x7d, 0xa5b, 0xa5c, 0xa5e, 0xa75, 0xa00, 0x5c, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5b, 0x7e, 0x5d, 0x0, 
                0x7c, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 
                0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x0, 0x0, 0x0, 0x0, 0x0, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0x20ac, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
                0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000
        },
        {
                0x40, 0xa3, 0x24, 0xa5, 0xbf, 0x22, 0xa4, 0x25, 0x26, 0x27, 0xc, 0x2a, 0x2b, 0x0, 0x2d, 0x2f, 
                0x3c, 0x3d, 0x3e, 0xa1, 0x5e, 0xa1, 0x5f, 0x23, 0x2a, 0x964, 0x965, 0x900, 0xbe6, 0xbe7, 0xbe8, 0xbe9, 
                0xbea, 0xbeb, 0xbec, 0xbed, 0xbee, 0xbef, 0xbf3, 0xbf4, 0x7b, 0x7d, 0xbf5, 0xbf6, 0xbf7, 0xbf8, 0xbfa, 0x5c, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5b, 0x7e, 0x5d, 0x0, 
                0x7c, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 
                0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x0, 0x0, 0x0, 0x0, 0x0, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0x20ac, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
                0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000
        },
        {
                0x40, 0xa3, 0x24, 0xa5, 0xbf, 0x22, 0xa4, 0x25, 0x26, 0x27, 0xc, 0x2a, 0x2b, 0x0, 0x2d, 0x2f, 
                0x3c, 0x3d, 0x3e, 0xa1, 0x5e, 0xa1, 0x5f, 0x23, 0x2a, 0x0, 0x0, 0x0, 0xc66, 0xc67, 0xc68, 0xc69, 
                0xc6a, 0xc6b, 0xc6c, 0xc6d, 0xc6e, 0xc6f, 0xc58, 0xc59, 0x7b, 0x7d, 0xc78, 0xc79, 0xc7a, 0xc7b, 0xc7c, 0x5c, 
                0xc7d, 0xc7e, 0xc7f, 0xc00, 0xc00, 0xc00, 0xc00, 0xc00, 0xc00, 0xc00, 0xc00, 0xc00, 0x5b, 0x7e, 0x5d, 0x0, 
                0x7c, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 
                0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x0, 0x0, 0x0, 0x0, 0x0, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0x20ac, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
                0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000
        },
        {
                0x40, 0xa3, 0x24, 0xa5, 0xbf, 0x22, 0xa4, 0x25, 0x26, 0x27, 0xc, 0x2a, 0x2b, 0x0, 0x2d, 0x2f, 
                0x3c, 0x3d, 0x3e, 0xa1, 0x5e, 0xa1, 0x5f, 0x23, 0x2a, 0x600, 0x601, 0x600, 0x6f0, 0x6f1, 0x6f2, 0x6f3, 
                0x6f4, 0x6f5, 0x6f6, 0x6f7, 0x6f8, 0x6f9, 0x60c, 0x60d, 0x7b, 0x7d, 0x60e, 0x60f, 0x610, 0x611, 0x612, 0x5c, 
                0x613, 0x614, 0x61b, 0x61f, 0x640, 0x652, 0x658, 0x66b, 0x66c, 0x672, 0x673, 0x6cd, 0x5b, 0x7e, 0x5d, 0x6d4, 
                0x7c, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 
                0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x0, 0x0, 0x0, 0x0, 0x0, 
                0x0, 0x0, 0x0, 0x0, 0x0, 0x20ac, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
                0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000
        }
};

static const int LUT_GSM7_REV1[] = {

	0, 3, -1, 1, -1, -1, 10, -1, -1, 5, 6, 9, 7, 8, -1, -1, 
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
	2, -1, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
};
#define GSM7_INVALID 254
static const uint8_t LUT_GSM7_REV2_INV[] = { 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 };
static const uint8_t LUT_GSM7_REV2[11][256][14] = {
	{
		{ 228, 228, 255, 254, 228, 228, 228, 228, 228, 228, 228, 228, 228, 228 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 10, 10, 254, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 138, 138, 138, 138, 138, 138, 138, 138, 138, 138, 138, 138, 138, 138 }, 
		{ 13, 13, 254, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 27, 27, 254, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 32, 32, 254, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32 }, 
		{ 33, 33, 254, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33 }, 
		{ 34, 34, 254, 34, 133, 133, 133, 133, 133, 133, 133, 133, 133, 133 }, 
		{ 35, 35, 254, 35, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151 }, 
		{ 2, 2, 254, 2, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130 }, 
		{ 37, 37, 254, 37, 135, 135, 135, 135, 135, 135, 135, 135, 135, 135 }, 
		{ 38, 38, 254, 38, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136 }, 
		{ 39, 39, 254, 39, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137 }, 
		{ 40, 40, 254, 40, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41 }, 
		{ 41, 41, 254, 41, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40 }, 
		{ 42, 42, 254, 42, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152 }, 
		{ 43, 43, 254, 43, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140 }, 
		{ 44, 44, 254, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44 }, 
		{ 45, 45, 254, 45, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142 }, 
		{ 46, 46, 254, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46 }, 
		{ 47, 47, 254, 47, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143 }, 
		{ 48, 48, 254, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48 }, 
		{ 49, 49, 254, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49 }, 
		{ 50, 50, 254, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50 }, 
		{ 51, 51, 254, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51 }, 
		{ 52, 52, 254, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52 }, 
		{ 53, 53, 254, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53 }, 
		{ 54, 54, 254, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54 }, 
		{ 55, 55, 254, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55 }, 
		{ 56, 56, 254, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56 }, 
		{ 57, 57, 254, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57 }, 
		{ 58, 58, 254, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58 }, 
		{ 59, 59, 254, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59 }, 
		{ 60, 60, 254, 60, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144 }, 
		{ 61, 61, 254, 61, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145 }, 
		{ 62, 62, 254, 62, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146 }, 
		{ 63, 63, 254, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63 }, 
		{ 0, 0, 254, 0, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 }, 
		{ 65, 65, 254, 65, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193 }, 
		{ 66, 66, 254, 66, 194, 194, 194, 194, 194, 194, 194, 194, 194, 194 }, 
		{ 67, 67, 254, 67, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195 }, 
		{ 68, 68, 254, 68, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196 }, 
		{ 69, 69, 254, 69, 197, 197, 197, 197, 197, 197, 197, 197, 197, 197 }, 
		{ 70, 70, 254, 70, 198, 198, 198, 198, 198, 198, 198, 198, 198, 198 }, 
		{ 71, 71, 254, 71, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199 }, 
		{ 72, 72, 254, 72, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200 }, 
		{ 73, 73, 254, 73, 201, 201, 201, 201, 201, 201, 201, 201, 201, 201 }, 
		{ 74, 74, 254, 74, 202, 202, 202, 202, 202, 202, 202, 202, 202, 202 }, 
		{ 75, 75, 254, 75, 203, 203, 203, 203, 203, 203, 203, 203, 203, 203 }, 
		{ 76, 76, 254, 76, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204 }, 
		{ 77, 77, 254, 77, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205 }, 
		{ 78, 78, 254, 78, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206 }, 
		{ 79, 79, 254, 79, 207, 207, 207, 207, 207, 207, 207, 207, 207, 207 }, 
		{ 80, 80, 254, 80, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208 }, 
		{ 81, 81, 254, 81, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209 }, 
		{ 82, 82, 254, 82, 210, 210, 210, 210, 210, 210, 210, 210, 210, 210 }, 
		{ 83, 83, 254, 83, 211, 211, 211, 211, 211, 211, 211, 211, 211, 211 }, 
		{ 84, 84, 254, 84, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212 }, 
		{ 85, 85, 254, 85, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213 }, 
		{ 86, 86, 254, 86, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214 }, 
		{ 87, 87, 254, 87, 215, 215, 215, 215, 215, 215, 215, 215, 215, 215 }, 
		{ 88, 88, 254, 88, 216, 216, 216, 216, 216, 216, 216, 216, 216, 216 }, 
		{ 89, 89, 254, 89, 217, 217, 217, 217, 217, 217, 217, 217, 217, 217 }, 
		{ 90, 90, 254, 90, 218, 218, 218, 218, 218, 218, 218, 218, 218, 218 }, 
		{ 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188 }, 
		{ 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175 }, 
		{ 190, 190, 190, 190, 190, 190, 190, 190, 190, 190, 190, 190, 190, 190 }, 
		{ 148, 148, 148, 148, 148, 148, 148, 148, 148, 148, 148, 148, 148, 148 }, 
		{ 17, 17, 254, 17, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150 }, 
		{ 254, 254, 254, 125, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 97, 97, 254, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97 }, 
		{ 98, 98, 254, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98 }, 
		{ 99, 99, 254, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99 }, 
		{ 100, 100, 254, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100 }, 
		{ 101, 101, 254, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101 }, 
		{ 102, 102, 254, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102 }, 
		{ 103, 103, 254, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103 }, 
		{ 104, 104, 254, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104 }, 
		{ 105, 105, 254, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105 }, 
		{ 106, 106, 254, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106 }, 
		{ 107, 107, 254, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107 }, 
		{ 108, 108, 254, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108 }, 
		{ 109, 109, 254, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109 }, 
		{ 110, 110, 254, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110 }, 
		{ 111, 111, 254, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111 }, 
		{ 112, 112, 254, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112 }, 
		{ 113, 113, 254, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113 }, 
		{ 114, 114, 254, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114 }, 
		{ 115, 115, 254, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115 }, 
		{ 116, 116, 254, 116, 116, 116, 116, 116, 116, 116, 116, 116, 116, 116 }, 
		{ 117, 117, 254, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117 }, 
		{ 118, 118, 254, 118, 118, 118, 118, 118, 118, 118, 118, 118, 118, 118 }, 
		{ 119, 119, 254, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119 }, 
		{ 120, 120, 254, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120 }, 
		{ 121, 121, 254, 121, 121, 121, 121, 121, 121, 121, 121, 121, 121, 121 }, 
		{ 122, 122, 254, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122 }, 
		{ 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168 }, 
		{ 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192 }, 
		{ 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169 }, 
		{ 189, 189, 189, 189, 189, 189, 189, 189, 189, 189, 189, 189, 189, 189 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 64, 254, 254, 254, 149, 149, 149, 149, 149, 149, 149, 149, 149, 149 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 1, 1, 254, 1, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129 }, 
		{ 36, 36, 254, 254, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134 }, 
		{ 3, 3, 254, 3, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 95, 95, 254, 95, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 18, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 36, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 96, 254, 254, 254, 132, 132, 132, 132, 132, 132, 132, 132, 132, 132 }, 
		{ 254, 254, 254, 193, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 193, 142, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 225, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 219, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 91, 91, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 14, 14, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 28, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 9, 9, 254, 19, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 31, 31, 254, 31, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 159, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 201, 201, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 93, 93, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 207, 207, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 139, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 220, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 92, 92, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 11, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 213, 213, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 94, 94, 254, 94, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 30, 30, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 127, 127, 254, 127, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 225, 143, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 255, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 251, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 123, 123, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 15, 15, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 29, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 227, 137, 137, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 4, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 5, 5, 254, 5, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 133, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 7, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 233, 233, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 125, 125, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 8, 8, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 239, 239, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 140, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 252, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 124, 124, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 12, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 6, 6, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 245, 245, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 126, 126, 254, 126, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }
	},
	{
		{ 254, 254, 254, 158, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 19, 19, 254, 147, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 16, 16, 254, 16, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 25, 25, 254, 153, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 20, 20, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 26, 26, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 22, 22, 254, 150, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 24, 24, 254, 152, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 18, 18, 254, 146, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 23, 23, 254, 151, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 21, 21, 254, 149, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }
	},
	{
		{ 255, 230, 232, 232, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }
	},
	{
		{ 254, 255, 136, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 199, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 231, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 201, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 233, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 211, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 243, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }
	},
	{
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 21, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }
	},
	{
		{ 254, 254, 254, 254, 187, 155, 187, 155, 155, 155, 155, 155, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 0, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 1, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 2, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 3, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 4, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 5, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 6, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 7, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 8, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 9, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 11, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 12, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 14, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 15, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 16, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 17, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 18, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 19, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 20, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 21, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 22, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 23, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 24, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 25, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 26, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 28, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 29, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 30, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 31, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 34, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 35, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 36, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 37, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 38, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 39, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 42, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 43, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 45, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 47, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 60, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 61, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 62, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 64, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 65, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 66, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 67, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 68, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 69, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 70, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 71, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 72, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 73, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 74, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 75, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 76, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 77, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 78, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 79, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 80, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 81, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 82, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 83, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 84, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 85, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 86, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 87, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 88, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 89, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 90, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 91, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 92, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 93, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 94, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 95, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 96, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 166, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 167, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 170, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 171, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 172, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 173, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 174, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 176, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 177, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 178, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 179, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 180, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 181, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 182, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 183, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 184, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 153, 153, 153, 153, 153, 153, 153, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 154, 154, 154, 154, 154, 154, 154, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 156, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 157, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 158, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 159, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 160, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 161, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 162, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 163, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 164, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 165, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 185, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 186, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 123, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 124, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 125, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 126, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 127, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 0, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 1, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 2, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 3, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 4, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 5, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 6, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 7, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 8, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 9, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 11, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 15, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 16, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 19, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 20, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 21, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 22, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 23, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 24, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 25, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 26, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 28, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 29, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 30, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 31, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 34, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 35, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 36, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 37, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 38, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 39, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 42, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 43, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 45, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 47, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 61, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 62, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 64, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 65, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 66, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 67, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 68, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 70, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 74, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 75, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 76, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 77, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 78, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 79, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 80, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 81, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 82, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 83, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 84, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 85, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 86, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 89, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 90, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 93, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 94, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 95, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 96, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 123, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 124, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 125, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 164, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 165, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 166, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 167, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 170, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 153, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 154, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 156, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 157, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 158, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 159, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 160, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 161, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 162, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 163, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 126, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 127, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 171, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 172, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 173, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 174, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 176, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 177, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 178, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 179, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 180, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }
	},
	{
		{ 254, 254, 254, 254, 254, 167, 254, 254, 254, 254, 174, 0, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 0, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 1, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 2, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 3, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 4, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 5, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 6, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 7, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 8, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 15, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 16, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 19, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 20, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 21, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 22, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 23, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 24, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 25, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 26, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 28, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 29, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 30, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 31, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 34, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 35, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 36, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 37, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 38, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 39, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 42, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 43, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 45, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 47, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 61, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 62, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 64, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 65, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 66, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 67, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 68, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 70, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 71, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 73, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 74, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 76, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 77, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 78, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 80, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 81, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 82, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 83, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 84, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 89, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 90, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 93, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 94, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 95, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 96, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 166, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 167, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 170, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 171, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 172, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 156, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 157, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 158, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 159, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 160, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 161, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 162, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 163, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 164, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 165, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 123, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 124, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 125, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 126, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 127, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 173, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 0, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 1, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 2, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 3, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 4, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 5, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 6, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 7, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 8, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 9, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 11, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 12, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 15, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 16, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 17, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 19, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 20, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 21, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 22, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 23, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 24, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 25, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 26, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 28, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 29, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 30, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 31, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 34, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 35, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 36, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 37, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 38, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 39, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 42, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 43, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 45, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 47, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 61, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 62, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 64, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 65, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 66, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 67, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 68, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 70, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 71, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 73, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 74, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 75, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 76, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 77, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 78, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 79, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 80, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 81, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 82, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 83, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 84, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 85, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 86, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 87, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 89, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 90, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 91, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 93, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 94, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 95, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 96, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 123, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 124, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 125, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 126, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 156, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 157, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 158, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 159, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 160, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 161, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 162, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 163, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 164, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 165, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 127, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }
	},
	{
		{ 254, 254, 254, 254, 254, 254, 254, 174, 0, 254, 254, 254, 187, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 0, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 1, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 2, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 3, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 4, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 5, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 6, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 7, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 8, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 9, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 11, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 14, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 15, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 16, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 18, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 19, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 20, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 21, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 22, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 23, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 24, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 25, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 26, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 28, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 29, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 30, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 31, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 34, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 35, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 36, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 37, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 38, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 39, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 42, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 43, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 45, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 47, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 61, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 62, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 64, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 65, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 66, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 67, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 68, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 69, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 70, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 71, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 73, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 74, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 75, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 76, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 77, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 79, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 80, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 81, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 82, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 83, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 84, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 85, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 86, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 88, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 89, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 90, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 92, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 93, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 94, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 95, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 96, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 123, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 166, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 167, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 124, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 125, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 126, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 127, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 156, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 157, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 158, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 159, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 160, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 161, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 162, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 163, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 164, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 165, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 170, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 171, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 172, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 173, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 174, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 176, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 177, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 178, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 1, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 2, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 3, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 4, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 5, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 6, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 7, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 8, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 9, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 11, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 14, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 15, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 16, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 18, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 19, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 20, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 21, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 22, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 23, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 24, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 25, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 26, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 28, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 29, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 30, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 31, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 34, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 35, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 36, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 37, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 38, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 39, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 42, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 43, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 45, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 47, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 61, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 62, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 64, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 65, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 66, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 67, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 68, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 69, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 70, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 71, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 73, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 74, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 75, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 76, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 77, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 78, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 79, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 80, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 81, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 82, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 83, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 84, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 85, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 86, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 88, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 89, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 90, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 92, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 93, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 94, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 95, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 96, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 123, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 166, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 124, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 125, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 126, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 127, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 156, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 157, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 158, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 159, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 160, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 161, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 162, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 163, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 164, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 165, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 167, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 170, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }
	},
	{
		{ 254, 254, 254, 254, 254, 254, 254, 254, 187, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 1, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 2, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 3, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 4, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 5, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 6, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 7, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 8, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 9, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 11, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 14, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 15, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 16, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 18, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 19, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 20, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 21, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 22, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 23, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 24, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 25, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 26, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 28, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 29, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 30, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 31, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 34, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 35, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 36, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 37, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 38, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 39, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 42, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 43, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 45, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 47, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 61, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 62, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 64, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 65, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 66, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 67, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 68, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 69, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 70, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 71, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 72, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 73, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 74, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 75, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 76, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 77, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 79, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 80, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 81, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 82, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 83, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 84, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 85, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 86, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 88, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 89, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 90, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 92, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 93, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 94, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 95, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 96, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 123, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 124, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 125, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 126, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 156, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 157, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 158, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 159, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 160, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 161, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 162, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 163, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 164, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 165, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 166, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 167, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 170, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 171, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 172, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 173, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 127, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 174, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 176, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 177, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 178, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 179, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 180, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }
	},
	{
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 174, 254, 91, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 0, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 1, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 2, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 3, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 4, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 5, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 6, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 7, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 8, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 9, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 11, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 15, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 16, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 19, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 20, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 21, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 22, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 23, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 24, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 25, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 26, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 28, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 29, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 30, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 31, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 34, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 35, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 36, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 37, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 38, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 39, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 42, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 43, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 45, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 47, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 61, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 62, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 64, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 65, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 66, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 67, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 68, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 70, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 71, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 73, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 74, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 75, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 76, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 77, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 78, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 79, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 80, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 81, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 82, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 83, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 84, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 85, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 86, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 89, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 90, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 93, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 94, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 95, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 96, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 123, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 166, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 167, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 170, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 124, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 125, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 126, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 127, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 156, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 157, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 158, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 159, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 160, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 161, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 162, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 163, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 164, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 165, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 171, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 172, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 1, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 2, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 3, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 4, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 5, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 6, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 7, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 8, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 14, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 15, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 16, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 18, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 19, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 20, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 21, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 25, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 26, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 29, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 31, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 34, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 38, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 39, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 47, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 60, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 61, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 66, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 67, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 68, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 69, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 70, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 71, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 72, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 73, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 74, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 75, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 76, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 77, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 80, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 81, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 82, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 83, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 84, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 88, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 89, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 90, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 92, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 93, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 94, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 95, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 96, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 123, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 156, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 157, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 158, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 159, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 160, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 161, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 162, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 163, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 164, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 165, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 124, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 125, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 126, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 166, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 167, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 170, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 171, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 172, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 173, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 127, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 174, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }
	},
	{
		{ 137, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 155 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 154 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 166 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 167 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 170 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 171 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 172 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 173 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 174 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 176 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 177 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 178 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 179 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 88 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 1 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 0 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 2 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 7 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 16 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 17 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 24 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 25 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 26 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 36 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 37 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 43 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 61 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 62 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 64 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 65 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 66 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 67 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 68 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 180 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 69 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 70 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 77 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 78 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 79 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 83 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 92 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 94 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 93 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 124 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 181 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 125 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 96 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 123 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 126 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 95 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 182 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 183 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 184 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 127 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 185 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 186 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 11 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 14 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 3 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 15 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 12 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 5 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 9 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 4 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 18 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 20 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 19 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 21 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 22 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 23 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 29 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 30 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 31 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 28 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 35 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 34 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 38 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 39 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 45 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 47 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 42 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 60 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 6 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 71 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 72 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 73 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 74 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 76 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 75 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 80 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 81 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 82 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 87 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 86 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 8 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 84 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 89 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 187 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 90 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 91 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 191 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 85 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 156 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 157 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 158 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 159 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 160 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 161 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 162 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 163 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 164 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 165 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }, 
		{ 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254 }
	}
};

#endif
