"use strict";
/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.CrtError = void 0;
/**
 * @packageDocumentation
 * @module crt
 */
/**
 * Represents an error thrown by the CRT browser shim
 *
 * @category System
 */
class CrtError extends Error {
    /**
     * @param error - The original error, provided for context. Could be any type, often from underlying libraries
     */
    constructor(error) {
        super(error.toString());
        this.error = error;
    }
}
exports.CrtError = CrtError;
//# sourceMappingURL=error.js.map