/**
 * @packageDocumentation
 * @module mqtt
 */
import { MqttConnectionConfig } from "./mqtt";
import { WebsocketOptionsBase } from "../common/auth";
/**
 * Options for websocket based connections in browser
 *
 * @category MQTT
 */
export interface WebsocketOptions extends WebsocketOptionsBase {
    /** Additional headers to add */
    headers?: {
        [index: string]: string;
    };
    /** Websocket protocol, used during Upgrade */
    protocol?: string;
}
/** @internal */
export declare function create_websocket_url(config: MqttConnectionConfig): string;
/** @internal */
export declare function create_websocket_stream(config: MqttConnectionConfig): any;
