/**
 *
 * A module containing miscellaneous functionality that is shared across both native and browser for aws_iot
 *
 * @packageDocumentation
 * @module aws_iot
 */
/**
 * A helper function to add parameters to the username in with_custom_authorizer function
 *
 * @internal
 */
export declare function add_to_username_parameter(current_username: string, parameter_value: string, parameter_pre_text: string): string;
/**
 * A helper function to see if a string is not null, is defined, and is not an empty string
 *
 * @internal
 */
export declare function is_string_and_not_empty(item: any): boolean;
/**
 * A helper function to populate the username with the Custom Authorizer fields
 * @param current_username the current username
 * @param input_username the username to add - can be an empty string to skip
 * @param input_authorizer the name of the authorizer to add - can be an empty string to skip
 * @param input_signature the name of the signature to add - can be an empty string to skip
 * @param input_builder_username the username from the MQTT builder
 * @returns The finished username with the additions added to it
 *
 * @internal
 */
export declare function populate_username_string_with_custom_authorizer(current_username?: string, input_username?: string, input_authorizer?: string, input_signature?: string, input_builder_username?: string): string;
