"use strict";
/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.RetryJitterType = exports.ClientSessionBehavior = void 0;
/**
 * Controls how the MQTT5 client should behave with respect to MQTT sessions.
 */
var ClientSessionBehavior;
(function (ClientSessionBehavior) {
    /** Maps to Clean */
    ClientSessionBehavior[ClientSessionBehavior["Default"] = 0] = "Default";
    /**
     * Always ask for a clean session when connecting
     */
    ClientSessionBehavior[ClientSessionBehavior["Clean"] = 1] = "Clean";
    /**
     * Always attempt to rejoin an existing session after an initial connection success.
     *
     * Session rejoin requires an appropriate non-zero session expiry interval in the client's CONNECT options.
     */
    ClientSessionBehavior[ClientSessionBehavior["RejoinPostSuccess"] = 2] = "RejoinPostSuccess";
    /**
     * Always attempt to rejoin an existing session.  Since the client does not yet support durable session persistence,
     * this option is not guaranteed to be spec compliant because any unacknowledged qos1 publishes (which are
     * part of the client session state) will not be present on the initial connection.  Until we support
     * durable session resumption, this option is technically spec-breaking, but useful.
     */
    ClientSessionBehavior[ClientSessionBehavior["RejoinAlways"] = 3] = "RejoinAlways";
})(ClientSessionBehavior = exports.ClientSessionBehavior || (exports.ClientSessionBehavior = {}));
/**
 * Controls how the reconnect delay is modified in order to smooth out the distribution of reconnection attempt
 * timepoints for a large set of reconnecting clients.
 *
 * See [Exponential Backoff and Jitter](https://aws.amazon.com/blogs/architecture/exponential-backoff-and-jitter/)
 */
var RetryJitterType;
(function (RetryJitterType) {
    /**
     * Maps to Full
     */
    RetryJitterType[RetryJitterType["Default"] = 0] = "Default";
    /**
     * Do not perform any randomization on the reconnect delay:
     * ```NextReconnectDelay = CurrentExponentialBackoffValue```
     */
    RetryJitterType[RetryJitterType["None"] = 1] = "None";
    /**
     * Fully random between no delay and the current exponential backoff value.
     * ```NextReconnectDelay = Random(0, CurrentExponentialBackoffValue)```
     */
    RetryJitterType[RetryJitterType["Full"] = 2] = "Full";
    /**
     * ```NextReconnectDelay = Min(MaxReconnectDelay, Random(MinReconnectDelay, 3 * CurrentReconnectDelay)```
     */
    RetryJitterType[RetryJitterType["Decorrelated"] = 3] = "Decorrelated";
})(RetryJitterType = exports.RetryJitterType || (exports.RetryJitterType = {}));
//# sourceMappingURL=mqtt5.js.map