import { Hashable } from "../common/crypto";
/**
 * Computes an crc32 checksum.
 *
 * @param data The data to checksum
 * @param previous previous crc32 checksum result. Used if you are buffering large input.
 *
 * @category Crypto
 */
export declare function crc32(data: Hashable, previous?: number): number;
/**
 * Computes a crc32c checksum.
 *
 * @param data The data to checksum
 * @param previous previous crc32c checksum result. Used if you are buffering large input.
 *
 * @category Crypto
 */
export declare function crc32c(data: Hashable, previous?: number): number;
