"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const path = __importStar(require("path"));
const os_1 = require("os");
const fs_1 = require("fs");
const process_1 = require("process");
const upgrade_string = "Please upgrade to node >=10.16.0, or use the provided browser implementation.";
if ('napi' in process_1.versions) {
    const napi_version = parseInt(process_1.versions['napi']);
    if (napi_version < 4) {
        throw new Error("The AWS CRT native implementation requires that NAPI version 4 be present. " + upgrade_string);
    }
}
else {
    throw new Error("The current runtime is not reporting an NAPI version. " + upgrade_string);
}
const binary_name = 'aws-crt-nodejs';
const platformDir = `${os_1.platform}-${os_1.arch}`;
let source_root = path.resolve(__dirname, '..', '..');
const dist = path.join(source_root, 'dist');
if (fs_1.existsSync(dist)) {
    source_root = dist;
}
const bin_path = path.resolve(source_root, 'bin');
const search_paths = [
    path.join(bin_path, 'native', binary_name),
    path.join(bin_path, platformDir, binary_name),
];
let binding;
for (const path of search_paths) {
    if (fs_1.existsSync(path + '.node')) {
        binding = require(path);
        break;
    }
}
if (binding == undefined) {
    throw new Error("AWS CRT binary not present in any of the following locations:\n\t" + search_paths.join('\n\t'));
}
exports.default = binding;
//# sourceMappingURL=binding.js.map