/**
 * Service clients and data models for interacting with AWS Iot services:
 * - Greengrass Discovery
 * - Identity
 * - Jobs
 * - Shadow
 *
 * @packageDocumentation
 */
import * as iotidentity from './iotidentity/iotidentityclient';
import * as greengrass from './greengrass/discoveryclient';
import * as iotjobs from './iotjobs/iotjobsclient';
import * as iotshadow from './iotshadow/iotshadowclient';
import { auth, http, io, iot, mqtt, mqtt5, CrtError } from 'aws-crt';
export { auth, greengrass, http, io, iot, iotidentity, iotjobs, iotshadow, mqtt, mqtt5, CrtError };
