/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */
/**
 * Describes an IoT endpoint that a device can connect to
 *
 * API Documentation: https://docs.aws.amazon.com/greengrass/latest/developerguide/gg-discover-api.html
 *
 * @module aws-iot-device-sdk
 * @category Greengrass
 */
export declare class ConnectivityInfo {
    readonly id: string;
    readonly host_address: string;
    readonly port: number;
    readonly metadata?: any;
    private constructor();
    /** @internal */
    static from_json(json: any): ConnectivityInfo;
}
/**
 * Describes a Greengrass Core
 *
 * API Documentation: https://docs.aws.amazon.com/greengrass/latest/developerguide/gg-discover-api.html
 *
 * @module aws-iot-device-sdk
 * @category Greengrass
 */
export declare class GGCore {
    readonly thing_arn: string;
    readonly connectivity: ConnectivityInfo[];
    private constructor();
    /** @internal */
    static from_json(json: any): GGCore;
}
/**
 * Describes a Greengrass group
 *
 * API Documentation: https://docs.aws.amazon.com/greengrass/latest/developerguide/gg-discover-api.html
 *
 * @module aws-iot-device-sdk
 * @category Greengrass
 */
export declare class GGGroup {
    readonly gg_group_id: string;
    readonly cores: GGCore[];
    readonly certificate_authorities: string[];
    private constructor();
    /** @internal */
    static from_json(json: any): GGGroup;
}
/**
 * Response returned from a {@link DiscoveryClient.discover} call
 *
 * API Documentation: https://docs.aws.amazon.com/greengrass/latest/developerguide/gg-discover-api.html
 *
 * @module aws-iot-device-sdk
 * @category Greengrass
 */
export declare class DiscoverResponse {
    readonly gg_groups: GGGroup[];
    private constructor();
    /** @internal */
    static from_json(json: any): DiscoverResponse;
}
