"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotJobsClient = exports.IotJobsError = exports.model = void 0;
const model = __importStar(require("./model"));
exports.model = model;
const util_1 = require("util");
/**
 * @module aws-iot-device-sdk
 * @category IotJobs
 */
class IotJobsError extends Error {
    constructor(message, payload) {
        // 'Error' breaks JS prototype chain when instantiated
        super(message);
        this.payload = payload;
        // restore prototype chain
        const myProto = new.target.prototype;
        if (Object.setPrototypeOf) {
            Object.setPrototypeOf(this, myProto);
        }
        else {
            this.prototype = myProto;
        }
    }
}
exports.IotJobsError = IotJobsError;
/**
 * API Documentation: https://docs.aws.amazon.com/iot/latest/developerguide/jobs-api.html#jobs-mqtt-api
 *
 * @module aws-iot-device-sdk
 * @category IotJobs
 */
class IotJobsClient {
    constructor(connection) {
        this.connection = connection;
        this.decoder = new util_1.TextDecoder('utf-8');
    }
    /**
     * API Documentation: https://docs.aws.amazon.com/iot/latest/developerguide/jobs-api.html#mqtt-jobexecutionschanged
     *
     * Subscribe to JobExecutionsChangedEvents messages
     *
     * subscribeToJobExecutionsChangedEvents may be called while the device is offline, though the async
     * operation cannot complete successfully until the connection resumes.
     *
     * Once subscribed, `messageHandler` is invoked each time a message matching
     * the `topic` is received. It is possible for such messages to arrive before
     * the SUBACK is received.
     *
     * @param request Subscription request configuration
     * @param qos Maximum requested QoS that server may use when sending messages to the client.
     *            The server may grant a lower QoS in the SUBACK
     * @param messageHandler Callback invoked when message or error is received from the server.
     * @returns Promise which returns a `mqtt.MqttSubscribeRequest` which will contain the
     *          result of the SUBSCRIBE. The Promise resolves when a SUBACK is returned
     *          from the server or is rejected when an exception occurs.
     *
     * @category IotJobs
     */
    subscribeToJobExecutionsChangedEvents(request, qos, messageHandler) {
        return __awaiter(this, void 0, void 0, function* () {
            let topic = "$aws/things/{thingName}/jobs/notify";
            topic = topic.replace("{thingName}", request.thingName);
            const on_message = (topic, payload) => {
                let response;
                let error;
                try {
                    const payload_text = this.decoder.decode(payload);
                    response = JSON.parse(payload_text);
                }
                catch (err) {
                    error = new IotJobsError(err.message, payload);
                }
                finally {
                    messageHandler(error, response);
                }
            };
            return this.connection.subscribe(topic, qos, on_message);
        });
    }
    /**
     * API Documentation: https://docs.aws.amazon.com/iot/latest/developerguide/jobs-api.html#mqtt-startnextpendingjobexecution
     *
     * Subscribe to StartNextPendingJobExecutionAccepted messages
     *
     * subscribeToStartNextPendingJobExecutionAccepted may be called while the device is offline, though the async
     * operation cannot complete successfully until the connection resumes.
     *
     * Once subscribed, `messageHandler` is invoked each time a message matching
     * the `topic` is received. It is possible for such messages to arrive before
     * the SUBACK is received.
     *
     * @param request Subscription request configuration
     * @param qos Maximum requested QoS that server may use when sending messages to the client.
     *            The server may grant a lower QoS in the SUBACK
     * @param messageHandler Callback invoked when message or error is received from the server.
     * @returns Promise which returns a `mqtt.MqttSubscribeRequest` which will contain the
     *          result of the SUBSCRIBE. The Promise resolves when a SUBACK is returned
     *          from the server or is rejected when an exception occurs.
     *
     * @category IotJobs
     */
    subscribeToStartNextPendingJobExecutionAccepted(request, qos, messageHandler) {
        return __awaiter(this, void 0, void 0, function* () {
            let topic = "$aws/things/{thingName}/jobs/start-next/accepted";
            topic = topic.replace("{thingName}", request.thingName);
            const on_message = (topic, payload) => {
                let response;
                let error;
                try {
                    const payload_text = this.decoder.decode(payload);
                    response = JSON.parse(payload_text);
                }
                catch (err) {
                    error = new IotJobsError(err.message, payload);
                }
                finally {
                    messageHandler(error, response);
                }
            };
            return this.connection.subscribe(topic, qos, on_message);
        });
    }
    /**
     * API Documentation: https://docs.aws.amazon.com/iot/latest/developerguide/jobs-api.html#mqtt-describejobexecution
     *
     * Subscribe to DescribeJobExecutionRejected messages
     *
     * subscribeToDescribeJobExecutionRejected may be called while the device is offline, though the async
     * operation cannot complete successfully until the connection resumes.
     *
     * Once subscribed, `messageHandler` is invoked each time a message matching
     * the `topic` is received. It is possible for such messages to arrive before
     * the SUBACK is received.
     *
     * @param request Subscription request configuration
     * @param qos Maximum requested QoS that server may use when sending messages to the client.
     *            The server may grant a lower QoS in the SUBACK
     * @param messageHandler Callback invoked when message or error is received from the server.
     * @returns Promise which returns a `mqtt.MqttSubscribeRequest` which will contain the
     *          result of the SUBSCRIBE. The Promise resolves when a SUBACK is returned
     *          from the server or is rejected when an exception occurs.
     *
     * @category IotJobs
     */
    subscribeToDescribeJobExecutionRejected(request, qos, messageHandler) {
        return __awaiter(this, void 0, void 0, function* () {
            let topic = "$aws/things/{thingName}/jobs/{jobId}/get/rejected";
            topic = topic.replace("{thingName}", request.thingName);
            topic = topic.replace("{jobId}", request.jobId);
            const on_message = (topic, payload) => {
                let response;
                let error;
                try {
                    const payload_text = this.decoder.decode(payload);
                    response = JSON.parse(payload_text);
                }
                catch (err) {
                    error = new IotJobsError(err.message, payload);
                }
                finally {
                    messageHandler(error, response);
                }
            };
            return this.connection.subscribe(topic, qos, on_message);
        });
    }
    /**
     * API Documentation: https://docs.aws.amazon.com/iot/latest/developerguide/jobs-api.html#mqtt-nextjobexecutionchanged
     *
     * Subscribe to NextJobExecutionChangedEvents messages
     *
     * subscribeToNextJobExecutionChangedEvents may be called while the device is offline, though the async
     * operation cannot complete successfully until the connection resumes.
     *
     * Once subscribed, `messageHandler` is invoked each time a message matching
     * the `topic` is received. It is possible for such messages to arrive before
     * the SUBACK is received.
     *
     * @param request Subscription request configuration
     * @param qos Maximum requested QoS that server may use when sending messages to the client.
     *            The server may grant a lower QoS in the SUBACK
     * @param messageHandler Callback invoked when message or error is received from the server.
     * @returns Promise which returns a `mqtt.MqttSubscribeRequest` which will contain the
     *          result of the SUBSCRIBE. The Promise resolves when a SUBACK is returned
     *          from the server or is rejected when an exception occurs.
     *
     * @category IotJobs
     */
    subscribeToNextJobExecutionChangedEvents(request, qos, messageHandler) {
        return __awaiter(this, void 0, void 0, function* () {
            let topic = "$aws/things/{thingName}/jobs/notify-next";
            topic = topic.replace("{thingName}", request.thingName);
            const on_message = (topic, payload) => {
                let response;
                let error;
                try {
                    const payload_text = this.decoder.decode(payload);
                    response = JSON.parse(payload_text);
                }
                catch (err) {
                    error = new IotJobsError(err.message, payload);
                }
                finally {
                    messageHandler(error, response);
                }
            };
            return this.connection.subscribe(topic, qos, on_message);
        });
    }
    /**
     * API Documentation: https://docs.aws.amazon.com/iot/latest/developerguide/jobs-api.html#mqtt-updatejobexecution
     *
     * Subscribe to UpdateJobExecutionRejected messages
     *
     * subscribeToUpdateJobExecutionRejected may be called while the device is offline, though the async
     * operation cannot complete successfully until the connection resumes.
     *
     * Once subscribed, `messageHandler` is invoked each time a message matching
     * the `topic` is received. It is possible for such messages to arrive before
     * the SUBACK is received.
     *
     * @param request Subscription request configuration
     * @param qos Maximum requested QoS that server may use when sending messages to the client.
     *            The server may grant a lower QoS in the SUBACK
     * @param messageHandler Callback invoked when message or error is received from the server.
     * @returns Promise which returns a `mqtt.MqttSubscribeRequest` which will contain the
     *          result of the SUBSCRIBE. The Promise resolves when a SUBACK is returned
     *          from the server or is rejected when an exception occurs.
     *
     * @category IotJobs
     */
    subscribeToUpdateJobExecutionRejected(request, qos, messageHandler) {
        return __awaiter(this, void 0, void 0, function* () {
            let topic = "$aws/things/{thingName}/jobs/{jobId}/update/rejected";
            topic = topic.replace("{jobId}", request.jobId);
            topic = topic.replace("{thingName}", request.thingName);
            const on_message = (topic, payload) => {
                let response;
                let error;
                try {
                    const payload_text = this.decoder.decode(payload);
                    response = JSON.parse(payload_text);
                }
                catch (err) {
                    error = new IotJobsError(err.message, payload);
                }
                finally {
                    messageHandler(error, response);
                }
            };
            return this.connection.subscribe(topic, qos, on_message);
        });
    }
    /**
     * API Documentation: https://docs.aws.amazon.com/iot/latest/developerguide/jobs-api.html#mqtt-updatejobexecution
     *
     * Subscribe to UpdateJobExecutionAccepted messages
     *
     * subscribeToUpdateJobExecutionAccepted may be called while the device is offline, though the async
     * operation cannot complete successfully until the connection resumes.
     *
     * Once subscribed, `messageHandler` is invoked each time a message matching
     * the `topic` is received. It is possible for such messages to arrive before
     * the SUBACK is received.
     *
     * @param request Subscription request configuration
     * @param qos Maximum requested QoS that server may use when sending messages to the client.
     *            The server may grant a lower QoS in the SUBACK
     * @param messageHandler Callback invoked when message or error is received from the server.
     * @returns Promise which returns a `mqtt.MqttSubscribeRequest` which will contain the
     *          result of the SUBSCRIBE. The Promise resolves when a SUBACK is returned
     *          from the server or is rejected when an exception occurs.
     *
     * @category IotJobs
     */
    subscribeToUpdateJobExecutionAccepted(request, qos, messageHandler) {
        return __awaiter(this, void 0, void 0, function* () {
            let topic = "$aws/things/{thingName}/jobs/{jobId}/update/accepted";
            topic = topic.replace("{jobId}", request.jobId);
            topic = topic.replace("{thingName}", request.thingName);
            const on_message = (topic, payload) => {
                let response;
                let error;
                try {
                    const payload_text = this.decoder.decode(payload);
                    response = JSON.parse(payload_text);
                }
                catch (err) {
                    error = new IotJobsError(err.message, payload);
                }
                finally {
                    messageHandler(error, response);
                }
            };
            return this.connection.subscribe(topic, qos, on_message);
        });
    }
    /**
     * API Documentation: https://docs.aws.amazon.com/iot/latest/developerguide/jobs-api.html#mqtt-updatejobexecution
     * Publish UpdateJobExecution message
     * If the device is offline, the PUBLISH packet will be sent once the connection resumes.
     *
     * @param request Message to be serialized and sent
     * @param qos Quality of Service for delivering this message
     * @returns Promise which returns a `mqtt.MqttRequest` which will contain the packet id of
     *          the PUBLISH packet.
     *
     * * For QoS 0, completes as soon as the packet is sent.
     * * For QoS 1, completes when PUBACK is received.
     * * QoS 2 is not supported by AWS IoT.
     *
     * @category IotJobs
     */
    publishUpdateJobExecution(request, qos) {
        return __awaiter(this, void 0, void 0, function* () {
            let topic = "$aws/things/{thingName}/jobs/{jobId}/update";
            topic = topic.replace("{thingName}", request.thingName);
            topic = topic.replace("{jobId}", request.jobId);
            return this.connection.publish(topic, JSON.stringify(request), qos);
        });
    }
    /**
     * API Documentation: https://docs.aws.amazon.com/iot/latest/developerguide/jobs-api.html#mqtt-describejobexecution
     *
     * Subscribe to DescribeJobExecutionAccepted messages
     *
     * subscribeToDescribeJobExecutionAccepted may be called while the device is offline, though the async
     * operation cannot complete successfully until the connection resumes.
     *
     * Once subscribed, `messageHandler` is invoked each time a message matching
     * the `topic` is received. It is possible for such messages to arrive before
     * the SUBACK is received.
     *
     * @param request Subscription request configuration
     * @param qos Maximum requested QoS that server may use when sending messages to the client.
     *            The server may grant a lower QoS in the SUBACK
     * @param messageHandler Callback invoked when message or error is received from the server.
     * @returns Promise which returns a `mqtt.MqttSubscribeRequest` which will contain the
     *          result of the SUBSCRIBE. The Promise resolves when a SUBACK is returned
     *          from the server or is rejected when an exception occurs.
     *
     * @category IotJobs
     */
    subscribeToDescribeJobExecutionAccepted(request, qos, messageHandler) {
        return __awaiter(this, void 0, void 0, function* () {
            let topic = "$aws/things/{thingName}/jobs/{jobId}/get/accepted";
            topic = topic.replace("{thingName}", request.thingName);
            topic = topic.replace("{jobId}", request.jobId);
            const on_message = (topic, payload) => {
                let response;
                let error;
                try {
                    const payload_text = this.decoder.decode(payload);
                    response = JSON.parse(payload_text);
                }
                catch (err) {
                    error = new IotJobsError(err.message, payload);
                }
                finally {
                    messageHandler(error, response);
                }
            };
            return this.connection.subscribe(topic, qos, on_message);
        });
    }
    /**
     * API Documentation: https://docs.aws.amazon.com/iot/latest/developerguide/jobs-api.html#mqtt-getpendingjobexecutions
     * Publish GetPendingJobExecutions message
     * If the device is offline, the PUBLISH packet will be sent once the connection resumes.
     *
     * @param request Message to be serialized and sent
     * @param qos Quality of Service for delivering this message
     * @returns Promise which returns a `mqtt.MqttRequest` which will contain the packet id of
     *          the PUBLISH packet.
     *
     * * For QoS 0, completes as soon as the packet is sent.
     * * For QoS 1, completes when PUBACK is received.
     * * QoS 2 is not supported by AWS IoT.
     *
     * @category IotJobs
     */
    publishGetPendingJobExecutions(request, qos) {
        return __awaiter(this, void 0, void 0, function* () {
            let topic = "$aws/things/{thingName}/jobs/get";
            topic = topic.replace("{thingName}", request.thingName);
            return this.connection.publish(topic, JSON.stringify(request), qos);
        });
    }
    /**
     * API Documentation: https://docs.aws.amazon.com/iot/latest/developerguide/jobs-api.html#mqtt-getpendingjobexecutions
     *
     * Subscribe to GetPendingJobExecutionsAccepted messages
     *
     * subscribeToGetPendingJobExecutionsAccepted may be called while the device is offline, though the async
     * operation cannot complete successfully until the connection resumes.
     *
     * Once subscribed, `messageHandler` is invoked each time a message matching
     * the `topic` is received. It is possible for such messages to arrive before
     * the SUBACK is received.
     *
     * @param request Subscription request configuration
     * @param qos Maximum requested QoS that server may use when sending messages to the client.
     *            The server may grant a lower QoS in the SUBACK
     * @param messageHandler Callback invoked when message or error is received from the server.
     * @returns Promise which returns a `mqtt.MqttSubscribeRequest` which will contain the
     *          result of the SUBSCRIBE. The Promise resolves when a SUBACK is returned
     *          from the server or is rejected when an exception occurs.
     *
     * @category IotJobs
     */
    subscribeToGetPendingJobExecutionsAccepted(request, qos, messageHandler) {
        return __awaiter(this, void 0, void 0, function* () {
            let topic = "$aws/things/{thingName}/jobs/get/accepted";
            topic = topic.replace("{thingName}", request.thingName);
            const on_message = (topic, payload) => {
                let response;
                let error;
                try {
                    const payload_text = this.decoder.decode(payload);
                    response = JSON.parse(payload_text);
                }
                catch (err) {
                    error = new IotJobsError(err.message, payload);
                }
                finally {
                    messageHandler(error, response);
                }
            };
            return this.connection.subscribe(topic, qos, on_message);
        });
    }
    /**
     * API Documentation: https://docs.aws.amazon.com/iot/latest/developerguide/jobs-api.html#mqtt-startnextpendingjobexecution
     *
     * Subscribe to StartNextPendingJobExecutionRejected messages
     *
     * subscribeToStartNextPendingJobExecutionRejected may be called while the device is offline, though the async
     * operation cannot complete successfully until the connection resumes.
     *
     * Once subscribed, `messageHandler` is invoked each time a message matching
     * the `topic` is received. It is possible for such messages to arrive before
     * the SUBACK is received.
     *
     * @param request Subscription request configuration
     * @param qos Maximum requested QoS that server may use when sending messages to the client.
     *            The server may grant a lower QoS in the SUBACK
     * @param messageHandler Callback invoked when message or error is received from the server.
     * @returns Promise which returns a `mqtt.MqttSubscribeRequest` which will contain the
     *          result of the SUBSCRIBE. The Promise resolves when a SUBACK is returned
     *          from the server or is rejected when an exception occurs.
     *
     * @category IotJobs
     */
    subscribeToStartNextPendingJobExecutionRejected(request, qos, messageHandler) {
        return __awaiter(this, void 0, void 0, function* () {
            let topic = "$aws/things/{thingName}/jobs/start-next/rejected";
            topic = topic.replace("{thingName}", request.thingName);
            const on_message = (topic, payload) => {
                let response;
                let error;
                try {
                    const payload_text = this.decoder.decode(payload);
                    response = JSON.parse(payload_text);
                }
                catch (err) {
                    error = new IotJobsError(err.message, payload);
                }
                finally {
                    messageHandler(error, response);
                }
            };
            return this.connection.subscribe(topic, qos, on_message);
        });
    }
    /**
     * API Documentation: https://docs.aws.amazon.com/iot/latest/developerguide/jobs-api.html#mqtt-getpendingjobexecutions
     *
     * Subscribe to GetPendingJobExecutionsRejected messages
     *
     * subscribeToGetPendingJobExecutionsRejected may be called while the device is offline, though the async
     * operation cannot complete successfully until the connection resumes.
     *
     * Once subscribed, `messageHandler` is invoked each time a message matching
     * the `topic` is received. It is possible for such messages to arrive before
     * the SUBACK is received.
     *
     * @param request Subscription request configuration
     * @param qos Maximum requested QoS that server may use when sending messages to the client.
     *            The server may grant a lower QoS in the SUBACK
     * @param messageHandler Callback invoked when message or error is received from the server.
     * @returns Promise which returns a `mqtt.MqttSubscribeRequest` which will contain the
     *          result of the SUBSCRIBE. The Promise resolves when a SUBACK is returned
     *          from the server or is rejected when an exception occurs.
     *
     * @category IotJobs
     */
    subscribeToGetPendingJobExecutionsRejected(request, qos, messageHandler) {
        return __awaiter(this, void 0, void 0, function* () {
            let topic = "$aws/things/{thingName}/jobs/get/rejected";
            topic = topic.replace("{thingName}", request.thingName);
            const on_message = (topic, payload) => {
                let response;
                let error;
                try {
                    const payload_text = this.decoder.decode(payload);
                    response = JSON.parse(payload_text);
                }
                catch (err) {
                    error = new IotJobsError(err.message, payload);
                }
                finally {
                    messageHandler(error, response);
                }
            };
            return this.connection.subscribe(topic, qos, on_message);
        });
    }
    /**
     * API Documentation: https://docs.aws.amazon.com/iot/latest/developerguide/jobs-api.html#mqtt-startnextpendingjobexecution
     * Publish StartNextPendingJobExecution message
     * If the device is offline, the PUBLISH packet will be sent once the connection resumes.
     *
     * @param request Message to be serialized and sent
     * @param qos Quality of Service for delivering this message
     * @returns Promise which returns a `mqtt.MqttRequest` which will contain the packet id of
     *          the PUBLISH packet.
     *
     * * For QoS 0, completes as soon as the packet is sent.
     * * For QoS 1, completes when PUBACK is received.
     * * QoS 2 is not supported by AWS IoT.
     *
     * @category IotJobs
     */
    publishStartNextPendingJobExecution(request, qos) {
        return __awaiter(this, void 0, void 0, function* () {
            let topic = "$aws/things/{thingName}/jobs/start-next";
            topic = topic.replace("{thingName}", request.thingName);
            return this.connection.publish(topic, JSON.stringify(request), qos);
        });
    }
    /**
     * API Documentation: https://docs.aws.amazon.com/iot/latest/developerguide/jobs-api.html#mqtt-describejobexecution
     * Publish DescribeJobExecution message
     * If the device is offline, the PUBLISH packet will be sent once the connection resumes.
     *
     * @param request Message to be serialized and sent
     * @param qos Quality of Service for delivering this message
     * @returns Promise which returns a `mqtt.MqttRequest` which will contain the packet id of
     *          the PUBLISH packet.
     *
     * * For QoS 0, completes as soon as the packet is sent.
     * * For QoS 1, completes when PUBACK is received.
     * * QoS 2 is not supported by AWS IoT.
     *
     * @category IotJobs
     */
    publishDescribeJobExecution(request, qos) {
        return __awaiter(this, void 0, void 0, function* () {
            let topic = "$aws/things/{thingName}/jobs/{jobId}/get";
            topic = topic.replace("{thingName}", request.thingName);
            topic = topic.replace("{jobId}", request.jobId);
            return this.connection.publish(topic, JSON.stringify(request), qos);
        });
    }
}
exports.IotJobsClient = IotJobsClient;
//# sourceMappingURL=iotjobsclient.js.map