// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.
'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
exports.BlobUploadNotificationError = exports.BlobSasError = void 0;
/**
 * @private
 * @class         module:azure-iot-device.BlobSasError
 * @classdesc     Error used when the client fails to get a blob shared access signature from the IoT Hub service.
 *
 * @params        {string}  message  Error message
 * @augments      {Error}
 */
class BlobSasError extends Error {
    constructor(message) {
        super(message);
        this.name = 'BlobSasError';
        this.message = message;
        Error.captureStackTrace(this, this.constructor);
    }
}
exports.BlobSasError = BlobSasError;
/**
 * @private
 * @class         module:azure-iot-device.BlobUploadNotificationError
 * @classdesc     Error used when the client fails to notify the IoT Hub service that the upload is complete.
 *
 * @params        {string}  message  Error message
 * @augments      {Error}
 */
class BlobUploadNotificationError extends Error {
    constructor(message) {
        super(message);
        this.message = message;
        this.name = 'BlobUploadNotificationError';
        Error.captureStackTrace(this, this.constructor);
    }
}
exports.BlobUploadNotificationError = BlobUploadNotificationError;
//# sourceMappingURL=blob_upload_errors.js.map