"use strict";
/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var msRest = require("@azure/ms-rest-js");
var Mappers = require("../models/configurationOperationsMappers");
var Parameters = require("../models/parameters");
/** Class representing a ConfigurationOperations. */
var ConfigurationOperations = /** @class */ (function () {
    /**
     * Create a ConfigurationOperations.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    function ConfigurationOperations(client) {
        this.client = client;
    }
    ConfigurationOperations.prototype.get = function (id, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            options: options
        }, getOperationSpec, callback);
    };
    ConfigurationOperations.prototype.createOrUpdate = function (id, configuration, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            configuration: configuration,
            options: options
        }, createOrUpdateOperationSpec, callback);
    };
    ConfigurationOperations.prototype.deleteMethod = function (id, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            options: options
        }, deleteMethodOperationSpec, callback);
    };
    ConfigurationOperations.prototype.getConfigurations = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, getConfigurationsOperationSpec, callback);
    };
    ConfigurationOperations.prototype.testQueries = function (input, options, callback) {
        return this.client.sendOperationRequest({
            input: input,
            options: options
        }, testQueriesOperationSpec, callback);
    };
    ConfigurationOperations.prototype.applyOnEdgeDevice = function (id, content, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            content: content,
            options: options
        }, applyOnEdgeDeviceOperationSpec, callback);
    };
    return ConfigurationOperations;
}());
exports.ConfigurationOperations = ConfigurationOperations;
// Operation Specifications
var serializer = new msRest.Serializer(Mappers);
var getOperationSpec = {
    httpMethod: "GET",
    path: "configurations/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: Mappers.Configuration
        },
        default: {}
    },
    serializer: serializer
};
var createOrUpdateOperationSpec = {
    httpMethod: "PUT",
    path: "configurations/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    headerParameters: [
        Parameters.ifMatch
    ],
    requestBody: {
        parameterPath: "configuration",
        mapper: __assign(__assign({}, Mappers.Configuration), { required: true })
    },
    responses: {
        200: {
            bodyMapper: Mappers.Configuration
        },
        201: {
            bodyMapper: Mappers.Configuration
        },
        default: {}
    },
    serializer: serializer
};
var deleteMethodOperationSpec = {
    httpMethod: "DELETE",
    path: "configurations/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    headerParameters: [
        Parameters.ifMatch
    ],
    responses: {
        204: {},
        default: {}
    },
    serializer: serializer
};
var getConfigurationsOperationSpec = {
    httpMethod: "GET",
    path: "configurations",
    queryParameters: [
        Parameters.top,
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: {
                serializedName: "parsedResponse",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "Configuration"
                        }
                    }
                }
            }
        },
        default: {}
    },
    serializer: serializer
};
var testQueriesOperationSpec = {
    httpMethod: "POST",
    path: "configurations/testQueries",
    queryParameters: [
        Parameters.apiVersion
    ],
    requestBody: {
        parameterPath: "input",
        mapper: __assign(__assign({}, Mappers.ConfigurationQueriesTestInput), { required: true })
    },
    responses: {
        200: {
            bodyMapper: Mappers.ConfigurationQueriesTestResponse
        },
        default: {}
    },
    serializer: serializer
};
var applyOnEdgeDeviceOperationSpec = {
    httpMethod: "POST",
    path: "devices/{id}/applyConfigurationContent",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    requestBody: {
        parameterPath: "content",
        mapper: __assign(__assign({}, Mappers.ConfigurationContent), { required: true })
    },
    responses: {
        204: {},
        default: {}
    },
    serializer: serializer
};
//# sourceMappingURL=configurationOperations.js.map