"use strict";
/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
Object.defineProperty(exports, "__esModule", { value: true });
var msRest = require("@azure/ms-rest-js");
var Mappers = require("../models/bulkRegistryMappers");
var Parameters = require("../models/parameters");
/** Class representing a BulkRegistry. */
var BulkRegistry = /** @class */ (function () {
    /**
     * Create a BulkRegistry.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    function BulkRegistry(client) {
        this.client = client;
    }
    BulkRegistry.prototype.updateRegistry = function (devices, options, callback) {
        return this.client.sendOperationRequest({
            devices: devices,
            options: options
        }, updateRegistryOperationSpec, callback);
    };
    return BulkRegistry;
}());
exports.BulkRegistry = BulkRegistry;
// Operation Specifications
var serializer = new msRest.Serializer(Mappers);
var updateRegistryOperationSpec = {
    httpMethod: "POST",
    path: "devices",
    queryParameters: [
        Parameters.apiVersion
    ],
    requestBody: {
        parameterPath: "devices",
        mapper: {
            required: true,
            serializedName: "devices",
            type: {
                name: "Sequence",
                element: {
                    type: {
                        name: "Composite",
                        className: "ExportImportDevice"
                    }
                }
            }
        }
    },
    responses: {
        200: {
            bodyMapper: Mappers.BulkRegistryOperationResult
        },
        400: {
            bodyMapper: Mappers.BulkRegistryOperationResult
        },
        default: {}
    },
    serializer: serializer
};
//# sourceMappingURL=bulkRegistry.js.map