"use strict";
/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var msRest = require("@azure/ms-rest-js");
var Mappers = require("../models/jobsMappers");
var Parameters = require("../models/parameters");
/** Class representing a Jobs. */
var Jobs = /** @class */ (function () {
    /**
     * Create a Jobs.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    function Jobs(client) {
        this.client = client;
    }
    Jobs.prototype.createImportExportJob = function (jobProperties, options, callback) {
        return this.client.sendOperationRequest({
            jobProperties: jobProperties,
            options: options
        }, createImportExportJobOperationSpec, callback);
    };
    Jobs.prototype.getImportExportJobs = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, getImportExportJobsOperationSpec, callback);
    };
    Jobs.prototype.getImportExportJob = function (id, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            options: options
        }, getImportExportJobOperationSpec, callback);
    };
    Jobs.prototype.cancelImportExportJob = function (id, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            options: options
        }, cancelImportExportJobOperationSpec, callback);
    };
    Jobs.prototype.getScheduledJob = function (id, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            options: options
        }, getScheduledJobOperationSpec, callback);
    };
    Jobs.prototype.createScheduledJob = function (id, jobRequest, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            jobRequest: jobRequest,
            options: options
        }, createScheduledJobOperationSpec, callback);
    };
    Jobs.prototype.cancelScheduledJob = function (id, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            options: options
        }, cancelScheduledJobOperationSpec, callback);
    };
    Jobs.prototype.queryScheduledJobs = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, queryScheduledJobsOperationSpec, callback);
    };
    return Jobs;
}());
exports.Jobs = Jobs;
// Operation Specifications
var serializer = new msRest.Serializer(Mappers);
var createImportExportJobOperationSpec = {
    httpMethod: "POST",
    path: "jobs/create",
    queryParameters: [
        Parameters.apiVersion
    ],
    requestBody: {
        parameterPath: "jobProperties",
        mapper: __assign(__assign({}, Mappers.JobProperties), { required: true })
    },
    responses: {
        200: {
            bodyMapper: Mappers.JobProperties
        },
        default: {}
    },
    serializer: serializer
};
var getImportExportJobsOperationSpec = {
    httpMethod: "GET",
    path: "jobs",
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: {
                serializedName: "parsedResponse",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "JobProperties"
                        }
                    }
                }
            }
        },
        default: {}
    },
    serializer: serializer
};
var getImportExportJobOperationSpec = {
    httpMethod: "GET",
    path: "jobs/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: Mappers.JobProperties
        },
        default: {}
    },
    serializer: serializer
};
var cancelImportExportJobOperationSpec = {
    httpMethod: "DELETE",
    path: "jobs/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: {
                serializedName: "parsedResponse",
                type: {
                    name: "Object"
                }
            }
        },
        204: {},
        default: {}
    },
    serializer: serializer
};
var getScheduledJobOperationSpec = {
    httpMethod: "GET",
    path: "jobs/v2/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: Mappers.JobResponse
        },
        default: {}
    },
    serializer: serializer
};
var createScheduledJobOperationSpec = {
    httpMethod: "PUT",
    path: "jobs/v2/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    requestBody: {
        parameterPath: "jobRequest",
        mapper: __assign(__assign({}, Mappers.JobRequest), { required: true })
    },
    responses: {
        200: {
            bodyMapper: Mappers.JobResponse
        },
        default: {}
    },
    serializer: serializer
};
var cancelScheduledJobOperationSpec = {
    httpMethod: "POST",
    path: "jobs/v2/{id}/cancel",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: Mappers.JobResponse
        },
        default: {}
    },
    serializer: serializer
};
var queryScheduledJobsOperationSpec = {
    httpMethod: "GET",
    path: "jobs/v2/query",
    queryParameters: [
        Parameters.jobType,
        Parameters.jobStatus,
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: Mappers.QueryResult
        },
        default: {}
    },
    serializer: serializer
};
//# sourceMappingURL=jobs.js.map