import * as msRest from "@azure/ms-rest-js";
import * as Models from "../models";
import { IotHubGatewayServiceAPIsContext } from "../iotHubGatewayServiceAPIsContext";
/** Class representing a Statistics. */
export declare class Statistics {
    private readonly client;
    /**
     * Create a Statistics.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    constructor(client: IotHubGatewayServiceAPIsContext);
    /**
     * Gets device statistics of the IoT Hub identity registry, such as total device count.
     * @param [options] The optional parameters
     * @returns Promise<Models.StatisticsGetDeviceStatisticsResponse>
     */
    getDeviceStatistics(options?: msRest.RequestOptionsBase): Promise<Models.StatisticsGetDeviceStatisticsResponse>;
    /**
     * @param callback The callback
     */
    getDeviceStatistics(callback: msRest.ServiceCallback<Models.RegistryStatistics>): void;
    /**
     * @param options The optional parameters
     * @param callback The callback
     */
    getDeviceStatistics(options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.RegistryStatistics>): void;
    /**
     * Gets service statistics of the IoT Hub identity registry, such as connected device count.
     * @param [options] The optional parameters
     * @returns Promise<Models.StatisticsGetServiceStatisticsResponse>
     */
    getServiceStatistics(options?: msRest.RequestOptionsBase): Promise<Models.StatisticsGetServiceStatisticsResponse>;
    /**
     * @param callback The callback
     */
    getServiceStatistics(callback: msRest.ServiceCallback<Models.ServiceStatistics>): void;
    /**
     * @param options The optional parameters
     * @param callback The callback
     */
    getServiceStatistics(options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.ServiceStatistics>): void;
}
