"use strict";
/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
Object.defineProperty(exports, "__esModule", { value: true });
var msRest = require("@azure/ms-rest-js");
var Mappers = require("../models/digitalTwinMappers");
var Parameters = require("../models/parameters");
/** Class representing a DigitalTwin. */
var DigitalTwin = /** @class */ (function () {
    /**
     * Create a DigitalTwin.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    function DigitalTwin(client) {
        this.client = client;
    }
    DigitalTwin.prototype.getDigitalTwin = function (id, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            options: options
        }, getDigitalTwinOperationSpec, callback);
    };
    DigitalTwin.prototype.updateDigitalTwin = function (id, digitalTwinPatch, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            digitalTwinPatch: digitalTwinPatch,
            options: options
        }, updateDigitalTwinOperationSpec, callback);
    };
    DigitalTwin.prototype.invokeRootLevelCommand = function (id, commandName, payload, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            commandName: commandName,
            payload: payload,
            options: options
        }, invokeRootLevelCommandOperationSpec, callback);
    };
    DigitalTwin.prototype.invokeComponentCommand = function (id, componentPath, commandName, payload, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            componentPath: componentPath,
            commandName: commandName,
            payload: payload,
            options: options
        }, invokeComponentCommandOperationSpec, callback);
    };
    return DigitalTwin;
}());
exports.DigitalTwin = DigitalTwin;
// Operation Specifications
var serializer = new msRest.Serializer(Mappers);
var getDigitalTwinOperationSpec = {
    httpMethod: "GET",
    path: "digitaltwins/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: {
                serializedName: "parsedResponse",
                type: {
                    name: "Object"
                }
            },
            headersMapper: Mappers.DigitalTwinGetDigitalTwinHeaders
        },
        default: {}
    },
    serializer: serializer
};
var updateDigitalTwinOperationSpec = {
    httpMethod: "PATCH",
    path: "digitaltwins/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    headerParameters: [
        Parameters.ifMatch
    ],
    requestBody: {
        parameterPath: "digitalTwinPatch",
        mapper: {
            required: true,
            serializedName: "digitalTwinPatch",
            type: {
                name: "Sequence",
                element: {
                    type: {
                        name: "Object"
                    }
                }
            }
        }
    },
    responses: {
        202: {
            headersMapper: Mappers.DigitalTwinUpdateDigitalTwinHeaders
        },
        default: {}
    },
    serializer: serializer
};
var invokeRootLevelCommandOperationSpec = {
    httpMethod: "POST",
    path: "digitaltwins/{id}/commands/{commandName}",
    urlParameters: [
        Parameters.id,
        Parameters.commandName
    ],
    queryParameters: [
        Parameters.apiVersion,
        Parameters.connectTimeoutInSeconds,
        Parameters.responseTimeoutInSeconds
    ],
    requestBody: {
        parameterPath: "payload",
        mapper: {
            required: true,
            serializedName: "payload",
            type: {
                name: "Object"
            }
        }
    },
    responses: {
        200: {
            bodyMapper: {
                serializedName: "parsedResponse",
                type: {
                    name: "Object"
                }
            },
            headersMapper: Mappers.DigitalTwinInvokeRootLevelCommandHeaders
        },
        default: {}
    },
    serializer: serializer
};
var invokeComponentCommandOperationSpec = {
    httpMethod: "POST",
    path: "digitaltwins/{id}/components/{componentPath}/commands/{commandName}",
    urlParameters: [
        Parameters.id,
        Parameters.componentPath,
        Parameters.commandName
    ],
    queryParameters: [
        Parameters.apiVersion,
        Parameters.connectTimeoutInSeconds,
        Parameters.responseTimeoutInSeconds
    ],
    requestBody: {
        parameterPath: "payload",
        mapper: {
            required: true,
            serializedName: "payload",
            type: {
                name: "Object"
            }
        }
    },
    responses: {
        200: {
            bodyMapper: {
                serializedName: "parsedResponse",
                type: {
                    name: "Object"
                }
            },
            headersMapper: Mappers.DigitalTwinInvokeComponentCommandHeaders
        },
        default: {}
    },
    serializer: serializer
};
//# sourceMappingURL=digitalTwin.js.map