"use strict";
/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var msRest = require("@azure/ms-rest-js");
var Mappers = require("../models/devicesMappers");
var Parameters = require("../models/parameters");
/** Class representing a Devices. */
var Devices = /** @class */ (function () {
    /**
     * Create a Devices.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    function Devices(client) {
        this.client = client;
    }
    Devices.prototype.getDevices = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, getDevicesOperationSpec, callback);
    };
    Devices.prototype.getIdentity = function (id, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            options: options
        }, getIdentityOperationSpec, callback);
    };
    Devices.prototype.createOrUpdateIdentity = function (id, device, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            device: device,
            options: options
        }, createOrUpdateIdentityOperationSpec, callback);
    };
    Devices.prototype.deleteIdentity = function (id, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            options: options
        }, deleteIdentityOperationSpec, callback);
    };
    Devices.prototype.getTwin = function (id, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            options: options
        }, getTwinOperationSpec, callback);
    };
    Devices.prototype.replaceTwin = function (id, deviceTwinInfo, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            deviceTwinInfo: deviceTwinInfo,
            options: options
        }, replaceTwinOperationSpec, callback);
    };
    Devices.prototype.updateTwin = function (id, deviceTwinInfo, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            deviceTwinInfo: deviceTwinInfo,
            options: options
        }, updateTwinOperationSpec, callback);
    };
    Devices.prototype.invokeMethod = function (deviceId, directMethodRequest, options, callback) {
        return this.client.sendOperationRequest({
            deviceId: deviceId,
            directMethodRequest: directMethodRequest,
            options: options
        }, invokeMethodOperationSpec, callback);
    };
    return Devices;
}());
exports.Devices = Devices;
// Operation Specifications
var serializer = new msRest.Serializer(Mappers);
var getDevicesOperationSpec = {
    httpMethod: "GET",
    path: "devices",
    queryParameters: [
        Parameters.top,
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: {
                serializedName: "parsedResponse",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "Device"
                        }
                    }
                }
            }
        },
        default: {}
    },
    serializer: serializer
};
var getIdentityOperationSpec = {
    httpMethod: "GET",
    path: "devices/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: Mappers.Device
        },
        default: {}
    },
    serializer: serializer
};
var createOrUpdateIdentityOperationSpec = {
    httpMethod: "PUT",
    path: "devices/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    headerParameters: [
        Parameters.ifMatch
    ],
    requestBody: {
        parameterPath: "device",
        mapper: __assign(__assign({}, Mappers.Device), { required: true })
    },
    responses: {
        200: {
            bodyMapper: Mappers.Device
        },
        default: {}
    },
    serializer: serializer
};
var deleteIdentityOperationSpec = {
    httpMethod: "DELETE",
    path: "devices/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    headerParameters: [
        Parameters.ifMatch
    ],
    responses: {
        204: {},
        default: {}
    },
    serializer: serializer
};
var getTwinOperationSpec = {
    httpMethod: "GET",
    path: "twins/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: Mappers.Twin
        },
        default: {}
    },
    serializer: serializer
};
var replaceTwinOperationSpec = {
    httpMethod: "PUT",
    path: "twins/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    headerParameters: [
        Parameters.ifMatch
    ],
    requestBody: {
        parameterPath: "deviceTwinInfo",
        mapper: __assign(__assign({}, Mappers.Twin), { required: true })
    },
    responses: {
        200: {
            bodyMapper: Mappers.Twin
        },
        default: {}
    },
    serializer: serializer
};
var updateTwinOperationSpec = {
    httpMethod: "PATCH",
    path: "twins/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    headerParameters: [
        Parameters.ifMatch
    ],
    requestBody: {
        parameterPath: "deviceTwinInfo",
        mapper: __assign(__assign({}, Mappers.Twin), { required: true })
    },
    responses: {
        200: {
            bodyMapper: Mappers.Twin
        },
        default: {}
    },
    serializer: serializer
};
var invokeMethodOperationSpec = {
    httpMethod: "POST",
    path: "twins/{deviceId}/methods",
    urlParameters: [
        Parameters.deviceId
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    requestBody: {
        parameterPath: "directMethodRequest",
        mapper: __assign(__assign({}, Mappers.CloudToDeviceMethod), { required: true })
    },
    responses: {
        200: {
            bodyMapper: Mappers.CloudToDeviceMethodResult
        },
        default: {}
    },
    serializer: serializer
};
//# sourceMappingURL=devices.js.map