import * as msRest from "@azure/ms-rest-js";
import * as Models from "../models";
import { IotHubGatewayServiceAPIsContext } from "../iotHubGatewayServiceAPIsContext";
/** Class representing a Modules. */
export declare class Modules {
    private readonly client;
    /**
     * Create a Modules.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    constructor(client: IotHubGatewayServiceAPIsContext);
    /**
     * Gets the module twin. See https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-device-twins
     * for more information.
     * @param id The unique identifier of the device.
     * @param mid The unique identifier of the module.
     * @param [options] The optional parameters
     * @returns Promise<Models.ModulesGetTwinResponse>
     */
    getTwin(id: string, mid: string, options?: msRest.RequestOptionsBase): Promise<Models.ModulesGetTwinResponse>;
    /**
     * @param id The unique identifier of the device.
     * @param mid The unique identifier of the module.
     * @param callback The callback
     */
    getTwin(id: string, mid: string, callback: msRest.ServiceCallback<Models.Twin>): void;
    /**
     * @param id The unique identifier of the device.
     * @param mid The unique identifier of the module.
     * @param options The optional parameters
     * @param callback The callback
     */
    getTwin(id: string, mid: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.Twin>): void;
    /**
     * Replaces the tags and desired properties of a module twin. See
     * https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-device-twins for more information.
     * @param id The unique identifier of the device.
     * @param mid The unique identifier of the module.
     * @param deviceTwinInfo The module twin info that will replace the existing info.
     * @param [options] The optional parameters
     * @returns Promise<Models.ModulesReplaceTwinResponse>
     */
    replaceTwin(id: string, mid: string, deviceTwinInfo: Models.Twin, options?: Models.ModulesReplaceTwinOptionalParams): Promise<Models.ModulesReplaceTwinResponse>;
    /**
     * @param id The unique identifier of the device.
     * @param mid The unique identifier of the module.
     * @param deviceTwinInfo The module twin info that will replace the existing info.
     * @param callback The callback
     */
    replaceTwin(id: string, mid: string, deviceTwinInfo: Models.Twin, callback: msRest.ServiceCallback<Models.Twin>): void;
    /**
     * @param id The unique identifier of the device.
     * @param mid The unique identifier of the module.
     * @param deviceTwinInfo The module twin info that will replace the existing info.
     * @param options The optional parameters
     * @param callback The callback
     */
    replaceTwin(id: string, mid: string, deviceTwinInfo: Models.Twin, options: Models.ModulesReplaceTwinOptionalParams, callback: msRest.ServiceCallback<Models.Twin>): void;
    /**
     * Updates the tags and desired properties of a module twin. See
     * https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-device-twins for more information.
     * @param id The unique identifier of the device.
     * @param mid The unique identifier of the module.
     * @param deviceTwinInfo The module twin info containing the tags and desired properties to be
     * updated.
     * @param [options] The optional parameters
     * @returns Promise<Models.ModulesUpdateTwinResponse>
     */
    updateTwin(id: string, mid: string, deviceTwinInfo: Models.Twin, options?: Models.ModulesUpdateTwinOptionalParams): Promise<Models.ModulesUpdateTwinResponse>;
    /**
     * @param id The unique identifier of the device.
     * @param mid The unique identifier of the module.
     * @param deviceTwinInfo The module twin info containing the tags and desired properties to be
     * updated.
     * @param callback The callback
     */
    updateTwin(id: string, mid: string, deviceTwinInfo: Models.Twin, callback: msRest.ServiceCallback<Models.Twin>): void;
    /**
     * @param id The unique identifier of the device.
     * @param mid The unique identifier of the module.
     * @param deviceTwinInfo The module twin info containing the tags and desired properties to be
     * updated.
     * @param options The optional parameters
     * @param callback The callback
     */
    updateTwin(id: string, mid: string, deviceTwinInfo: Models.Twin, options: Models.ModulesUpdateTwinOptionalParams, callback: msRest.ServiceCallback<Models.Twin>): void;
    /**
     * Gets all the module identities on the device.
     * @param id The unique identifier of the device.
     * @param [options] The optional parameters
     * @returns Promise<Models.ModulesGetModulesOnDeviceResponse>
     */
    getModulesOnDevice(id: string, options?: msRest.RequestOptionsBase): Promise<Models.ModulesGetModulesOnDeviceResponse>;
    /**
     * @param id The unique identifier of the device.
     * @param callback The callback
     */
    getModulesOnDevice(id: string, callback: msRest.ServiceCallback<Models.Module[]>): void;
    /**
     * @param id The unique identifier of the device.
     * @param options The optional parameters
     * @param callback The callback
     */
    getModulesOnDevice(id: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.Module[]>): void;
    /**
     * Gets a module identity on the device.
     * @param id The unique identifier of the device.
     * @param mid The unique identifier of the module.
     * @param [options] The optional parameters
     * @returns Promise<Models.ModulesGetIdentityResponse>
     */
    getIdentity(id: string, mid: string, options?: msRest.RequestOptionsBase): Promise<Models.ModulesGetIdentityResponse>;
    /**
     * @param id The unique identifier of the device.
     * @param mid The unique identifier of the module.
     * @param callback The callback
     */
    getIdentity(id: string, mid: string, callback: msRest.ServiceCallback<Models.Module>): void;
    /**
     * @param id The unique identifier of the device.
     * @param mid The unique identifier of the module.
     * @param options The optional parameters
     * @param callback The callback
     */
    getIdentity(id: string, mid: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.Module>): void;
    /**
     * Creates or updates the module identity for a device in the IoT Hub. The moduleId and
     * generationId cannot be updated by the user.
     * @param id The unique identifier of the device.
     * @param mid The unique identifier of the module.
     * @param module The module identity.
     * @param [options] The optional parameters
     * @returns Promise<Models.ModulesCreateOrUpdateIdentityResponse>
     */
    createOrUpdateIdentity(id: string, mid: string, module: Models.Module, options?: Models.ModulesCreateOrUpdateIdentityOptionalParams): Promise<Models.ModulesCreateOrUpdateIdentityResponse>;
    /**
     * @param id The unique identifier of the device.
     * @param mid The unique identifier of the module.
     * @param module The module identity.
     * @param callback The callback
     */
    createOrUpdateIdentity(id: string, mid: string, module: Models.Module, callback: msRest.ServiceCallback<Models.Module>): void;
    /**
     * @param id The unique identifier of the device.
     * @param mid The unique identifier of the module.
     * @param module The module identity.
     * @param options The optional parameters
     * @param callback The callback
     */
    createOrUpdateIdentity(id: string, mid: string, module: Models.Module, options: Models.ModulesCreateOrUpdateIdentityOptionalParams, callback: msRest.ServiceCallback<Models.Module>): void;
    /**
     * Deletes the module identity for a device in the IoT Hub.
     * @param id The unique identifier of the deivce.
     * @param mid The unique identifier of the module.
     * @param [options] The optional parameters
     * @returns Promise<msRest.RestResponse>
     */
    deleteIdentity(id: string, mid: string, options?: Models.ModulesDeleteIdentityOptionalParams): Promise<msRest.RestResponse>;
    /**
     * @param id The unique identifier of the deivce.
     * @param mid The unique identifier of the module.
     * @param callback The callback
     */
    deleteIdentity(id: string, mid: string, callback: msRest.ServiceCallback<void>): void;
    /**
     * @param id The unique identifier of the deivce.
     * @param mid The unique identifier of the module.
     * @param options The optional parameters
     * @param callback The callback
     */
    deleteIdentity(id: string, mid: string, options: Models.ModulesDeleteIdentityOptionalParams, callback: msRest.ServiceCallback<void>): void;
    /**
     * Invokes a direct method on a module of a device. See
     * https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-direct-methods for more information.
     * @param deviceId The unique identifier of the device.
     * @param moduleId The unique identifier of the module.
     * @param directMethodRequest The parameters to execute a direct method on the module.
     * @param [options] The optional parameters
     * @returns Promise<Models.ModulesInvokeMethodResponse>
     */
    invokeMethod(deviceId: string, moduleId: string, directMethodRequest: Models.CloudToDeviceMethod, options?: msRest.RequestOptionsBase): Promise<Models.ModulesInvokeMethodResponse>;
    /**
     * @param deviceId The unique identifier of the device.
     * @param moduleId The unique identifier of the module.
     * @param directMethodRequest The parameters to execute a direct method on the module.
     * @param callback The callback
     */
    invokeMethod(deviceId: string, moduleId: string, directMethodRequest: Models.CloudToDeviceMethod, callback: msRest.ServiceCallback<Models.CloudToDeviceMethodResult>): void;
    /**
     * @param deviceId The unique identifier of the device.
     * @param moduleId The unique identifier of the module.
     * @param directMethodRequest The parameters to execute a direct method on the module.
     * @param options The optional parameters
     * @param callback The callback
     */
    invokeMethod(deviceId: string, moduleId: string, directMethodRequest: Models.CloudToDeviceMethod, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.CloudToDeviceMethodResult>): void;
}
