import * as msRest from "@azure/ms-rest-js";
import * as Models from "../models";
import { IotHubGatewayServiceAPIsContext } from "../iotHubGatewayServiceAPIsContext";
/** Class representing a ConfigurationOperations. */
export declare class ConfigurationOperations {
    private readonly client;
    /**
     * Create a ConfigurationOperations.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    constructor(client: IotHubGatewayServiceAPIsContext);
    /**
     * Gets a configuration on the IoT Hub for automatic device/module management.
     * @param id The unique identifier of the configuration.
     * @param [options] The optional parameters
     * @returns Promise<Models.ConfigurationGetResponse>
     */
    get(id: string, options?: msRest.RequestOptionsBase): Promise<Models.ConfigurationGetResponse>;
    /**
     * @param id The unique identifier of the configuration.
     * @param callback The callback
     */
    get(id: string, callback: msRest.ServiceCallback<Models.Configuration>): void;
    /**
     * @param id The unique identifier of the configuration.
     * @param options The optional parameters
     * @param callback The callback
     */
    get(id: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.Configuration>): void;
    /**
     * Creates or updates a configuration on the IoT Hub for automatic device/module management.
     * Configuration identifier and Content cannot be updated.
     * @param id The unique identifier of the configuration.
     * @param configuration The configuration to be created or updated.
     * @param [options] The optional parameters
     * @returns Promise<Models.ConfigurationCreateOrUpdateResponse>
     */
    createOrUpdate(id: string, configuration: Models.Configuration, options?: Models.ConfigurationCreateOrUpdateOptionalParams): Promise<Models.ConfigurationCreateOrUpdateResponse>;
    /**
     * @param id The unique identifier of the configuration.
     * @param configuration The configuration to be created or updated.
     * @param callback The callback
     */
    createOrUpdate(id: string, configuration: Models.Configuration, callback: msRest.ServiceCallback<Models.Configuration>): void;
    /**
     * @param id The unique identifier of the configuration.
     * @param configuration The configuration to be created or updated.
     * @param options The optional parameters
     * @param callback The callback
     */
    createOrUpdate(id: string, configuration: Models.Configuration, options: Models.ConfigurationCreateOrUpdateOptionalParams, callback: msRest.ServiceCallback<Models.Configuration>): void;
    /**
     * Deletes a configuration on the IoT Hub for automatic device/module management.
     * @param id The unique identifier of the configuration.
     * @param [options] The optional parameters
     * @returns Promise<msRest.RestResponse>
     */
    deleteMethod(id: string, options?: Models.ConfigurationDeleteMethodOptionalParams): Promise<msRest.RestResponse>;
    /**
     * @param id The unique identifier of the configuration.
     * @param callback The callback
     */
    deleteMethod(id: string, callback: msRest.ServiceCallback<void>): void;
    /**
     * @param id The unique identifier of the configuration.
     * @param options The optional parameters
     * @param callback The callback
     */
    deleteMethod(id: string, options: Models.ConfigurationDeleteMethodOptionalParams, callback: msRest.ServiceCallback<void>): void;
    /**
     * Gets configurations on the IoT Hub for automatic device/module management. Pagination is not
     * supported.
     * @param [options] The optional parameters
     * @returns Promise<Models.ConfigurationGetConfigurationsResponse>
     */
    getConfigurations(options?: Models.ConfigurationGetConfigurationsOptionalParams): Promise<Models.ConfigurationGetConfigurationsResponse>;
    /**
     * @param callback The callback
     */
    getConfigurations(callback: msRest.ServiceCallback<Models.Configuration[]>): void;
    /**
     * @param options The optional parameters
     * @param callback The callback
     */
    getConfigurations(options: Models.ConfigurationGetConfigurationsOptionalParams, callback: msRest.ServiceCallback<Models.Configuration[]>): void;
    /**
     * Validates target condition and custom metric queries for a configuration on the IoT Hub.
     * @param input The configuration for target condition and custom metric queries.
     * @param [options] The optional parameters
     * @returns Promise<Models.ConfigurationTestQueriesResponse>
     */
    testQueries(input: Models.ConfigurationQueriesTestInput, options?: msRest.RequestOptionsBase): Promise<Models.ConfigurationTestQueriesResponse>;
    /**
     * @param input The configuration for target condition and custom metric queries.
     * @param callback The callback
     */
    testQueries(input: Models.ConfigurationQueriesTestInput, callback: msRest.ServiceCallback<Models.ConfigurationQueriesTestResponse>): void;
    /**
     * @param input The configuration for target condition and custom metric queries.
     * @param options The optional parameters
     * @param callback The callback
     */
    testQueries(input: Models.ConfigurationQueriesTestInput, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.ConfigurationQueriesTestResponse>): void;
    /**
     * Applies the configuration content to an edge device.
     * @param id The unique identifier of the edge device.
     * @param content The configuration content.
     * @param [options] The optional parameters
     * @returns Promise<msRest.RestResponse>
     */
    applyOnEdgeDevice(id: string, content: Models.ConfigurationContent, options?: msRest.RequestOptionsBase): Promise<msRest.RestResponse>;
    /**
     * @param id The unique identifier of the edge device.
     * @param content The configuration content.
     * @param callback The callback
     */
    applyOnEdgeDevice(id: string, content: Models.ConfigurationContent, callback: msRest.ServiceCallback<void>): void;
    /**
     * @param id The unique identifier of the edge device.
     * @param content The configuration content.
     * @param options The optional parameters
     * @param callback The callback
     */
    applyOnEdgeDevice(id: string, content: Models.ConfigurationContent, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<void>): void;
}
