/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

import * as msRest from "@azure/ms-rest-js";
import * as Models from "../models";
import * as Mappers from "../models/bulkRegistryMappers";
import * as Parameters from "../models/parameters";
import { IotHubGatewayServiceAPIsContext } from "../iotHubGatewayServiceAPIsContext";

/** Class representing a BulkRegistry. */
export class BulkRegistry {
  private readonly client: IotHubGatewayServiceAPIsContext;

  /**
   * Create a BulkRegistry.
   * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
   */
  constructor(client: IotHubGatewayServiceAPIsContext) {
    this.client = client;
  }

  /**
   * Creates, updates, or deletes the identities of multiple devices from the IoT Hub identity
   * registry. A device identity can be specified only once in the list. Different operations
   * (create, update, delete) on different devices are allowed. A maximum of 100 devices can be
   * specified per invocation. For large scale operations, use the import feature using blob storage
   * (https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities).
   * @param devices The registry operations to perform.
   * @param [options] The optional parameters
   * @returns Promise<Models.BulkRegistryUpdateRegistryResponse>
   */
  updateRegistry(devices: Models.ExportImportDevice[], options?: msRest.RequestOptionsBase): Promise<Models.BulkRegistryUpdateRegistryResponse>;
  /**
   * @param devices The registry operations to perform.
   * @param callback The callback
   */
  updateRegistry(devices: Models.ExportImportDevice[], callback: msRest.ServiceCallback<Models.BulkRegistryOperationResult>): void;
  /**
   * @param devices The registry operations to perform.
   * @param options The optional parameters
   * @param callback The callback
   */
  updateRegistry(devices: Models.ExportImportDevice[], options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.BulkRegistryOperationResult>): void;
  updateRegistry(devices: Models.ExportImportDevice[], options?: msRest.RequestOptionsBase | msRest.ServiceCallback<Models.BulkRegistryOperationResult>, callback?: msRest.ServiceCallback<Models.BulkRegistryOperationResult>): Promise<Models.BulkRegistryUpdateRegistryResponse> {
    return this.client.sendOperationRequest(
      {
        devices,
        options
      },
      updateRegistryOperationSpec,
      callback) as Promise<Models.BulkRegistryUpdateRegistryResponse>;
  }
}

// Operation Specifications
const serializer = new msRest.Serializer(Mappers);
const updateRegistryOperationSpec: msRest.OperationSpec = {
  httpMethod: "POST",
  path: "devices",
  queryParameters: [
    Parameters.apiVersion
  ],
  requestBody: {
    parameterPath: "devices",
    mapper: {
      required: true,
      serializedName: "devices",
      type: {
        name: "Sequence",
        element: {
          type: {
            name: "Composite",
            className: "ExportImportDevice"
          }
        }
      }
    }
  },
  responses: {
    200: {
      bodyMapper: Mappers.BulkRegistryOperationResult
    },
    400: {
      bodyMapper: Mappers.BulkRegistryOperationResult
    },
    default: {}
  },
  serializer
};
